/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response from CreateTopic action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateTopicResponse extends SNSResponse implements
        ToCopyableBuilder<CreateTopicResponse.Builder, CreateTopicResponse> {
    private final String topicArn;

    private CreateTopicResponse(BuilderImpl builder) {
        super(builder);
        this.topicArn = builder.topicArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) assigned to the created topic.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) assigned to the created topic.
     */
    public String topicArn() {
        return topicArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(topicArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTopicResponse)) {
            return false;
        }
        CreateTopicResponse other = (CreateTopicResponse) obj;
        return Objects.equals(topicArn(), other.topicArn());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateTopicResponse").add("TopicArn", topicArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicArn":
            return Optional.of(clazz.cast(topicArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SNSResponse.Builder, CopyableBuilder<Builder, CreateTopicResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) assigned to the created topic.
         * </p>
         * 
         * @param topicArn
         *        The Amazon Resource Name (ARN) assigned to the created topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);
    }

    static final class BuilderImpl extends SNSResponse.BuilderImpl implements Builder {
        private String topicArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTopicResponse model) {
            topicArn(model.topicArn);
        }

        public final String getTopicArn() {
            return topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public CreateTopicResponse build() {
            return new CreateTopicResponse(this);
        }
    }
}
