/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for Unsubscribe action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UnsubscribeRequest extends SNSRequest implements ToCopyableBuilder<UnsubscribeRequest.Builder, UnsubscribeRequest> {
    private final String subscriptionArn;

    private UnsubscribeRequest(BuilderImpl builder) {
        super(builder);
        this.subscriptionArn = builder.subscriptionArn;
    }

    /**
     * <p>
     * The ARN of the subscription to be deleted.
     * </p>
     * 
     * @return The ARN of the subscription to be deleted.
     */
    public String subscriptionArn() {
        return subscriptionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnsubscribeRequest)) {
            return false;
        }
        UnsubscribeRequest other = (UnsubscribeRequest) obj;
        return Objects.equals(subscriptionArn(), other.subscriptionArn());
    }

    @Override
    public String toString() {
        return ToString.builder("UnsubscribeRequest").add("SubscriptionArn", subscriptionArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubscriptionArn":
            return Optional.of(clazz.cast(subscriptionArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SNSRequest.Builder, CopyableBuilder<Builder, UnsubscribeRequest> {
        /**
         * <p>
         * The ARN of the subscription to be deleted.
         * </p>
         * 
         * @param subscriptionArn
         *        The ARN of the subscription to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionArn(String subscriptionArn);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SNSRequest.BuilderImpl implements Builder {
        private String subscriptionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UnsubscribeRequest model) {
            subscriptionArn(model.subscriptionArn);
        }

        public final String getSubscriptionArn() {
            return subscriptionArn;
        }

        @Override
        public final Builder subscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
            return this;
        }

        public final void setSubscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UnsubscribeRequest build() {
            return new UnsubscribeRequest(this);
        }
    }
}
