/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.sns.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ListTopicsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListTopicsResponseUnmarshaller implements Unmarshaller<ListTopicsResponse, StaxUnmarshallerContext> {

    public ListTopicsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListTopicsResponse.Builder listTopicsResponse = ListTopicsResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.List<Topic> topics = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                listTopicsResponse.topics(topics);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Topics", targetDepth)) {
                    topics = new ArrayList<Topic>();
                    continue;
                }

                if (context.testExpression("Topics/member", targetDepth)) {
                    topics.add(TopicUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextToken", targetDepth)) {
                    listTopicsResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    listTopicsResponse.topics(topics);
                    break;
                }
            }
        }
        return listTopicsResponse.build();
    }

    private static final ListTopicsResponseUnmarshaller INSTANCE = new ListTopicsResponseUnmarshaller();

    public static ListTopicsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
