/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.sns.SNSClient;
import software.amazon.awssdk.services.sns.model.Endpoint;
import software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationRequest;
import software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationResponse;

public class ListEndpointsByPlatformApplicationIterable
implements SdkIterable<ListEndpointsByPlatformApplicationResponse> {
    private final SNSClient client;
    private final ListEndpointsByPlatformApplicationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEndpointsByPlatformApplicationIterable(SNSClient client, ListEndpointsByPlatformApplicationRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEndpointsByPlatformApplicationResponseFetcher();
    }

    public Iterator<ListEndpointsByPlatformApplicationResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Endpoint> endpoints() {
        Function<ListEndpointsByPlatformApplicationResponse, Iterator> getIterator = response -> {
            if (response != null && response.endpoints() != null) {
                return response.endpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListEndpointsByPlatformApplicationIterable resume(ListEndpointsByPlatformApplicationResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListEndpointsByPlatformApplicationIterable(this.client, (ListEndpointsByPlatformApplicationRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListEndpointsByPlatformApplicationIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListEndpointsByPlatformApplicationResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListEndpointsByPlatformApplicationResponseFetcher
    implements SyncPageFetcher<ListEndpointsByPlatformApplicationResponse> {
        private ListEndpointsByPlatformApplicationResponseFetcher() {
        }

        public boolean hasNextPage(ListEndpointsByPlatformApplicationResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListEndpointsByPlatformApplicationResponse nextPage(ListEndpointsByPlatformApplicationResponse previousPage) {
            if (previousPage == null) {
                return ListEndpointsByPlatformApplicationIterable.this.client.listEndpointsByPlatformApplication(ListEndpointsByPlatformApplicationIterable.this.firstRequest);
            }
            return ListEndpointsByPlatformApplicationIterable.this.client.listEndpointsByPlatformApplication((ListEndpointsByPlatformApplicationRequest)((Object)ListEndpointsByPlatformApplicationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

