/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.sns.SNSClient;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicRequest;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicResponse;
import software.amazon.awssdk.services.sns.model.Subscription;

public class ListSubscriptionsByTopicIterable
implements SdkIterable<ListSubscriptionsByTopicResponse> {
    private final SNSClient client;
    private final ListSubscriptionsByTopicRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSubscriptionsByTopicIterable(SNSClient client, ListSubscriptionsByTopicRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSubscriptionsByTopicResponseFetcher();
    }

    public Iterator<ListSubscriptionsByTopicResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Subscription> subscriptions() {
        Function<ListSubscriptionsByTopicResponse, Iterator> getIterator = response -> {
            if (response != null && response.subscriptions() != null) {
                return response.subscriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListSubscriptionsByTopicIterable resume(ListSubscriptionsByTopicResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListSubscriptionsByTopicIterable(this.client, (ListSubscriptionsByTopicRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListSubscriptionsByTopicIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListSubscriptionsByTopicResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListSubscriptionsByTopicResponseFetcher
    implements SyncPageFetcher<ListSubscriptionsByTopicResponse> {
        private ListSubscriptionsByTopicResponseFetcher() {
        }

        public boolean hasNextPage(ListSubscriptionsByTopicResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListSubscriptionsByTopicResponse nextPage(ListSubscriptionsByTopicResponse previousPage) {
            if (previousPage == null) {
                return ListSubscriptionsByTopicIterable.this.client.listSubscriptionsByTopic(ListSubscriptionsByTopicIterable.this.firstRequest);
            }
            return ListSubscriptionsByTopicIterable.this.client.listSubscriptionsByTopic((ListSubscriptionsByTopicRequest)((Object)ListSubscriptionsByTopicIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

