/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response for GetTopicAttributes action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTopicAttributesResponse extends SnsResponse implements
        ToCopyableBuilder<GetTopicAttributesResponse.Builder, GetTopicAttributesResponse> {
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(GetTopicAttributesResponse::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD));

    private final Map<String, String> attributes;

    private GetTopicAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * A map of the topic's attributes. Attributes in this map include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DeliveryPolicy</code> – The JSON serialization of the topic's delivery policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DisplayName</code> – The human-readable name used in the <code>From</code> field for notifications to
     * <code>email</code> and <code>email-json</code> endpoints.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Owner</code> – The AWS account ID of the topic's owner.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Policy</code> – The JSON serialization of the topic's access control policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SubscriptionsConfirmed</code> – The number of confirmed subscriptions for the topic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SubscriptionsDeleted</code> – The number of deleted subscriptions for the topic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SubscriptionsPending</code> – The number of subscriptions pending confirmation for the topic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TopicArn</code> – The topic's ARN.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EffectiveDeliveryPolicy</code> – Yhe JSON serialization of the effective delivery policy, taking system
     * defaults into account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attribute applies only to <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html">server-side-encryption</a>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KmsMasterKeyId</code> - The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a custom CMK.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms">Key Terms</a>. For
     * more examples, see <a href=
     * "https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters"
     * >KeyId</a> in the <i>AWS Key Management Service API Reference</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of the topic's attributes. Attributes in this map include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DeliveryPolicy</code> – The JSON serialization of the topic's delivery policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DisplayName</code> – The human-readable name used in the <code>From</code> field for notifications
     *         to <code>email</code> and <code>email-json</code> endpoints.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Owner</code> – The AWS account ID of the topic's owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Policy</code> – The JSON serialization of the topic's access control policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SubscriptionsConfirmed</code> – The number of confirmed subscriptions for the topic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SubscriptionsDeleted</code> – The number of deleted subscriptions for the topic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SubscriptionsPending</code> – The number of subscriptions pending confirmation for the topic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TopicArn</code> – The topic's ARN.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EffectiveDeliveryPolicy</code> – Yhe JSON serialization of the effective delivery policy, taking
     *         system defaults into account.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attribute applies only to <a
     *         href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html"
     *         >server-side-encryption</a>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>KmsMasterKeyId</code> - The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a
     *         custom CMK. For more information, see <a
     *         href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms">Key
     *         Terms</a>. For more examples, see <a href=
     *         "https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters"
     *         >KeyId</a> in the <i>AWS Key Management Service API Reference</i>.
     *         </p>
     *         </li>
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTopicAttributesResponse)) {
            return false;
        }
        GetTopicAttributesResponse other = (GetTopicAttributesResponse) obj;
        return Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetTopicAttributesResponse").add("Attributes", attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTopicAttributesResponse, T> g) {
        return obj -> g.apply((GetTopicAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTopicAttributesResponse> {
        /**
         * <p>
         * A map of the topic's attributes. Attributes in this map include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DeliveryPolicy</code> – The JSON serialization of the topic's delivery policy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DisplayName</code> – The human-readable name used in the <code>From</code> field for notifications to
         * <code>email</code> and <code>email-json</code> endpoints.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Owner</code> – The AWS account ID of the topic's owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Policy</code> – The JSON serialization of the topic's access control policy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SubscriptionsConfirmed</code> – The number of confirmed subscriptions for the topic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SubscriptionsDeleted</code> – The number of deleted subscriptions for the topic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SubscriptionsPending</code> – The number of subscriptions pending confirmation for the topic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TopicArn</code> – The topic's ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EffectiveDeliveryPolicy</code> – Yhe JSON serialization of the effective delivery policy, taking system
         * defaults into account.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attribute applies only to <a
         * href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html">server-side-encryption</a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KmsMasterKeyId</code> - The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a custom
         * CMK. For more information, see <a
         * href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms">Key Terms</a>.
         * For more examples, see <a href=
         * "https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters"
         * >KeyId</a> in the <i>AWS Key Management Service API Reference</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributes
         *        A map of the topic's attributes. Attributes in this map include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DeliveryPolicy</code> – The JSON serialization of the topic's delivery policy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DisplayName</code> – The human-readable name used in the <code>From</code> field for
         *        notifications to <code>email</code> and <code>email-json</code> endpoints.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Owner</code> – The AWS account ID of the topic's owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Policy</code> – The JSON serialization of the topic's access control policy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SubscriptionsConfirmed</code> – The number of confirmed subscriptions for the topic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SubscriptionsDeleted</code> – The number of deleted subscriptions for the topic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SubscriptionsPending</code> – The number of subscriptions pending confirmation for the topic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TopicArn</code> – The topic's ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EffectiveDeliveryPolicy</code> – Yhe JSON serialization of the effective delivery policy, taking
         *        system defaults into account.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attribute applies only to <a
         *        href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html"
         *        >server-side-encryption</a>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KmsMasterKeyId</code> - The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a
         *        custom CMK. For more information, see <a
         *        href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms">Key
         *        Terms</a>. For more examples, see <a href=
         *        "https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters"
         *        >KeyId</a> in the <i>AWS Key Management Service API Reference</i>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);
    }

    static final class BuilderImpl extends SnsResponse.BuilderImpl implements Builder {
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTopicAttributesResponse model) {
            super(model);
            attributes(model.attributes);
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = TopicAttributesMapCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = TopicAttributesMapCopier.copy(attributes);
        }

        @Override
        public GetTopicAttributesResponse build() {
            return new GetTopicAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
