/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for ConfirmSubscription action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfirmSubscriptionRequest extends SnsRequest implements
        ToCopyableBuilder<ConfirmSubscriptionRequest.Builder, ConfirmSubscriptionRequest> {
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicArn").getter(getter(ConfirmSubscriptionRequest::topicArn)).setter(setter(Builder::topicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()).build();

    private static final SdkField<String> TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Token")
            .getter(getter(ConfirmSubscriptionRequest::token)).setter(setter(Builder::token))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Token").build()).build();

    private static final SdkField<String> AUTHENTICATE_ON_UNSUBSCRIBE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticateOnUnsubscribe").getter(getter(ConfirmSubscriptionRequest::authenticateOnUnsubscribe))
            .setter(setter(Builder::authenticateOnUnsubscribe))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticateOnUnsubscribe").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_ARN_FIELD, TOKEN_FIELD,
            AUTHENTICATE_ON_UNSUBSCRIBE_FIELD));

    private final String topicArn;

    private final String token;

    private final String authenticateOnUnsubscribe;

    private ConfirmSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.topicArn = builder.topicArn;
        this.token = builder.token;
        this.authenticateOnUnsubscribe = builder.authenticateOnUnsubscribe;
    }

    /**
     * <p>
     * The ARN of the topic for which you wish to confirm a subscription.
     * </p>
     * 
     * @return The ARN of the topic for which you wish to confirm a subscription.
     */
    public String topicArn() {
        return topicArn;
    }

    /**
     * <p>
     * Short-lived token sent to an endpoint during the <code>Subscribe</code> action.
     * </p>
     * 
     * @return Short-lived token sent to an endpoint during the <code>Subscribe</code> action.
     */
    public String token() {
        return token;
    }

    /**
     * <p>
     * Disallows unauthenticated unsubscribes of the subscription. If the value of this parameter is <code>true</code>
     * and the request has an AWS signature, then only the topic owner and the subscription owner can unsubscribe the
     * endpoint. The unsubscribe action requires AWS authentication.
     * </p>
     * 
     * @return Disallows unauthenticated unsubscribes of the subscription. If the value of this parameter is
     *         <code>true</code> and the request has an AWS signature, then only the topic owner and the subscription
     *         owner can unsubscribe the endpoint. The unsubscribe action requires AWS authentication.
     */
    public String authenticateOnUnsubscribe() {
        return authenticateOnUnsubscribe;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(token());
        hashCode = 31 * hashCode + Objects.hashCode(authenticateOnUnsubscribe());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfirmSubscriptionRequest)) {
            return false;
        }
        ConfirmSubscriptionRequest other = (ConfirmSubscriptionRequest) obj;
        return Objects.equals(topicArn(), other.topicArn()) && Objects.equals(token(), other.token())
                && Objects.equals(authenticateOnUnsubscribe(), other.authenticateOnUnsubscribe());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConfirmSubscriptionRequest").add("TopicArn", topicArn()).add("Token", token())
                .add("AuthenticateOnUnsubscribe", authenticateOnUnsubscribe()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicArn":
            return Optional.ofNullable(clazz.cast(topicArn()));
        case "Token":
            return Optional.ofNullable(clazz.cast(token()));
        case "AuthenticateOnUnsubscribe":
            return Optional.ofNullable(clazz.cast(authenticateOnUnsubscribe()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfirmSubscriptionRequest, T> g) {
        return obj -> g.apply((ConfirmSubscriptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ConfirmSubscriptionRequest> {
        /**
         * <p>
         * The ARN of the topic for which you wish to confirm a subscription.
         * </p>
         * 
         * @param topicArn
         *        The ARN of the topic for which you wish to confirm a subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * Short-lived token sent to an endpoint during the <code>Subscribe</code> action.
         * </p>
         * 
         * @param token
         *        Short-lived token sent to an endpoint during the <code>Subscribe</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder token(String token);

        /**
         * <p>
         * Disallows unauthenticated unsubscribes of the subscription. If the value of this parameter is
         * <code>true</code> and the request has an AWS signature, then only the topic owner and the subscription owner
         * can unsubscribe the endpoint. The unsubscribe action requires AWS authentication.
         * </p>
         * 
         * @param authenticateOnUnsubscribe
         *        Disallows unauthenticated unsubscribes of the subscription. If the value of this parameter is
         *        <code>true</code> and the request has an AWS signature, then only the topic owner and the subscription
         *        owner can unsubscribe the endpoint. The unsubscribe action requires AWS authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticateOnUnsubscribe(String authenticateOnUnsubscribe);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SnsRequest.BuilderImpl implements Builder {
        private String topicArn;

        private String token;

        private String authenticateOnUnsubscribe;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfirmSubscriptionRequest model) {
            super(model);
            topicArn(model.topicArn);
            token(model.token);
            authenticateOnUnsubscribe(model.authenticateOnUnsubscribe);
        }

        public final String getTopicArn() {
            return topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getToken() {
            return token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        public final String getAuthenticateOnUnsubscribe() {
            return authenticateOnUnsubscribe;
        }

        @Override
        public final Builder authenticateOnUnsubscribe(String authenticateOnUnsubscribe) {
            this.authenticateOnUnsubscribe = authenticateOnUnsubscribe;
            return this;
        }

        public final void setAuthenticateOnUnsubscribe(String authenticateOnUnsubscribe) {
            this.authenticateOnUnsubscribe = authenticateOnUnsubscribe;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConfirmSubscriptionRequest build() {
            return new ConfirmSubscriptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
