/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response from the <code>CheckIfPhoneNumberIsOptedOut</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckIfPhoneNumberIsOptedOutResponse extends SnsResponse implements
        ToCopyableBuilder<CheckIfPhoneNumberIsOptedOutResponse.Builder, CheckIfPhoneNumberIsOptedOutResponse> {
    private static final SdkField<Boolean> IS_OPTED_OUT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isOptedOut").getter(getter(CheckIfPhoneNumberIsOptedOutResponse::isOptedOut))
            .setter(setter(Builder::isOptedOut))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isOptedOut").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_OPTED_OUT_FIELD));

    private final Boolean isOptedOut;

    private CheckIfPhoneNumberIsOptedOutResponse(BuilderImpl builder) {
        super(builder);
        this.isOptedOut = builder.isOptedOut;
    }

    /**
     * <p>
     * Indicates whether the phone number is opted out:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>true</code> – The phone number is opted out, meaning you cannot publish SMS messages to it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>false</code> – The phone number is opted in, meaning you can publish SMS messages to it.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates whether the phone number is opted out:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>true</code> – The phone number is opted out, meaning you cannot publish SMS messages to it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>false</code> – The phone number is opted in, meaning you can publish SMS messages to it.
     *         </p>
     *         </li>
     */
    public final Boolean isOptedOut() {
        return isOptedOut;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(isOptedOut());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckIfPhoneNumberIsOptedOutResponse)) {
            return false;
        }
        CheckIfPhoneNumberIsOptedOutResponse other = (CheckIfPhoneNumberIsOptedOutResponse) obj;
        return Objects.equals(isOptedOut(), other.isOptedOut());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CheckIfPhoneNumberIsOptedOutResponse").add("IsOptedOut", isOptedOut()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isOptedOut":
            return Optional.ofNullable(clazz.cast(isOptedOut()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CheckIfPhoneNumberIsOptedOutResponse, T> g) {
        return obj -> g.apply((CheckIfPhoneNumberIsOptedOutResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CheckIfPhoneNumberIsOptedOutResponse> {
        /**
         * <p>
         * Indicates whether the phone number is opted out:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>true</code> – The phone number is opted out, meaning you cannot publish SMS messages to it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>false</code> – The phone number is opted in, meaning you can publish SMS messages to it.
         * </p>
         * </li>
         * </ul>
         * 
         * @param isOptedOut
         *        Indicates whether the phone number is opted out:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>true</code> – The phone number is opted out, meaning you cannot publish SMS messages to it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>false</code> – The phone number is opted in, meaning you can publish SMS messages to it.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isOptedOut(Boolean isOptedOut);
    }

    static final class BuilderImpl extends SnsResponse.BuilderImpl implements Builder {
        private Boolean isOptedOut;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckIfPhoneNumberIsOptedOutResponse model) {
            super(model);
            isOptedOut(model.isOptedOut);
        }

        public final Boolean getIsOptedOut() {
            return isOptedOut;
        }

        @Override
        public final Builder isOptedOut(Boolean isOptedOut) {
            this.isOptedOut = isOptedOut;
            return this;
        }

        public final void setIsOptedOut(Boolean isOptedOut) {
            this.isOptedOut = isOptedOut;
        }

        @Override
        public CheckIfPhoneNumberIsOptedOutResponse build() {
            return new CheckIfPhoneNumberIsOptedOutResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
