/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A verified or pending destination phone number in the SMS sandbox.
 * </p>
 * <p>
 * When you start using Amazon SNS to send SMS messages, your account is in the <i>SMS sandbox</i>. The SMS sandbox
 * provides a safe environment for you to try Amazon SNS features without risking your reputation as an SMS sender.
 * While your account is in the SMS sandbox, you can use all of the features of Amazon SNS. However, you can send SMS
 * messages only to verified destination phone numbers. For more information, including how to move out of the sandbox
 * to send messages without restrictions, see <a
 * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">SMS sandbox</a> in the <i>Amazon SNS Developer
 * Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SMSSandboxPhoneNumber implements SdkPojo, Serializable,
        ToCopyableBuilder<SMSSandboxPhoneNumber.Builder, SMSSandboxPhoneNumber> {
    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumber").getter(getter(SMSSandboxPhoneNumber::phoneNumber)).setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(SMSSandboxPhoneNumber::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_FIELD,
            STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String phoneNumber;

    private final String status;

    private SMSSandboxPhoneNumber(BuilderImpl builder) {
        this.phoneNumber = builder.phoneNumber;
        this.status = builder.status;
    }

    /**
     * <p>
     * The destination phone number.
     * </p>
     * 
     * @return The destination phone number.
     */
    public final String phoneNumber() {
        return phoneNumber;
    }

    /**
     * <p>
     * The destination phone number's verification status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SMSSandboxPhoneNumberVerificationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The destination phone number's verification status.
     * @see SMSSandboxPhoneNumberVerificationStatus
     */
    public final SMSSandboxPhoneNumberVerificationStatus status() {
        return SMSSandboxPhoneNumberVerificationStatus.fromValue(status);
    }

    /**
     * <p>
     * The destination phone number's verification status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SMSSandboxPhoneNumberVerificationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The destination phone number's verification status.
     * @see SMSSandboxPhoneNumberVerificationStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SMSSandboxPhoneNumber)) {
            return false;
        }
        SMSSandboxPhoneNumber other = (SMSSandboxPhoneNumber) obj;
        return Objects.equals(phoneNumber(), other.phoneNumber()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SMSSandboxPhoneNumber").add("PhoneNumber", phoneNumber()).add("Status", statusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SMSSandboxPhoneNumber, T> g) {
        return obj -> g.apply((SMSSandboxPhoneNumber) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SMSSandboxPhoneNumber> {
        /**
         * <p>
         * The destination phone number.
         * </p>
         * 
         * @param phoneNumber
         *        The destination phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * The destination phone number's verification status.
         * </p>
         * 
         * @param status
         *        The destination phone number's verification status.
         * @see SMSSandboxPhoneNumberVerificationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SMSSandboxPhoneNumberVerificationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The destination phone number's verification status.
         * </p>
         * 
         * @param status
         *        The destination phone number's verification status.
         * @see SMSSandboxPhoneNumberVerificationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SMSSandboxPhoneNumberVerificationStatus
         */
        Builder status(SMSSandboxPhoneNumberVerificationStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String phoneNumber;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SMSSandboxPhoneNumber model) {
            phoneNumber(model.phoneNumber);
            status(model.status);
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SMSSandboxPhoneNumberVerificationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public SMSSandboxPhoneNumber build() {
            return new SMSSandboxPhoneNumber(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
