/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOriginationNumbersResponse extends SnsResponse implements
        ToCopyableBuilder<ListOriginationNumbersResponse.Builder, ListOriginationNumbersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListOriginationNumbersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<PhoneNumberInformation>> PHONE_NUMBERS_FIELD = SdkField
            .<List<PhoneNumberInformation>> builder(MarshallingType.LIST)
            .memberName("PhoneNumbers")
            .getter(getter(ListOriginationNumbersResponse::phoneNumbers))
            .setter(setter(Builder::phoneNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumbers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PhoneNumberInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhoneNumberInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PHONE_NUMBERS_FIELD));

    private final String nextToken;

    private final List<PhoneNumberInformation> phoneNumbers;

    private ListOriginationNumbersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.phoneNumbers = builder.phoneNumbers;
    }

    /**
     * <p>
     * A <code>NextToken</code> string is returned when you call the <code>ListOriginationNumbers</code> operation if
     * additional pages of records are available.
     * </p>
     * 
     * @return A <code>NextToken</code> string is returned when you call the <code>ListOriginationNumbers</code>
     *         operation if additional pages of records are available.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the PhoneNumbers property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPhoneNumbers() {
        return phoneNumbers != null && !(phoneNumbers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the calling account's verified and pending origination numbers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPhoneNumbers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the calling account's verified and pending origination numbers.
     */
    public final List<PhoneNumberInformation> phoneNumbers() {
        return phoneNumbers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasPhoneNumbers() ? phoneNumbers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOriginationNumbersResponse)) {
            return false;
        }
        ListOriginationNumbersResponse other = (ListOriginationNumbersResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasPhoneNumbers() == other.hasPhoneNumbers()
                && Objects.equals(phoneNumbers(), other.phoneNumbers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOriginationNumbersResponse").add("NextToken", nextToken())
                .add("PhoneNumbers", hasPhoneNumbers() ? phoneNumbers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "PhoneNumbers":
            return Optional.ofNullable(clazz.cast(phoneNumbers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOriginationNumbersResponse, T> g) {
        return obj -> g.apply((ListOriginationNumbersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListOriginationNumbersResponse> {
        /**
         * <p>
         * A <code>NextToken</code> string is returned when you call the <code>ListOriginationNumbers</code> operation
         * if additional pages of records are available.
         * </p>
         * 
         * @param nextToken
         *        A <code>NextToken</code> string is returned when you call the <code>ListOriginationNumbers</code>
         *        operation if additional pages of records are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of the calling account's verified and pending origination numbers.
         * </p>
         * 
         * @param phoneNumbers
         *        A list of the calling account's verified and pending origination numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumbers(Collection<PhoneNumberInformation> phoneNumbers);

        /**
         * <p>
         * A list of the calling account's verified and pending origination numbers.
         * </p>
         * 
         * @param phoneNumbers
         *        A list of the calling account's verified and pending origination numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumbers(PhoneNumberInformation... phoneNumbers);

        /**
         * <p>
         * A list of the calling account's verified and pending origination numbers.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PhoneNumberInformation>.Builder} avoiding
         * the need to create one manually via {@link List<PhoneNumberInformation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PhoneNumberInformation>.Builder#build()} is called
         * immediately and its result is passed to {@link #phoneNumbers(List<PhoneNumberInformation>)}.
         * 
         * @param phoneNumbers
         *        a consumer that will call methods on {@link List<PhoneNumberInformation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phoneNumbers(List<PhoneNumberInformation>)
         */
        Builder phoneNumbers(Consumer<PhoneNumberInformation.Builder>... phoneNumbers);
    }

    static final class BuilderImpl extends SnsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<PhoneNumberInformation> phoneNumbers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListOriginationNumbersResponse model) {
            super(model);
            nextToken(model.nextToken);
            phoneNumbers(model.phoneNumbers);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final List<PhoneNumberInformation.Builder> getPhoneNumbers() {
            List<PhoneNumberInformation.Builder> result = PhoneNumberInformationListCopier.copyToBuilder(this.phoneNumbers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder phoneNumbers(Collection<PhoneNumberInformation> phoneNumbers) {
            this.phoneNumbers = PhoneNumberInformationListCopier.copy(phoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(PhoneNumberInformation... phoneNumbers) {
            phoneNumbers(Arrays.asList(phoneNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(Consumer<PhoneNumberInformation.Builder>... phoneNumbers) {
            phoneNumbers(Stream.of(phoneNumbers).map(c -> PhoneNumberInformation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPhoneNumbers(Collection<PhoneNumberInformation.BuilderImpl> phoneNumbers) {
            this.phoneNumbers = PhoneNumberInformationListCopier.copyFromBuilder(phoneNumbers);
        }

        @Override
        public ListOriginationNumbersResponse build() {
            return new ListOriginationNumbersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
