/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sns.model.SnsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PublishResponse
extends SnsResponse
implements ToCopyableBuilder<Builder, PublishResponse> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageId").getter(PublishResponse.getter(PublishResponse::messageId)).setter(PublishResponse.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()}).build();
    private static final SdkField<String> SEQUENCE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SequenceNumber").getter(PublishResponse.getter(PublishResponse::sequenceNumber)).setter(PublishResponse.setter(Builder::sequenceNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SequenceNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD, SEQUENCE_NUMBER_FIELD));
    private final String messageId;
    private final String sequenceNumber;

    private PublishResponse(BuilderImpl builder) {
        super(builder);
        this.messageId = builder.messageId;
        this.sequenceNumber = builder.sequenceNumber;
    }

    public final String messageId() {
        return this.messageId;
    }

    public final String sequenceNumber() {
        return this.sequenceNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishResponse)) {
            return false;
        }
        PublishResponse other = (PublishResponse)((Object)obj);
        return Objects.equals(this.messageId(), other.messageId()) && Objects.equals(this.sequenceNumber(), other.sequenceNumber());
    }

    public final String toString() {
        return ToString.builder((String)"PublishResponse").add("MessageId", (Object)this.messageId()).add("SequenceNumber", (Object)this.sequenceNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MessageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
            case "SequenceNumber": {
                return Optional.ofNullable(clazz.cast(this.sequenceNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublishResponse, T> g) {
        return obj -> g.apply((PublishResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnsResponse.BuilderImpl
    implements Builder {
        private String messageId;
        private String sequenceNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishResponse model) {
            super(model);
            this.messageId(model.messageId);
            this.sequenceNumber(model.sequenceNumber);
        }

        public final String getMessageId() {
            return this.messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        @Transient
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final String getSequenceNumber() {
            return this.sequenceNumber;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        @Override
        @Transient
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        @Override
        public PublishResponse build() {
            return new PublishResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SnsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PublishResponse> {
        public Builder messageId(String var1);

        public Builder sequenceNumber(String var1);
    }
}

