/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for SetPlatformApplicationAttributes action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetPlatformApplicationAttributesRequest extends SnsRequest implements
        ToCopyableBuilder<SetPlatformApplicationAttributesRequest.Builder, SetPlatformApplicationAttributesRequest> {
    private static final SdkField<String> PLATFORM_APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformApplicationArn").getter(getter(SetPlatformApplicationAttributesRequest::platformApplicationArn))
            .setter(setter(Builder::platformApplicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformApplicationArn").build())
            .build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Attributes")
            .getter(getter(SetPlatformApplicationAttributesRequest::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PLATFORM_APPLICATION_ARN_FIELD, ATTRIBUTES_FIELD));

    private final String platformApplicationArn;

    private final Map<String, String> attributes;

    private SetPlatformApplicationAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.platformApplicationArn = builder.platformApplicationArn;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * PlatformApplicationArn for SetPlatformApplicationAttributes action.
     * </p>
     * 
     * @return PlatformApplicationArn for SetPlatformApplicationAttributes action.
     */
    public final String platformApplicationArn() {
        return platformApplicationArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of the platform application attributes. Attributes in this map include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PlatformCredential</code> – The credential received from the notification service.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For ADM, <code>PlatformCredential</code>is client secret.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Apple Services using certificate credentials, <code>PlatformCredential</code> is private key.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Apple Services using token credentials, <code>PlatformCredential</code> is signing key.
     * </p>
     * </li>
     * <li>
     * <p>
     * For GCM (Firebase Cloud Messaging), <code>PlatformCredential</code> is API key.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>PlatformPrincipal</code> – The principal received from the notification service.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For ADM, <code>PlatformPrincipal</code>is client id.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Apple Services using certificate credentials, <code>PlatformPrincipal</code> is SSL certificate.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Apple Services using token credentials, <code>PlatformPrincipal</code> is signing key ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * For GCM (Firebase Cloud Messaging), there is no <code>PlatformPrincipal</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>EventEndpointCreated</code> – Topic ARN to which <code>EndpointCreated</code> event notifications are sent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EventEndpointDeleted</code> – Topic ARN to which <code>EndpointDeleted</code> event notifications are sent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EventEndpointUpdated</code> – Topic ARN to which <code>EndpointUpdate</code> event notifications are sent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EventDeliveryFailure</code> – Topic ARN to which <code>DeliveryFailure</code> event notifications are sent
     * upon Direct Publish delivery failure (permanent) to one of the application's endpoints.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SuccessFeedbackRoleArn</code> – IAM role ARN used to give Amazon SNS write access to use CloudWatch Logs on
     * your behalf.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FailureFeedbackRoleArn</code> – IAM role ARN used to give Amazon SNS write access to use CloudWatch Logs on
     * your behalf.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SuccessFeedbackSampleRate</code> – Sample rate percentage (0-100) of successfully delivered messages.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes only apply to <code>APNs</code> token-based authentication:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ApplePlatformTeamID</code> – The identifier that's assigned to your Apple developer account team.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ApplePlatformBundleID</code> – The bundle identifier that's assigned to your iOS app.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return A map of the platform application attributes. Attributes in this map include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PlatformCredential</code> – The credential received from the notification service.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For ADM, <code>PlatformCredential</code>is client secret.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For Apple Services using certificate credentials, <code>PlatformCredential</code> is private key.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For Apple Services using token credentials, <code>PlatformCredential</code> is signing key.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For GCM (Firebase Cloud Messaging), <code>PlatformCredential</code> is API key.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PlatformPrincipal</code> – The principal received from the notification service.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For ADM, <code>PlatformPrincipal</code>is client id.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For Apple Services using certificate credentials, <code>PlatformPrincipal</code> is SSL certificate.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For Apple Services using token credentials, <code>PlatformPrincipal</code> is signing key ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For GCM (Firebase Cloud Messaging), there is no <code>PlatformPrincipal</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EventEndpointCreated</code> – Topic ARN to which <code>EndpointCreated</code> event notifications
     *         are sent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EventEndpointDeleted</code> – Topic ARN to which <code>EndpointDeleted</code> event notifications
     *         are sent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EventEndpointUpdated</code> – Topic ARN to which <code>EndpointUpdate</code> event notifications
     *         are sent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EventDeliveryFailure</code> – Topic ARN to which <code>DeliveryFailure</code> event notifications
     *         are sent upon Direct Publish delivery failure (permanent) to one of the application's endpoints.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SuccessFeedbackRoleArn</code> – IAM role ARN used to give Amazon SNS write access to use CloudWatch
     *         Logs on your behalf.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FailureFeedbackRoleArn</code> – IAM role ARN used to give Amazon SNS write access to use CloudWatch
     *         Logs on your behalf.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SuccessFeedbackSampleRate</code> – Sample rate percentage (0-100) of successfully delivered
     *         messages.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attributes only apply to <code>APNs</code> token-based authentication:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ApplePlatformTeamID</code> – The identifier that's assigned to your Apple developer account team.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ApplePlatformBundleID</code> – The bundle identifier that's assigned to your iOS app.
     *         </p>
     *         </li>
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(platformApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetPlatformApplicationAttributesRequest)) {
            return false;
        }
        SetPlatformApplicationAttributesRequest other = (SetPlatformApplicationAttributesRequest) obj;
        return Objects.equals(platformApplicationArn(), other.platformApplicationArn())
                && hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetPlatformApplicationAttributesRequest")
                .add("PlatformApplicationArn", platformApplicationArn()).add("Attributes", hasAttributes() ? attributes() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlatformApplicationArn":
            return Optional.ofNullable(clazz.cast(platformApplicationArn()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetPlatformApplicationAttributesRequest, T> g) {
        return obj -> g.apply((SetPlatformApplicationAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SetPlatformApplicationAttributesRequest> {
        /**
         * <p>
         * PlatformApplicationArn for SetPlatformApplicationAttributes action.
         * </p>
         * 
         * @param platformApplicationArn
         *        PlatformApplicationArn for SetPlatformApplicationAttributes action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformApplicationArn(String platformApplicationArn);

        /**
         * <p>
         * A map of the platform application attributes. Attributes in this map include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PlatformCredential</code> – The credential received from the notification service.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For ADM, <code>PlatformCredential</code>is client secret.
         * </p>
         * </li>
         * <li>
         * <p>
         * For Apple Services using certificate credentials, <code>PlatformCredential</code> is private key.
         * </p>
         * </li>
         * <li>
         * <p>
         * For Apple Services using token credentials, <code>PlatformCredential</code> is signing key.
         * </p>
         * </li>
         * <li>
         * <p>
         * For GCM (Firebase Cloud Messaging), <code>PlatformCredential</code> is API key.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>PlatformPrincipal</code> – The principal received from the notification service.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For ADM, <code>PlatformPrincipal</code>is client id.
         * </p>
         * </li>
         * <li>
         * <p>
         * For Apple Services using certificate credentials, <code>PlatformPrincipal</code> is SSL certificate.
         * </p>
         * </li>
         * <li>
         * <p>
         * For Apple Services using token credentials, <code>PlatformPrincipal</code> is signing key ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * For GCM (Firebase Cloud Messaging), there is no <code>PlatformPrincipal</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>EventEndpointCreated</code> – Topic ARN to which <code>EndpointCreated</code> event notifications are
         * sent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EventEndpointDeleted</code> – Topic ARN to which <code>EndpointDeleted</code> event notifications are
         * sent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EventEndpointUpdated</code> – Topic ARN to which <code>EndpointUpdate</code> event notifications are
         * sent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EventDeliveryFailure</code> – Topic ARN to which <code>DeliveryFailure</code> event notifications are
         * sent upon Direct Publish delivery failure (permanent) to one of the application's endpoints.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SuccessFeedbackRoleArn</code> – IAM role ARN used to give Amazon SNS write access to use CloudWatch
         * Logs on your behalf.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FailureFeedbackRoleArn</code> – IAM role ARN used to give Amazon SNS write access to use CloudWatch
         * Logs on your behalf.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SuccessFeedbackSampleRate</code> – Sample rate percentage (0-100) of successfully delivered messages.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attributes only apply to <code>APNs</code> token-based authentication:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ApplePlatformTeamID</code> – The identifier that's assigned to your Apple developer account team.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApplePlatformBundleID</code> – The bundle identifier that's assigned to your iOS app.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributes
         *        A map of the platform application attributes. Attributes in this map include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PlatformCredential</code> – The credential received from the notification service.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For ADM, <code>PlatformCredential</code>is client secret.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For Apple Services using certificate credentials, <code>PlatformCredential</code> is private key.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For Apple Services using token credentials, <code>PlatformCredential</code> is signing key.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For GCM (Firebase Cloud Messaging), <code>PlatformCredential</code> is API key.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PlatformPrincipal</code> – The principal received from the notification service.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For ADM, <code>PlatformPrincipal</code>is client id.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For Apple Services using certificate credentials, <code>PlatformPrincipal</code> is SSL certificate.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For Apple Services using token credentials, <code>PlatformPrincipal</code> is signing key ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For GCM (Firebase Cloud Messaging), there is no <code>PlatformPrincipal</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EventEndpointCreated</code> – Topic ARN to which <code>EndpointCreated</code> event
         *        notifications are sent.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EventEndpointDeleted</code> – Topic ARN to which <code>EndpointDeleted</code> event
         *        notifications are sent.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EventEndpointUpdated</code> – Topic ARN to which <code>EndpointUpdate</code> event notifications
         *        are sent.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EventDeliveryFailure</code> – Topic ARN to which <code>DeliveryFailure</code> event
         *        notifications are sent upon Direct Publish delivery failure (permanent) to one of the application's
         *        endpoints.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SuccessFeedbackRoleArn</code> – IAM role ARN used to give Amazon SNS write access to use
         *        CloudWatch Logs on your behalf.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FailureFeedbackRoleArn</code> – IAM role ARN used to give Amazon SNS write access to use
         *        CloudWatch Logs on your behalf.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SuccessFeedbackSampleRate</code> – Sample rate percentage (0-100) of successfully delivered
         *        messages.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes only apply to <code>APNs</code> token-based authentication:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ApplePlatformTeamID</code> – The identifier that's assigned to your Apple developer account
         *        team.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApplePlatformBundleID</code> – The bundle identifier that's assigned to your iOS app.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SnsRequest.BuilderImpl implements Builder {
        private String platformApplicationArn;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SetPlatformApplicationAttributesRequest model) {
            super(model);
            platformApplicationArn(model.platformApplicationArn);
            attributes(model.attributes);
        }

        public final String getPlatformApplicationArn() {
            return platformApplicationArn;
        }

        public final void setPlatformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
        }

        @Override
        @Transient
        public final Builder platformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
        }

        @Override
        @Transient
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetPlatformApplicationAttributesRequest build() {
            return new SetPlatformApplicationAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
