/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicRequest;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicResponse;
import software.amazon.awssdk.services.sns.model.Subscription;

public class ListSubscriptionsByTopicIterable
implements SdkIterable<ListSubscriptionsByTopicResponse> {
    private final SnsClient client;
    private final ListSubscriptionsByTopicRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSubscriptionsByTopicIterable(SnsClient client, ListSubscriptionsByTopicRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSubscriptionsByTopicResponseFetcher();
    }

    public Iterator<ListSubscriptionsByTopicResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Subscription> subscriptions() {
        Function<ListSubscriptionsByTopicResponse, Iterator> getIterator = response -> {
            if (response != null && response.subscriptions() != null) {
                return response.subscriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSubscriptionsByTopicResponseFetcher
    implements SyncPageFetcher<ListSubscriptionsByTopicResponse> {
        private ListSubscriptionsByTopicResponseFetcher() {
        }

        public boolean hasNextPage(ListSubscriptionsByTopicResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSubscriptionsByTopicResponse nextPage(ListSubscriptionsByTopicResponse previousPage) {
            if (previousPage == null) {
                return ListSubscriptionsByTopicIterable.this.client.listSubscriptionsByTopic(ListSubscriptionsByTopicIterable.this.firstRequest);
            }
            return ListSubscriptionsByTopicIterable.this.client.listSubscriptionsByTopic((ListSubscriptionsByTopicRequest)((Object)ListSubscriptionsByTopicIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

