/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataProtectionPolicyResponse extends SnsResponse implements
        ToCopyableBuilder<GetDataProtectionPolicyResponse.Builder, GetDataProtectionPolicyResponse> {
    private static final SdkField<String> DATA_PROTECTION_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataProtectionPolicy").getter(getter(GetDataProtectionPolicyResponse::dataProtectionPolicy))
            .setter(setter(Builder::dataProtectionPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProtectionPolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_PROTECTION_POLICY_FIELD));

    private final String dataProtectionPolicy;

    private GetDataProtectionPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.dataProtectionPolicy = builder.dataProtectionPolicy;
    }

    /**
     * <p>
     * Retrieves the <code>DataProtectionPolicy</code> in JSON string format.
     * </p>
     * 
     * @return Retrieves the <code>DataProtectionPolicy</code> in JSON string format.
     */
    public final String dataProtectionPolicy() {
        return dataProtectionPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataProtectionPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataProtectionPolicyResponse)) {
            return false;
        }
        GetDataProtectionPolicyResponse other = (GetDataProtectionPolicyResponse) obj;
        return Objects.equals(dataProtectionPolicy(), other.dataProtectionPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataProtectionPolicyResponse").add("DataProtectionPolicy", dataProtectionPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataProtectionPolicy":
            return Optional.ofNullable(clazz.cast(dataProtectionPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDataProtectionPolicyResponse, T> g) {
        return obj -> g.apply((GetDataProtectionPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDataProtectionPolicyResponse> {
        /**
         * <p>
         * Retrieves the <code>DataProtectionPolicy</code> in JSON string format.
         * </p>
         * 
         * @param dataProtectionPolicy
         *        Retrieves the <code>DataProtectionPolicy</code> in JSON string format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProtectionPolicy(String dataProtectionPolicy);
    }

    static final class BuilderImpl extends SnsResponse.BuilderImpl implements Builder {
        private String dataProtectionPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataProtectionPolicyResponse model) {
            super(model);
            dataProtectionPolicy(model.dataProtectionPolicy);
        }

        public final String getDataProtectionPolicy() {
            return dataProtectionPolicy;
        }

        public final void setDataProtectionPolicy(String dataProtectionPolicy) {
            this.dataProtectionPolicy = dataProtectionPolicy;
        }

        @Override
        public final Builder dataProtectionPolicy(String dataProtectionPolicy) {
            this.dataProtectionPolicy = dataProtectionPolicy;
            return this;
        }

        @Override
        public GetDataProtectionPolicyResponse build() {
            return new GetDataProtectionPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
