/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response for ListTopics action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTopicsResponse extends SnsResponse implements
        ToCopyableBuilder<ListTopicsResponse.Builder, ListTopicsResponse> {
    private static final SdkField<List<Topic>> TOPICS_FIELD = SdkField
            .<List<Topic>> builder(MarshallingType.LIST)
            .memberName("Topics")
            .getter(getter(ListTopicsResponse::topics))
            .setter(setter(Builder::topics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Topics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Topic> builder(MarshallingType.SDK_POJO)
                                            .constructor(Topic::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTopicsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TOPICS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Topics", TOPICS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<Topic> topics;

    private final String nextToken;

    private ListTopicsResponse(BuilderImpl builder) {
        super(builder);
        this.topics = builder.topics;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Topics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTopics() {
        return topics != null && !(topics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of topic ARNs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTopics} method.
     * </p>
     * 
     * @return A list of topic ARNs.
     */
    public final List<Topic> topics() {
        return topics;
    }

    /**
     * <p>
     * Token to pass along to the next <code>ListTopics</code> request. This element is returned if there are additional
     * topics to retrieve.
     * </p>
     * 
     * @return Token to pass along to the next <code>ListTopics</code> request. This element is returned if there are
     *         additional topics to retrieve.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTopics() ? topics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTopicsResponse)) {
            return false;
        }
        ListTopicsResponse other = (ListTopicsResponse) obj;
        return hasTopics() == other.hasTopics() && Objects.equals(topics(), other.topics())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTopicsResponse").add("Topics", hasTopics() ? topics() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Topics":
            return Optional.ofNullable(clazz.cast(topics()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListTopicsResponse, T> g) {
        return obj -> g.apply((ListTopicsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTopicsResponse> {
        /**
         * <p>
         * A list of topic ARNs.
         * </p>
         * 
         * @param topics
         *        A list of topic ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topics(Collection<Topic> topics);

        /**
         * <p>
         * A list of topic ARNs.
         * </p>
         * 
         * @param topics
         *        A list of topic ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topics(Topic... topics);

        /**
         * <p>
         * A list of topic ARNs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sns.model.Topic.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.sns.model.Topic#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.sns.model.Topic.Builder#build()}
         * is called immediately and its result is passed to {@link #topics(List<Topic>)}.
         * 
         * @param topics
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.sns.model.Topic.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topics(java.util.Collection<Topic>)
         */
        Builder topics(Consumer<Topic.Builder>... topics);

        /**
         * <p>
         * Token to pass along to the next <code>ListTopics</code> request. This element is returned if there are
         * additional topics to retrieve.
         * </p>
         * 
         * @param nextToken
         *        Token to pass along to the next <code>ListTopics</code> request. This element is returned if there are
         *        additional topics to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SnsResponse.BuilderImpl implements Builder {
        private List<Topic> topics = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTopicsResponse model) {
            super(model);
            topics(model.topics);
            nextToken(model.nextToken);
        }

        public final List<Topic.Builder> getTopics() {
            List<Topic.Builder> result = TopicsListCopier.copyToBuilder(this.topics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopics(Collection<Topic.BuilderImpl> topics) {
            this.topics = TopicsListCopier.copyFromBuilder(topics);
        }

        @Override
        public final Builder topics(Collection<Topic> topics) {
            this.topics = TopicsListCopier.copy(topics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topics(Topic... topics) {
            topics(Arrays.asList(topics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topics(Consumer<Topic.Builder>... topics) {
            topics(Stream.of(topics).map(c -> Topic.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTopicsResponse build() {
            return new ListTopicsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
