/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sns.model.MessageAttributeMapCopier;
import software.amazon.awssdk.services.sns.model.MessageAttributeValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PublishBatchRequestEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PublishBatchRequestEntry> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(PublishBatchRequestEntry.getter(PublishBatchRequestEntry::id)).setter(PublishBatchRequestEntry.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(PublishBatchRequestEntry.getter(PublishBatchRequestEntry::message)).setter(PublishBatchRequestEntry.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subject").getter(PublishBatchRequestEntry.getter(PublishBatchRequestEntry::subject)).setter(PublishBatchRequestEntry.setter(Builder::subject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()}).build();
    private static final SdkField<String> MESSAGE_STRUCTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageStructure").getter(PublishBatchRequestEntry.getter(PublishBatchRequestEntry::messageStructure)).setter(PublishBatchRequestEntry.setter(Builder::messageStructure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageStructure").build()}).build();
    private static final SdkField<Map<String, MessageAttributeValue>> MESSAGE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("MessageAttributes").getter(PublishBatchRequestEntry.getter(PublishBatchRequestEntry::messageAttributes)).setter(PublishBatchRequestEntry.setter(Builder::messageAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageAttributes").build(), MapTrait.builder().keyLocationName("Name").valueLocationName("Value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build()).build()}).build();
    private static final SdkField<String> MESSAGE_DEDUPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageDeduplicationId").getter(PublishBatchRequestEntry.getter(PublishBatchRequestEntry::messageDeduplicationId)).setter(PublishBatchRequestEntry.setter(Builder::messageDeduplicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageDeduplicationId").build()}).build();
    private static final SdkField<String> MESSAGE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageGroupId").getter(PublishBatchRequestEntry.getter(PublishBatchRequestEntry::messageGroupId)).setter(PublishBatchRequestEntry.setter(Builder::messageGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageGroupId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, MESSAGE_FIELD, SUBJECT_FIELD, MESSAGE_STRUCTURE_FIELD, MESSAGE_ATTRIBUTES_FIELD, MESSAGE_DEDUPLICATION_ID_FIELD, MESSAGE_GROUP_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("Message", MESSAGE_FIELD);
            this.put("Subject", SUBJECT_FIELD);
            this.put("MessageStructure", MESSAGE_STRUCTURE_FIELD);
            this.put("MessageAttributes", MESSAGE_ATTRIBUTES_FIELD);
            this.put("MessageDeduplicationId", MESSAGE_DEDUPLICATION_ID_FIELD);
            this.put("MessageGroupId", MESSAGE_GROUP_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String message;
    private final String subject;
    private final String messageStructure;
    private final Map<String, MessageAttributeValue> messageAttributes;
    private final String messageDeduplicationId;
    private final String messageGroupId;

    private PublishBatchRequestEntry(BuilderImpl builder) {
        this.id = builder.id;
        this.message = builder.message;
        this.subject = builder.subject;
        this.messageStructure = builder.messageStructure;
        this.messageAttributes = builder.messageAttributes;
        this.messageDeduplicationId = builder.messageDeduplicationId;
        this.messageGroupId = builder.messageGroupId;
    }

    public final String id() {
        return this.id;
    }

    public final String message() {
        return this.message;
    }

    public final String subject() {
        return this.subject;
    }

    public final String messageStructure() {
        return this.messageStructure;
    }

    public final boolean hasMessageAttributes() {
        return this.messageAttributes != null && !(this.messageAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, MessageAttributeValue> messageAttributes() {
        return this.messageAttributes;
    }

    public final String messageDeduplicationId() {
        return this.messageDeduplicationId;
    }

    public final String messageGroupId() {
        return this.messageGroupId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageStructure());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessageAttributes() ? this.messageAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.messageDeduplicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageGroupId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishBatchRequestEntry)) {
            return false;
        }
        PublishBatchRequestEntry other = (PublishBatchRequestEntry)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.subject(), other.subject()) && Objects.equals(this.messageStructure(), other.messageStructure()) && this.hasMessageAttributes() == other.hasMessageAttributes() && Objects.equals(this.messageAttributes(), other.messageAttributes()) && Objects.equals(this.messageDeduplicationId(), other.messageDeduplicationId()) && Objects.equals(this.messageGroupId(), other.messageGroupId());
    }

    public final String toString() {
        return ToString.builder((String)"PublishBatchRequestEntry").add("Id", (Object)this.id()).add("Message", (Object)this.message()).add("Subject", (Object)this.subject()).add("MessageStructure", (Object)this.messageStructure()).add("MessageAttributes", this.hasMessageAttributes() ? this.messageAttributes() : null).add("MessageDeduplicationId", (Object)this.messageDeduplicationId()).add("MessageGroupId", (Object)this.messageGroupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "Subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "MessageStructure": {
                return Optional.ofNullable(clazz.cast(this.messageStructure()));
            }
            case "MessageAttributes": {
                return Optional.ofNullable(clazz.cast(this.messageAttributes()));
            }
            case "MessageDeduplicationId": {
                return Optional.ofNullable(clazz.cast(this.messageDeduplicationId()));
            }
            case "MessageGroupId": {
                return Optional.ofNullable(clazz.cast(this.messageGroupId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PublishBatchRequestEntry, T> g) {
        return obj -> g.apply((PublishBatchRequestEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String message;
        private String subject;
        private String messageStructure;
        private Map<String, MessageAttributeValue> messageAttributes = DefaultSdkAutoConstructMap.getInstance();
        private String messageDeduplicationId;
        private String messageGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishBatchRequestEntry model) {
            this.id(model.id);
            this.message(model.message);
            this.subject(model.subject);
            this.messageStructure(model.messageStructure);
            this.messageAttributes(model.messageAttributes);
            this.messageDeduplicationId(model.messageDeduplicationId);
            this.messageGroupId(model.messageGroupId);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getSubject() {
            return this.subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getMessageStructure() {
            return this.messageStructure;
        }

        public final void setMessageStructure(String messageStructure) {
            this.messageStructure = messageStructure;
        }

        @Override
        public final Builder messageStructure(String messageStructure) {
            this.messageStructure = messageStructure;
            return this;
        }

        public final Map<String, MessageAttributeValue.Builder> getMessageAttributes() {
            Map<String, MessageAttributeValue.Builder> result = MessageAttributeMapCopier.copyToBuilder(this.messageAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setMessageAttributes(Map<String, MessageAttributeValue.BuilderImpl> messageAttributes) {
            this.messageAttributes = MessageAttributeMapCopier.copyFromBuilder(messageAttributes);
        }

        @Override
        public final Builder messageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
            this.messageAttributes = MessageAttributeMapCopier.copy(messageAttributes);
            return this;
        }

        public final String getMessageDeduplicationId() {
            return this.messageDeduplicationId;
        }

        public final void setMessageDeduplicationId(String messageDeduplicationId) {
            this.messageDeduplicationId = messageDeduplicationId;
        }

        @Override
        public final Builder messageDeduplicationId(String messageDeduplicationId) {
            this.messageDeduplicationId = messageDeduplicationId;
            return this;
        }

        public final String getMessageGroupId() {
            return this.messageGroupId;
        }

        public final void setMessageGroupId(String messageGroupId) {
            this.messageGroupId = messageGroupId;
        }

        @Override
        public final Builder messageGroupId(String messageGroupId) {
            this.messageGroupId = messageGroupId;
            return this;
        }

        public PublishBatchRequestEntry build() {
            return new PublishBatchRequestEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PublishBatchRequestEntry> {
        public Builder id(String var1);

        public Builder message(String var1);

        public Builder subject(String var1);

        public Builder messageStructure(String var1);

        public Builder messageAttributes(Map<String, MessageAttributeValue> var1);

        public Builder messageDeduplicationId(String var1);

        public Builder messageGroupId(String var1);
    }
}

