/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response for GetSubscriptionAttributes action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSubscriptionAttributesResponse extends SnsResponse implements
        ToCopyableBuilder<GetSubscriptionAttributesResponse.Builder, GetSubscriptionAttributesResponse> {
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Attributes")
            .getter(getter(GetSubscriptionAttributesResponse::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Attributes", ATTRIBUTES_FIELD);
                }
            });

    private final Map<String, String> attributes;

    private GetSubscriptionAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of the subscription's attributes. Attributes in this map include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ConfirmationWasAuthenticated</code> – <code>true</code> if the subscription confirmation request was
     * authenticated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeliveryPolicy</code> – The JSON serialization of the subscription's delivery policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EffectiveDeliveryPolicy</code> – The JSON serialization of the effective delivery policy that takes into
     * account the topic delivery policy and account system defaults.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FilterPolicy</code> – The filter policy JSON that is assigned to the subscription. For more information,
     * see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-filtering.html">Amazon SNS Message
     * Filtering</a> in the <i>Amazon SNS Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FilterPolicyScope</code> – This attribute lets you choose the filtering scope by using one of the following
     * string value types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MessageAttributes</code> (default) – The filter is applied on the message attributes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MessageBody</code> – The filter is applied on the message body.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>Owner</code> – The Amazon Web Services account ID of the subscription's owner.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PendingConfirmation</code> – <code>true</code> if the subscription hasn't been confirmed. To confirm a
     * pending subscription, call the <code>ConfirmSubscription</code> action with a confirmation token.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RawMessageDelivery</code> – <code>true</code> if raw message delivery is enabled for the subscription. Raw
     * messages are free of JSON formatting and can be sent to HTTP/S and Amazon SQS endpoints.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RedrivePolicy</code> – When specified, sends undeliverable messages to the specified Amazon SQS dead-letter
     * queue. Messages that can't be delivered due to client errors (for example, when the subscribed endpoint is
     * unreachable) or server errors (for example, when the service that powers the subscribed endpoint becomes
     * unavailable) are held in the dead-letter queue for further analysis or reprocessing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SubscriptionArn</code> – The subscription's ARN.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TopicArn</code> – The topic ARN that the subscription is associated with.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attribute applies only to Amazon Data Firehose delivery stream subscriptions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SubscriptionRoleArn</code> – The ARN of the IAM role that has the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Permission to write to the Firehose delivery stream
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon SNS listed as a trusted entity
     * </p>
     * </li>
     * </ul>
     * <p>
     * Specifying a valid ARN for this attribute is required for Firehose delivery stream subscriptions. For more
     * information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html">Fanout to
     * Firehose delivery streams</a> in the <i>Amazon SNS Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return A map of the subscription's attributes. Attributes in this map include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ConfirmationWasAuthenticated</code> – <code>true</code> if the subscription confirmation request
     *         was authenticated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeliveryPolicy</code> – The JSON serialization of the subscription's delivery policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EffectiveDeliveryPolicy</code> – The JSON serialization of the effective delivery policy that takes
     *         into account the topic delivery policy and account system defaults.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FilterPolicy</code> – The filter policy JSON that is assigned to the subscription. For more
     *         information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-filtering.html">Amazon
     *         SNS Message Filtering</a> in the <i>Amazon SNS Developer Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FilterPolicyScope</code> – This attribute lets you choose the filtering scope by using one of the
     *         following string value types:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MessageAttributes</code> (default) – The filter is applied on the message attributes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MessageBody</code> – The filter is applied on the message body.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Owner</code> – The Amazon Web Services account ID of the subscription's owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PendingConfirmation</code> – <code>true</code> if the subscription hasn't been confirmed. To
     *         confirm a pending subscription, call the <code>ConfirmSubscription</code> action with a confirmation
     *         token.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RawMessageDelivery</code> – <code>true</code> if raw message delivery is enabled for the
     *         subscription. Raw messages are free of JSON formatting and can be sent to HTTP/S and Amazon SQS
     *         endpoints.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RedrivePolicy</code> – When specified, sends undeliverable messages to the specified Amazon SQS
     *         dead-letter queue. Messages that can't be delivered due to client errors (for example, when the
     *         subscribed endpoint is unreachable) or server errors (for example, when the service that powers the
     *         subscribed endpoint becomes unavailable) are held in the dead-letter queue for further analysis or
     *         reprocessing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SubscriptionArn</code> – The subscription's ARN.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TopicArn</code> – The topic ARN that the subscription is associated with.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attribute applies only to Amazon Data Firehose delivery stream subscriptions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SubscriptionRoleArn</code> – The ARN of the IAM role that has the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Permission to write to the Firehose delivery stream
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon SNS listed as a trusted entity
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Specifying a valid ARN for this attribute is required for Firehose delivery stream subscriptions. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html">Fanout to Firehose
     *         delivery streams</a> in the <i>Amazon SNS Developer Guide</i>.
     *         </p>
     *         </li>
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSubscriptionAttributesResponse)) {
            return false;
        }
        GetSubscriptionAttributesResponse other = (GetSubscriptionAttributesResponse) obj;
        return hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSubscriptionAttributesResponse").add("Attributes", hasAttributes() ? attributes() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetSubscriptionAttributesResponse, T> g) {
        return obj -> g.apply((GetSubscriptionAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSubscriptionAttributesResponse> {
        /**
         * <p>
         * A map of the subscription's attributes. Attributes in this map include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ConfirmationWasAuthenticated</code> – <code>true</code> if the subscription confirmation request was
         * authenticated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeliveryPolicy</code> – The JSON serialization of the subscription's delivery policy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EffectiveDeliveryPolicy</code> – The JSON serialization of the effective delivery policy that takes
         * into account the topic delivery policy and account system defaults.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FilterPolicy</code> – The filter policy JSON that is assigned to the subscription. For more
         * information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-filtering.html">Amazon SNS
         * Message Filtering</a> in the <i>Amazon SNS Developer Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FilterPolicyScope</code> – This attribute lets you choose the filtering scope by using one of the
         * following string value types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>MessageAttributes</code> (default) – The filter is applied on the message attributes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MessageBody</code> – The filter is applied on the message body.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>Owner</code> – The Amazon Web Services account ID of the subscription's owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PendingConfirmation</code> – <code>true</code> if the subscription hasn't been confirmed. To confirm a
         * pending subscription, call the <code>ConfirmSubscription</code> action with a confirmation token.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RawMessageDelivery</code> – <code>true</code> if raw message delivery is enabled for the subscription.
         * Raw messages are free of JSON formatting and can be sent to HTTP/S and Amazon SQS endpoints.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RedrivePolicy</code> – When specified, sends undeliverable messages to the specified Amazon SQS
         * dead-letter queue. Messages that can't be delivered due to client errors (for example, when the subscribed
         * endpoint is unreachable) or server errors (for example, when the service that powers the subscribed endpoint
         * becomes unavailable) are held in the dead-letter queue for further analysis or reprocessing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SubscriptionArn</code> – The subscription's ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TopicArn</code> – The topic ARN that the subscription is associated with.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attribute applies only to Amazon Data Firehose delivery stream subscriptions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SubscriptionRoleArn</code> – The ARN of the IAM role that has the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Permission to write to the Firehose delivery stream
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon SNS listed as a trusted entity
         * </p>
         * </li>
         * </ul>
         * <p>
         * Specifying a valid ARN for this attribute is required for Firehose delivery stream subscriptions. For more
         * information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html">Fanout
         * to Firehose delivery streams</a> in the <i>Amazon SNS Developer Guide</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributes
         *        A map of the subscription's attributes. Attributes in this map include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ConfirmationWasAuthenticated</code> – <code>true</code> if the subscription confirmation request
         *        was authenticated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeliveryPolicy</code> – The JSON serialization of the subscription's delivery policy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EffectiveDeliveryPolicy</code> – The JSON serialization of the effective delivery policy that
         *        takes into account the topic delivery policy and account system defaults.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FilterPolicy</code> – The filter policy JSON that is assigned to the subscription. For more
         *        information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-filtering.html">Amazon
         *        SNS Message Filtering</a> in the <i>Amazon SNS Developer Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FilterPolicyScope</code> – This attribute lets you choose the filtering scope by using one of
         *        the following string value types:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MessageAttributes</code> (default) – The filter is applied on the message attributes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MessageBody</code> – The filter is applied on the message body.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Owner</code> – The Amazon Web Services account ID of the subscription's owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PendingConfirmation</code> – <code>true</code> if the subscription hasn't been confirmed. To
         *        confirm a pending subscription, call the <code>ConfirmSubscription</code> action with a confirmation
         *        token.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RawMessageDelivery</code> – <code>true</code> if raw message delivery is enabled for the
         *        subscription. Raw messages are free of JSON formatting and can be sent to HTTP/S and Amazon SQS
         *        endpoints.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RedrivePolicy</code> – When specified, sends undeliverable messages to the specified Amazon SQS
         *        dead-letter queue. Messages that can't be delivered due to client errors (for example, when the
         *        subscribed endpoint is unreachable) or server errors (for example, when the service that powers the
         *        subscribed endpoint becomes unavailable) are held in the dead-letter queue for further analysis or
         *        reprocessing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SubscriptionArn</code> – The subscription's ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TopicArn</code> – The topic ARN that the subscription is associated with.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attribute applies only to Amazon Data Firehose delivery stream subscriptions:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SubscriptionRoleArn</code> – The ARN of the IAM role that has the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Permission to write to the Firehose delivery stream
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon SNS listed as a trusted entity
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Specifying a valid ARN for this attribute is required for Firehose delivery stream subscriptions. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html">Fanout to Firehose
         *        delivery streams</a> in the <i>Amazon SNS Developer Guide</i>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);
    }

    static final class BuilderImpl extends SnsResponse.BuilderImpl implements Builder {
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSubscriptionAttributesResponse model) {
            super(model);
            attributes(model.attributes);
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = SubscriptionAttributesMapCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = SubscriptionAttributesMapCopier.copy(attributes);
            return this;
        }

        @Override
        public GetSubscriptionAttributesResponse build() {
            return new GetSubscriptionAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
