/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddPermissionRequest extends SnsRequest implements
        ToCopyableBuilder<AddPermissionRequest.Builder, AddPermissionRequest> {
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicArn").getter(getter(AddPermissionRequest::topicArn)).setter(setter(Builder::topicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()).build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Label")
            .getter(getter(AddPermissionRequest::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final SdkField<List<String>> AWS_ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AWSAccountIds")
            .getter(getter(AddPermissionRequest::awsAccountIds))
            .setter(setter(Builder::awsAccountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSAccountId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ACTION_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ActionNames")
            .getter(getter(AddPermissionRequest::actionNames))
            .setter(setter(Builder::actionNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_ARN_FIELD, LABEL_FIELD,
            AWS_ACCOUNT_IDS_FIELD, ACTION_NAMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("TopicArn", TOPIC_ARN_FIELD);
                    put("Label", LABEL_FIELD);
                    put("AWSAccountId", AWS_ACCOUNT_IDS_FIELD);
                    put("ActionName", ACTION_NAMES_FIELD);
                }
            });

    private final String topicArn;

    private final String label;

    private final List<String> awsAccountIds;

    private final List<String> actionNames;

    private AddPermissionRequest(BuilderImpl builder) {
        super(builder);
        this.topicArn = builder.topicArn;
        this.label = builder.label;
        this.awsAccountIds = builder.awsAccountIds;
        this.actionNames = builder.actionNames;
    }

    /**
     * <p>
     * The ARN of the topic whose access control policy you wish to modify.
     * </p>
     * 
     * @return The ARN of the topic whose access control policy you wish to modify.
     */
    public final String topicArn() {
        return topicArn;
    }

    /**
     * <p>
     * A unique identifier for the new policy statement.
     * </p>
     * 
     * @return A unique identifier for the new policy statement.
     */
    public final String label() {
        return label;
    }

    /**
     * For responses, this returns true if the service returned a value for the AWSAccountIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAwsAccountIds() {
        return awsAccountIds != null && !(awsAccountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services account IDs of the users (principals) who will be given access to the specified actions.
     * The users must have Amazon Web Services account, but do not need to be signed up for this service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAwsAccountIds} method.
     * </p>
     * 
     * @return The Amazon Web Services account IDs of the users (principals) who will be given access to the specified
     *         actions. The users must have Amazon Web Services account, but do not need to be signed up for this
     *         service.
     */
    public final List<String> awsAccountIds() {
        return awsAccountIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActionNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActionNames() {
        return actionNames != null && !(actionNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The action you want to allow for the specified principal(s).
     * </p>
     * <p>
     * Valid values: Any Amazon SNS action name, for example <code>Publish</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActionNames} method.
     * </p>
     * 
     * @return The action you want to allow for the specified principal(s).</p>
     *         <p>
     *         Valid values: Any Amazon SNS action name, for example <code>Publish</code>.
     */
    public final List<String> actionNames() {
        return actionNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(hasAwsAccountIds() ? awsAccountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasActionNames() ? actionNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddPermissionRequest)) {
            return false;
        }
        AddPermissionRequest other = (AddPermissionRequest) obj;
        return Objects.equals(topicArn(), other.topicArn()) && Objects.equals(label(), other.label())
                && hasAwsAccountIds() == other.hasAwsAccountIds() && Objects.equals(awsAccountIds(), other.awsAccountIds())
                && hasActionNames() == other.hasActionNames() && Objects.equals(actionNames(), other.actionNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddPermissionRequest").add("TopicArn", topicArn()).add("Label", label())
                .add("AWSAccountIds", hasAwsAccountIds() ? awsAccountIds() : null)
                .add("ActionNames", hasActionNames() ? actionNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicArn":
            return Optional.ofNullable(clazz.cast(topicArn()));
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        case "AWSAccountIds":
            return Optional.ofNullable(clazz.cast(awsAccountIds()));
        case "ActionNames":
            return Optional.ofNullable(clazz.cast(actionNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AddPermissionRequest, T> g) {
        return obj -> g.apply((AddPermissionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnsRequest.Builder, SdkPojo, CopyableBuilder<Builder, AddPermissionRequest> {
        /**
         * <p>
         * The ARN of the topic whose access control policy you wish to modify.
         * </p>
         * 
         * @param topicArn
         *        The ARN of the topic whose access control policy you wish to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * A unique identifier for the new policy statement.
         * </p>
         * 
         * @param label
         *        A unique identifier for the new policy statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * The Amazon Web Services account IDs of the users (principals) who will be given access to the specified
         * actions. The users must have Amazon Web Services account, but do not need to be signed up for this service.
         * </p>
         * 
         * @param awsAccountIds
         *        The Amazon Web Services account IDs of the users (principals) who will be given access to the
         *        specified actions. The users must have Amazon Web Services account, but do not need to be signed up
         *        for this service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountIds(Collection<String> awsAccountIds);

        /**
         * <p>
         * The Amazon Web Services account IDs of the users (principals) who will be given access to the specified
         * actions. The users must have Amazon Web Services account, but do not need to be signed up for this service.
         * </p>
         * 
         * @param awsAccountIds
         *        The Amazon Web Services account IDs of the users (principals) who will be given access to the
         *        specified actions. The users must have Amazon Web Services account, but do not need to be signed up
         *        for this service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountIds(String... awsAccountIds);

        /**
         * <p>
         * The action you want to allow for the specified principal(s).
         * </p>
         * <p>
         * Valid values: Any Amazon SNS action name, for example <code>Publish</code>.
         * </p>
         * 
         * @param actionNames
         *        The action you want to allow for the specified principal(s).</p>
         *        <p>
         *        Valid values: Any Amazon SNS action name, for example <code>Publish</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionNames(Collection<String> actionNames);

        /**
         * <p>
         * The action you want to allow for the specified principal(s).
         * </p>
         * <p>
         * Valid values: Any Amazon SNS action name, for example <code>Publish</code>.
         * </p>
         * 
         * @param actionNames
         *        The action you want to allow for the specified principal(s).</p>
         *        <p>
         *        Valid values: Any Amazon SNS action name, for example <code>Publish</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionNames(String... actionNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SnsRequest.BuilderImpl implements Builder {
        private String topicArn;

        private String label;

        private List<String> awsAccountIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> actionNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddPermissionRequest model) {
            super(model);
            topicArn(model.topicArn);
            label(model.label);
            awsAccountIds(model.awsAccountIds);
            actionNames(model.actionNames);
        }

        public final String getTopicArn() {
            return topicArn;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final String getLabel() {
            return label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final Collection<String> getAwsAccountIds() {
            if (awsAccountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return awsAccountIds;
        }

        public final void setAwsAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = DelegatesListCopier.copy(awsAccountIds);
        }

        @Override
        public final Builder awsAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = DelegatesListCopier.copy(awsAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsAccountIds(String... awsAccountIds) {
            awsAccountIds(Arrays.asList(awsAccountIds));
            return this;
        }

        public final Collection<String> getActionNames() {
            if (actionNames instanceof SdkAutoConstructList) {
                return null;
            }
            return actionNames;
        }

        public final void setActionNames(Collection<String> actionNames) {
            this.actionNames = ActionsListCopier.copy(actionNames);
        }

        @Override
        public final Builder actionNames(Collection<String> actionNames) {
            this.actionNames = ActionsListCopier.copy(actionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionNames(String... actionNames) {
            actionNames(Arrays.asList(actionNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddPermissionRequest build() {
            return new AddPermissionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
