/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSmsSandboxAccountStatusResponse extends SnsResponse implements
        ToCopyableBuilder<GetSmsSandboxAccountStatusResponse.Builder, GetSmsSandboxAccountStatusResponse> {
    private static final SdkField<Boolean> IS_IN_SANDBOX_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsInSandbox").getter(getter(GetSmsSandboxAccountStatusResponse::isInSandbox))
            .setter(setter(Builder::isInSandbox))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsInSandbox").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_IN_SANDBOX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("IsInSandbox", IS_IN_SANDBOX_FIELD);
                }
            });

    private final Boolean isInSandbox;

    private GetSmsSandboxAccountStatusResponse(BuilderImpl builder) {
        super(builder);
        this.isInSandbox = builder.isInSandbox;
    }

    /**
     * <p>
     * Indicates whether the calling Amazon Web Services account is in the SMS sandbox.
     * </p>
     * 
     * @return Indicates whether the calling Amazon Web Services account is in the SMS sandbox.
     */
    public final Boolean isInSandbox() {
        return isInSandbox;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(isInSandbox());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSmsSandboxAccountStatusResponse)) {
            return false;
        }
        GetSmsSandboxAccountStatusResponse other = (GetSmsSandboxAccountStatusResponse) obj;
        return Objects.equals(isInSandbox(), other.isInSandbox());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSmsSandboxAccountStatusResponse").add("IsInSandbox", isInSandbox()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IsInSandbox":
            return Optional.ofNullable(clazz.cast(isInSandbox()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetSmsSandboxAccountStatusResponse, T> g) {
        return obj -> g.apply((GetSmsSandboxAccountStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSmsSandboxAccountStatusResponse> {
        /**
         * <p>
         * Indicates whether the calling Amazon Web Services account is in the SMS sandbox.
         * </p>
         * 
         * @param isInSandbox
         *        Indicates whether the calling Amazon Web Services account is in the SMS sandbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isInSandbox(Boolean isInSandbox);
    }

    static final class BuilderImpl extends SnsResponse.BuilderImpl implements Builder {
        private Boolean isInSandbox;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSmsSandboxAccountStatusResponse model) {
            super(model);
            isInSandbox(model.isInSandbox);
        }

        public final Boolean getIsInSandbox() {
            return isInSandbox;
        }

        public final void setIsInSandbox(Boolean isInSandbox) {
            this.isInSandbox = isInSandbox;
        }

        @Override
        public final Builder isInSandbox(Boolean isInSandbox) {
            this.isInSandbox = isInSandbox;
            return this;
        }

        @Override
        public GetSmsSandboxAccountStatusResponse build() {
            return new GetSmsSandboxAccountStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
