/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublishBatchRequest extends SnsRequest implements
        ToCopyableBuilder<PublishBatchRequest.Builder, PublishBatchRequest> {
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicArn").getter(getter(PublishBatchRequest::topicArn)).setter(setter(Builder::topicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()).build();

    private static final SdkField<List<PublishBatchRequestEntry>> PUBLISH_BATCH_REQUEST_ENTRIES_FIELD = SdkField
            .<List<PublishBatchRequestEntry>> builder(MarshallingType.LIST)
            .memberName("PublishBatchRequestEntries")
            .getter(getter(PublishBatchRequest::publishBatchRequestEntries))
            .setter(setter(Builder::publishBatchRequestEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishBatchRequestEntries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PublishBatchRequestEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(PublishBatchRequestEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_ARN_FIELD,
            PUBLISH_BATCH_REQUEST_ENTRIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("TopicArn", TOPIC_ARN_FIELD);
                    put("PublishBatchRequestEntries", PUBLISH_BATCH_REQUEST_ENTRIES_FIELD);
                }
            });

    private final String topicArn;

    private final List<PublishBatchRequestEntry> publishBatchRequestEntries;

    private PublishBatchRequest(BuilderImpl builder) {
        super(builder);
        this.topicArn = builder.topicArn;
        this.publishBatchRequestEntries = builder.publishBatchRequestEntries;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) of the topic you want to batch publish to.
     * </p>
     * 
     * @return The Amazon resource name (ARN) of the topic you want to batch publish to.
     */
    public final String topicArn() {
        return topicArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the PublishBatchRequestEntries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPublishBatchRequestEntries() {
        return publishBatchRequestEntries != null && !(publishBatchRequestEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>PublishBatch</code> request entries to be sent to the SNS topic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPublishBatchRequestEntries} method.
     * </p>
     * 
     * @return A list of <code>PublishBatch</code> request entries to be sent to the SNS topic.
     */
    public final List<PublishBatchRequestEntry> publishBatchRequestEntries() {
        return publishBatchRequestEntries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasPublishBatchRequestEntries() ? publishBatchRequestEntries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishBatchRequest)) {
            return false;
        }
        PublishBatchRequest other = (PublishBatchRequest) obj;
        return Objects.equals(topicArn(), other.topicArn())
                && hasPublishBatchRequestEntries() == other.hasPublishBatchRequestEntries()
                && Objects.equals(publishBatchRequestEntries(), other.publishBatchRequestEntries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PublishBatchRequest").add("TopicArn", topicArn())
                .add("PublishBatchRequestEntries", hasPublishBatchRequestEntries() ? publishBatchRequestEntries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicArn":
            return Optional.ofNullable(clazz.cast(topicArn()));
        case "PublishBatchRequestEntries":
            return Optional.ofNullable(clazz.cast(publishBatchRequestEntries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PublishBatchRequest, T> g) {
        return obj -> g.apply((PublishBatchRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PublishBatchRequest> {
        /**
         * <p>
         * The Amazon resource name (ARN) of the topic you want to batch publish to.
         * </p>
         * 
         * @param topicArn
         *        The Amazon resource name (ARN) of the topic you want to batch publish to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * A list of <code>PublishBatch</code> request entries to be sent to the SNS topic.
         * </p>
         * 
         * @param publishBatchRequestEntries
         *        A list of <code>PublishBatch</code> request entries to be sent to the SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publishBatchRequestEntries(Collection<PublishBatchRequestEntry> publishBatchRequestEntries);

        /**
         * <p>
         * A list of <code>PublishBatch</code> request entries to be sent to the SNS topic.
         * </p>
         * 
         * @param publishBatchRequestEntries
         *        A list of <code>PublishBatch</code> request entries to be sent to the SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publishBatchRequestEntries(PublishBatchRequestEntry... publishBatchRequestEntries);

        /**
         * <p>
         * A list of <code>PublishBatch</code> request entries to be sent to the SNS topic.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sns.model.PublishBatchRequestEntry.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.sns.model.PublishBatchRequestEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sns.model.PublishBatchRequestEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #publishBatchRequestEntries(List<PublishBatchRequestEntry>)}.
         * 
         * @param publishBatchRequestEntries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sns.model.PublishBatchRequestEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publishBatchRequestEntries(java.util.Collection<PublishBatchRequestEntry>)
         */
        Builder publishBatchRequestEntries(Consumer<PublishBatchRequestEntry.Builder>... publishBatchRequestEntries);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SnsRequest.BuilderImpl implements Builder {
        private String topicArn;

        private List<PublishBatchRequestEntry> publishBatchRequestEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PublishBatchRequest model) {
            super(model);
            topicArn(model.topicArn);
            publishBatchRequestEntries(model.publishBatchRequestEntries);
        }

        public final String getTopicArn() {
            return topicArn;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final List<PublishBatchRequestEntry.Builder> getPublishBatchRequestEntries() {
            List<PublishBatchRequestEntry.Builder> result = PublishBatchRequestEntryListCopier
                    .copyToBuilder(this.publishBatchRequestEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPublishBatchRequestEntries(
                Collection<PublishBatchRequestEntry.BuilderImpl> publishBatchRequestEntries) {
            this.publishBatchRequestEntries = PublishBatchRequestEntryListCopier.copyFromBuilder(publishBatchRequestEntries);
        }

        @Override
        public final Builder publishBatchRequestEntries(Collection<PublishBatchRequestEntry> publishBatchRequestEntries) {
            this.publishBatchRequestEntries = PublishBatchRequestEntryListCopier.copy(publishBatchRequestEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publishBatchRequestEntries(PublishBatchRequestEntry... publishBatchRequestEntries) {
            publishBatchRequestEntries(Arrays.asList(publishBatchRequestEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publishBatchRequestEntries(Consumer<PublishBatchRequestEntry.Builder>... publishBatchRequestEntries) {
            publishBatchRequestEntries(Stream.of(publishBatchRequestEntries)
                    .map(c -> PublishBatchRequestEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PublishBatchRequest build() {
            return new PublishBatchRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
