/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for Publish action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublishRequest extends SnsRequest implements ToCopyableBuilder<PublishRequest.Builder, PublishRequest> {
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PublishRequest::topicArn)).setter(setter(Builder::topicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()).build();

    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PublishRequest::targetArn)).setter(setter(Builder::targetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetArn").build()).build();

    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PublishRequest::phoneNumber)).setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PublishRequest::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PublishRequest::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()).build();

    private static final SdkField<String> MESSAGE_STRUCTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PublishRequest::messageStructure)).setter(setter(Builder::messageStructure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageStructure").build()).build();

    private static final SdkField<Map<String, MessageAttributeValue>> MESSAGE_ATTRIBUTES_FIELD = SdkField
            .<Map<String, MessageAttributeValue>> builder(MarshallingType.MAP)
            .getter(getter(PublishRequest::messageAttributes))
            .setter(setter(Builder::messageAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("Name")
                            .valueLocationName("Value")
                            .valueFieldInfo(
                                    SdkField.<MessageAttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageAttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TOPIC_ARN_FIELD, TARGET_ARN_FIELD, PHONE_NUMBER_FIELD, MESSAGE_FIELD, SUBJECT_FIELD, MESSAGE_STRUCTURE_FIELD,
                    MESSAGE_ATTRIBUTES_FIELD));

    private final String topicArn;

    private final String targetArn;

    private final String phoneNumber;

    private final String message;

    private final String subject;

    private final String messageStructure;

    private final Map<String, MessageAttributeValue> messageAttributes;

    private PublishRequest(BuilderImpl builder) {
        super(builder);
        this.topicArn = builder.topicArn;
        this.targetArn = builder.targetArn;
        this.phoneNumber = builder.phoneNumber;
        this.message = builder.message;
        this.subject = builder.subject;
        this.messageStructure = builder.messageStructure;
        this.messageAttributes = builder.messageAttributes;
    }

    /**
     * <p>
     * The topic you want to publish to.
     * </p>
     * <p>
     * If you don't specify a value for the <code>TopicArn</code> parameter, you must specify a value for the
     * <code>PhoneNumber</code> or <code>TargetArn</code> parameters.
     * </p>
     * 
     * @return The topic you want to publish to.</p>
     *         <p>
     *         If you don't specify a value for the <code>TopicArn</code> parameter, you must specify a value for the
     *         <code>PhoneNumber</code> or <code>TargetArn</code> parameters.
     */
    public String topicArn() {
        return topicArn;
    }

    /**
     * <p>
     * Either TopicArn or EndpointArn, but not both.
     * </p>
     * <p>
     * If you don't specify a value for the <code>TargetArn</code> parameter, you must specify a value for the
     * <code>PhoneNumber</code> or <code>TopicArn</code> parameters.
     * </p>
     * 
     * @return Either TopicArn or EndpointArn, but not both.</p>
     *         <p>
     *         If you don't specify a value for the <code>TargetArn</code> parameter, you must specify a value for the
     *         <code>PhoneNumber</code> or <code>TopicArn</code> parameters.
     */
    public String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * The phone number to which you want to deliver an SMS message. Use E.164 format.
     * </p>
     * <p>
     * If you don't specify a value for the <code>PhoneNumber</code> parameter, you must specify a value for the
     * <code>TargetArn</code> or <code>TopicArn</code> parameters.
     * </p>
     * 
     * @return The phone number to which you want to deliver an SMS message. Use E.164 format.</p>
     *         <p>
     *         If you don't specify a value for the <code>PhoneNumber</code> parameter, you must specify a value for the
     *         <code>TargetArn</code> or <code>TopicArn</code> parameters.
     */
    public String phoneNumber() {
        return phoneNumber;
    }

    /**
     * <p>
     * The message you want to send.
     * </p>
     * <important>
     * <p>
     * The <code>Message</code> parameter is always a string. If you set <code>MessageStructure</code> to
     * <code>json</code>, you must string-encode the <code>Message</code> parameter.
     * </p>
     * </important>
     * <p>
     * If you are publishing to a topic and you want to send the same message to all transport protocols, include the
     * text of the message as a String value. If you want to send different messages for each transport protocol, set
     * the value of the <code>MessageStructure</code> parameter to <code>json</code> and use a JSON object for the
     * <code>Message</code> parameter.
     * </p>
     * <p/>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * With the exception of SMS, messages must be UTF-8 encoded strings and at most 256 KB in size (262,144 bytes, not
     * 262,144 characters).
     * </p>
     * </li>
     * <li>
     * <p>
     * For SMS, each message can contain up to 140 characters. This character limit depends on the encoding schema. For
     * example, an SMS message can contain 160 GSM characters, 140 ASCII characters, or 70 UCS-2 characters.
     * </p>
     * <p>
     * If you publish a message that exceeds this size limit, Amazon SNS sends the message as multiple messages, each
     * fitting within the size limit. Messages aren't truncated mid-word but are cut off at whole-word boundaries.
     * </p>
     * <p>
     * The total size limit for a single SMS <code>Publish</code> action is 1,600 characters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * JSON-specific constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Keys in the JSON object that correspond to supported transport protocols must have simple JSON string values.
     * </p>
     * </li>
     * <li>
     * <p>
     * The values will be parsed (unescaped) before they are used in outgoing messages.
     * </p>
     * </li>
     * <li>
     * <p>
     * Outbound notifications are JSON encoded (meaning that the characters will be reescaped for sending).
     * </p>
     * </li>
     * <li>
     * <p>
     * Values have a minimum length of 0 (the empty string, "", is allowed).
     * </p>
     * </li>
     * <li>
     * <p>
     * Values have a maximum length bounded by the overall message size (so, including multiple protocols may limit
     * message sizes).
     * </p>
     * </li>
     * <li>
     * <p>
     * Non-string values will cause the key to be ignored.
     * </p>
     * </li>
     * <li>
     * <p>
     * Keys that do not correspond to supported transport protocols are ignored.
     * </p>
     * </li>
     * <li>
     * <p>
     * Duplicate keys are not allowed.
     * </p>
     * </li>
     * <li>
     * <p>
     * Failure to parse or validate any key or value in the message will cause the <code>Publish</code> call to return
     * an error (no partial delivery).
     * </p>
     * </li>
     * </ul>
     * 
     * @return The message you want to send.</p> <important>
     *         <p>
     *         The <code>Message</code> parameter is always a string. If you set <code>MessageStructure</code> to
     *         <code>json</code>, you must string-encode the <code>Message</code> parameter.
     *         </p>
     *         </important>
     *         <p>
     *         If you are publishing to a topic and you want to send the same message to all transport protocols,
     *         include the text of the message as a String value. If you want to send different messages for each
     *         transport protocol, set the value of the <code>MessageStructure</code> parameter to <code>json</code> and
     *         use a JSON object for the <code>Message</code> parameter.
     *         </p>
     *         <p/>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         With the exception of SMS, messages must be UTF-8 encoded strings and at most 256 KB in size (262,144
     *         bytes, not 262,144 characters).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For SMS, each message can contain up to 140 characters. This character limit depends on the encoding
     *         schema. For example, an SMS message can contain 160 GSM characters, 140 ASCII characters, or 70 UCS-2
     *         characters.
     *         </p>
     *         <p>
     *         If you publish a message that exceeds this size limit, Amazon SNS sends the message as multiple messages,
     *         each fitting within the size limit. Messages aren't truncated mid-word but are cut off at whole-word
     *         boundaries.
     *         </p>
     *         <p>
     *         The total size limit for a single SMS <code>Publish</code> action is 1,600 characters.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         JSON-specific constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Keys in the JSON object that correspond to supported transport protocols must have simple JSON string
     *         values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The values will be parsed (unescaped) before they are used in outgoing messages.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Outbound notifications are JSON encoded (meaning that the characters will be reescaped for sending).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Values have a minimum length of 0 (the empty string, "", is allowed).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Values have a maximum length bounded by the overall message size (so, including multiple protocols may
     *         limit message sizes).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Non-string values will cause the key to be ignored.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Keys that do not correspond to supported transport protocols are ignored.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Duplicate keys are not allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failure to parse or validate any key or value in the message will cause the <code>Publish</code> call to
     *         return an error (no partial delivery).
     *         </p>
     *         </li>
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * Optional parameter to be used as the "Subject" line when the message is delivered to email endpoints. This field
     * will also be included, if present, in the standard JSON messages delivered to other endpoints.
     * </p>
     * <p>
     * Constraints: Subjects must be ASCII text that begins with a letter, number, or punctuation mark; must not include
     * line breaks or control characters; and must be less than 100 characters long.
     * </p>
     * 
     * @return Optional parameter to be used as the "Subject" line when the message is delivered to email endpoints.
     *         This field will also be included, if present, in the standard JSON messages delivered to other
     *         endpoints.</p>
     *         <p>
     *         Constraints: Subjects must be ASCII text that begins with a letter, number, or punctuation mark; must not
     *         include line breaks or control characters; and must be less than 100 characters long.
     */
    public String subject() {
        return subject;
    }

    /**
     * <p>
     * Set <code>MessageStructure</code> to <code>json</code> if you want to send a different message for each protocol.
     * For example, using one publish action, you can send a short message to your SMS subscribers and a longer message
     * to your email subscribers. If you set <code>MessageStructure</code> to <code>json</code>, the value of the
     * <code>Message</code> parameter must:
     * </p>
     * <ul>
     * <li>
     * <p>
     * be a syntactically valid JSON object; and
     * </p>
     * </li>
     * <li>
     * <p>
     * contain at least a top-level JSON key of "default" with a value that is a string.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can define other top-level keys that define the message you want to send to a specific transport protocol
     * (e.g., "http").
     * </p>
     * <p>
     * For information about sending different messages for each protocol using the AWS Management Console, go to <a
     * href="http://docs.aws.amazon.com/sns/latest/gsg/Publish.html#sns-message-formatting-by-protocol">Create Different
     * Messages for Each Protocol</a> in the <i>Amazon Simple Notification Service Getting Started Guide</i>.
     * </p>
     * <p>
     * Valid value: <code>json</code>
     * </p>
     * 
     * @return Set <code>MessageStructure</code> to <code>json</code> if you want to send a different message for each
     *         protocol. For example, using one publish action, you can send a short message to your SMS subscribers and
     *         a longer message to your email subscribers. If you set <code>MessageStructure</code> to <code>json</code>
     *         , the value of the <code>Message</code> parameter must: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         be a syntactically valid JSON object; and
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         contain at least a top-level JSON key of "default" with a value that is a string.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can define other top-level keys that define the message you want to send to a specific transport
     *         protocol (e.g., "http").
     *         </p>
     *         <p>
     *         For information about sending different messages for each protocol using the AWS Management Console, go
     *         to <a
     *         href="http://docs.aws.amazon.com/sns/latest/gsg/Publish.html#sns-message-formatting-by-protocol">Create
     *         Different Messages for Each Protocol</a> in the <i>Amazon Simple Notification Service Getting Started
     *         Guide</i>.
     *         </p>
     *         <p>
     *         Valid value: <code>json</code>
     */
    public String messageStructure() {
        return messageStructure;
    }

    /**
     * <p>
     * Message attributes for Publish action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Message attributes for Publish action.
     */
    public Map<String, MessageAttributeValue> messageAttributes() {
        return messageAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(messageStructure());
        hashCode = 31 * hashCode + Objects.hashCode(messageAttributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishRequest)) {
            return false;
        }
        PublishRequest other = (PublishRequest) obj;
        return Objects.equals(topicArn(), other.topicArn()) && Objects.equals(targetArn(), other.targetArn())
                && Objects.equals(phoneNumber(), other.phoneNumber()) && Objects.equals(message(), other.message())
                && Objects.equals(subject(), other.subject()) && Objects.equals(messageStructure(), other.messageStructure())
                && Objects.equals(messageAttributes(), other.messageAttributes());
    }

    @Override
    public String toString() {
        return ToString.builder("PublishRequest").add("TopicArn", topicArn()).add("TargetArn", targetArn())
                .add("PhoneNumber", phoneNumber()).add("Message", message()).add("Subject", subject())
                .add("MessageStructure", messageStructure()).add("MessageAttributes", messageAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicArn":
            return Optional.ofNullable(clazz.cast(topicArn()));
        case "TargetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "Subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "MessageStructure":
            return Optional.ofNullable(clazz.cast(messageStructure()));
        case "MessageAttributes":
            return Optional.ofNullable(clazz.cast(messageAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublishRequest, T> g) {
        return obj -> g.apply((PublishRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PublishRequest> {
        /**
         * <p>
         * The topic you want to publish to.
         * </p>
         * <p>
         * If you don't specify a value for the <code>TopicArn</code> parameter, you must specify a value for the
         * <code>PhoneNumber</code> or <code>TargetArn</code> parameters.
         * </p>
         * 
         * @param topicArn
         *        The topic you want to publish to.</p>
         *        <p>
         *        If you don't specify a value for the <code>TopicArn</code> parameter, you must specify a value for the
         *        <code>PhoneNumber</code> or <code>TargetArn</code> parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * Either TopicArn or EndpointArn, but not both.
         * </p>
         * <p>
         * If you don't specify a value for the <code>TargetArn</code> parameter, you must specify a value for the
         * <code>PhoneNumber</code> or <code>TopicArn</code> parameters.
         * </p>
         * 
         * @param targetArn
         *        Either TopicArn or EndpointArn, but not both.</p>
         *        <p>
         *        If you don't specify a value for the <code>TargetArn</code> parameter, you must specify a value for
         *        the <code>PhoneNumber</code> or <code>TopicArn</code> parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * The phone number to which you want to deliver an SMS message. Use E.164 format.
         * </p>
         * <p>
         * If you don't specify a value for the <code>PhoneNumber</code> parameter, you must specify a value for the
         * <code>TargetArn</code> or <code>TopicArn</code> parameters.
         * </p>
         * 
         * @param phoneNumber
         *        The phone number to which you want to deliver an SMS message. Use E.164 format.</p>
         *        <p>
         *        If you don't specify a value for the <code>PhoneNumber</code> parameter, you must specify a value for
         *        the <code>TargetArn</code> or <code>TopicArn</code> parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * The message you want to send.
         * </p>
         * <important>
         * <p>
         * The <code>Message</code> parameter is always a string. If you set <code>MessageStructure</code> to
         * <code>json</code>, you must string-encode the <code>Message</code> parameter.
         * </p>
         * </important>
         * <p>
         * If you are publishing to a topic and you want to send the same message to all transport protocols, include
         * the text of the message as a String value. If you want to send different messages for each transport
         * protocol, set the value of the <code>MessageStructure</code> parameter to <code>json</code> and use a JSON
         * object for the <code>Message</code> parameter.
         * </p>
         * <p/>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * With the exception of SMS, messages must be UTF-8 encoded strings and at most 256 KB in size (262,144 bytes,
         * not 262,144 characters).
         * </p>
         * </li>
         * <li>
         * <p>
         * For SMS, each message can contain up to 140 characters. This character limit depends on the encoding schema.
         * For example, an SMS message can contain 160 GSM characters, 140 ASCII characters, or 70 UCS-2 characters.
         * </p>
         * <p>
         * If you publish a message that exceeds this size limit, Amazon SNS sends the message as multiple messages,
         * each fitting within the size limit. Messages aren't truncated mid-word but are cut off at whole-word
         * boundaries.
         * </p>
         * <p>
         * The total size limit for a single SMS <code>Publish</code> action is 1,600 characters.
         * </p>
         * </li>
         * </ul>
         * <p>
         * JSON-specific constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Keys in the JSON object that correspond to supported transport protocols must have simple JSON string values.
         * </p>
         * </li>
         * <li>
         * <p>
         * The values will be parsed (unescaped) before they are used in outgoing messages.
         * </p>
         * </li>
         * <li>
         * <p>
         * Outbound notifications are JSON encoded (meaning that the characters will be reescaped for sending).
         * </p>
         * </li>
         * <li>
         * <p>
         * Values have a minimum length of 0 (the empty string, "", is allowed).
         * </p>
         * </li>
         * <li>
         * <p>
         * Values have a maximum length bounded by the overall message size (so, including multiple protocols may limit
         * message sizes).
         * </p>
         * </li>
         * <li>
         * <p>
         * Non-string values will cause the key to be ignored.
         * </p>
         * </li>
         * <li>
         * <p>
         * Keys that do not correspond to supported transport protocols are ignored.
         * </p>
         * </li>
         * <li>
         * <p>
         * Duplicate keys are not allowed.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failure to parse or validate any key or value in the message will cause the <code>Publish</code> call to
         * return an error (no partial delivery).
         * </p>
         * </li>
         * </ul>
         * 
         * @param message
         *        The message you want to send.</p> <important>
         *        <p>
         *        The <code>Message</code> parameter is always a string. If you set <code>MessageStructure</code> to
         *        <code>json</code>, you must string-encode the <code>Message</code> parameter.
         *        </p>
         *        </important>
         *        <p>
         *        If you are publishing to a topic and you want to send the same message to all transport protocols,
         *        include the text of the message as a String value. If you want to send different messages for each
         *        transport protocol, set the value of the <code>MessageStructure</code> parameter to <code>json</code>
         *        and use a JSON object for the <code>Message</code> parameter.
         *        </p>
         *        <p/>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        With the exception of SMS, messages must be UTF-8 encoded strings and at most 256 KB in size (262,144
         *        bytes, not 262,144 characters).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For SMS, each message can contain up to 140 characters. This character limit depends on the encoding
         *        schema. For example, an SMS message can contain 160 GSM characters, 140 ASCII characters, or 70 UCS-2
         *        characters.
         *        </p>
         *        <p>
         *        If you publish a message that exceeds this size limit, Amazon SNS sends the message as multiple
         *        messages, each fitting within the size limit. Messages aren't truncated mid-word but are cut off at
         *        whole-word boundaries.
         *        </p>
         *        <p>
         *        The total size limit for a single SMS <code>Publish</code> action is 1,600 characters.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        JSON-specific constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Keys in the JSON object that correspond to supported transport protocols must have simple JSON string
         *        values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The values will be parsed (unescaped) before they are used in outgoing messages.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Outbound notifications are JSON encoded (meaning that the characters will be reescaped for sending).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Values have a minimum length of 0 (the empty string, "", is allowed).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Values have a maximum length bounded by the overall message size (so, including multiple protocols may
         *        limit message sizes).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Non-string values will cause the key to be ignored.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Keys that do not correspond to supported transport protocols are ignored.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Duplicate keys are not allowed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failure to parse or validate any key or value in the message will cause the <code>Publish</code> call
         *        to return an error (no partial delivery).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * Optional parameter to be used as the "Subject" line when the message is delivered to email endpoints. This
         * field will also be included, if present, in the standard JSON messages delivered to other endpoints.
         * </p>
         * <p>
         * Constraints: Subjects must be ASCII text that begins with a letter, number, or punctuation mark; must not
         * include line breaks or control characters; and must be less than 100 characters long.
         * </p>
         * 
         * @param subject
         *        Optional parameter to be used as the "Subject" line when the message is delivered to email endpoints.
         *        This field will also be included, if present, in the standard JSON messages delivered to other
         *        endpoints.</p>
         *        <p>
         *        Constraints: Subjects must be ASCII text that begins with a letter, number, or punctuation mark; must
         *        not include line breaks or control characters; and must be less than 100 characters long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * <p>
         * Set <code>MessageStructure</code> to <code>json</code> if you want to send a different message for each
         * protocol. For example, using one publish action, you can send a short message to your SMS subscribers and a
         * longer message to your email subscribers. If you set <code>MessageStructure</code> to <code>json</code>, the
         * value of the <code>Message</code> parameter must:
         * </p>
         * <ul>
         * <li>
         * <p>
         * be a syntactically valid JSON object; and
         * </p>
         * </li>
         * <li>
         * <p>
         * contain at least a top-level JSON key of "default" with a value that is a string.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can define other top-level keys that define the message you want to send to a specific transport protocol
         * (e.g., "http").
         * </p>
         * <p>
         * For information about sending different messages for each protocol using the AWS Management Console, go to <a
         * href="http://docs.aws.amazon.com/sns/latest/gsg/Publish.html#sns-message-formatting-by-protocol">Create
         * Different Messages for Each Protocol</a> in the <i>Amazon Simple Notification Service Getting Started
         * Guide</i>.
         * </p>
         * <p>
         * Valid value: <code>json</code>
         * </p>
         * 
         * @param messageStructure
         *        Set <code>MessageStructure</code> to <code>json</code> if you want to send a different message for
         *        each protocol. For example, using one publish action, you can send a short message to your SMS
         *        subscribers and a longer message to your email subscribers. If you set <code>MessageStructure</code>
         *        to <code>json</code>, the value of the <code>Message</code> parameter must: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        be a syntactically valid JSON object; and
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        contain at least a top-level JSON key of "default" with a value that is a string.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can define other top-level keys that define the message you want to send to a specific transport
         *        protocol (e.g., "http").
         *        </p>
         *        <p>
         *        For information about sending different messages for each protocol using the AWS Management Console,
         *        go to <a
         *        href="http://docs.aws.amazon.com/sns/latest/gsg/Publish.html#sns-message-formatting-by-protocol"
         *        >Create Different Messages for Each Protocol</a> in the <i>Amazon Simple Notification Service Getting
         *        Started Guide</i>.
         *        </p>
         *        <p>
         *        Valid value: <code>json</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageStructure(String messageStructure);

        /**
         * <p>
         * Message attributes for Publish action.
         * </p>
         * 
         * @param messageAttributes
         *        Message attributes for Publish action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageAttributes(Map<String, MessageAttributeValue> messageAttributes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SnsRequest.BuilderImpl implements Builder {
        private String topicArn;

        private String targetArn;

        private String phoneNumber;

        private String message;

        private String subject;

        private String messageStructure;

        private Map<String, MessageAttributeValue> messageAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PublishRequest model) {
            super(model);
            topicArn(model.topicArn);
            targetArn(model.targetArn);
            phoneNumber(model.phoneNumber);
            message(model.message);
            subject(model.subject);
            messageStructure(model.messageStructure);
            messageAttributes(model.messageAttributes);
        }

        public final String getTopicArn() {
            return topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getTargetArn() {
            return targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getSubject() {
            return subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        public final String getMessageStructure() {
            return messageStructure;
        }

        @Override
        public final Builder messageStructure(String messageStructure) {
            this.messageStructure = messageStructure;
            return this;
        }

        public final void setMessageStructure(String messageStructure) {
            this.messageStructure = messageStructure;
        }

        public final Map<String, MessageAttributeValue.Builder> getMessageAttributes() {
            return messageAttributes != null ? CollectionUtils.mapValues(messageAttributes, MessageAttributeValue::toBuilder)
                    : null;
        }

        @Override
        public final Builder messageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
            this.messageAttributes = MessageAttributeMapCopier.copy(messageAttributes);
            return this;
        }

        public final void setMessageAttributes(Map<String, MessageAttributeValue.BuilderImpl> messageAttributes) {
            this.messageAttributes = MessageAttributeMapCopier.copyFromBuilder(messageAttributes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PublishRequest build() {
            return new PublishRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
