/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the SetSMSAttributes action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetSmsAttributesRequest extends SnsRequest implements
        ToCopyableBuilder<SetSmsAttributesRequest.Builder, SetSmsAttributesRequest> {
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(SetSmsAttributesRequest::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD));

    private final Map<String, String> attributes;

    private SetSmsAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * The default settings for sending SMS messages from your account. You can set values for the following attribute
     * names:
     * </p>
     * <p>
     * <code>MonthlySpendLimit</code> – The maximum amount in USD that you are willing to spend each month to send SMS
     * messages. When Amazon SNS determines that sending an SMS message would incur a cost that exceeds this limit, it
     * stops sending SMS messages within minutes.
     * </p>
     * <important>
     * <p>
     * Amazon SNS stops sending SMS messages within minutes of the limit being crossed. During that interval, if you
     * continue to send SMS messages, you will incur costs that exceed your limit.
     * </p>
     * </important>
     * <p>
     * By default, the spend limit is set to the maximum allowed by Amazon SNS. If you want to raise the limit, submit
     * an <a href=
     * "https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&amp;limitType=service-code-sns"
     * >SNS Limit Increase case</a>. For <b>New limit value</b>, enter your desired monthly spend limit. In the <b>Use
     * Case Description</b> field, explain that you are requesting an SMS monthly spend limit increase.
     * </p>
     * <p>
     * <code>DeliveryStatusIAMRole</code> – The ARN of the IAM role that allows Amazon SNS to write logs about SMS
     * deliveries in CloudWatch Logs. For each SMS message that you send, Amazon SNS writes a log that includes the
     * message price, the success or failure status, the reason for failure (if the message failed), the message dwell
     * time, and other information.
     * </p>
     * <p>
     * <code>DeliveryStatusSuccessSamplingRate</code> – The percentage of successful SMS deliveries for which Amazon SNS
     * will write logs in CloudWatch Logs. The value can be an integer from 0 - 100. For example, to write logs only for
     * failed deliveries, set this value to <code>0</code>. To write logs for 10% of your successful deliveries, set it
     * to <code>10</code>.
     * </p>
     * <p>
     * <code>DefaultSenderID</code> – A string, such as your business brand, that is displayed as the sender on the
     * receiving device. Support for sender IDs varies by country. The sender ID can be 1 - 11 alphanumeric characters,
     * and it must contain at least one letter.
     * </p>
     * <p>
     * <code>DefaultSMSType</code> – The type of SMS message that you will send by default. You can assign the following
     * values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Promotional</code> – (Default) Noncritical messages, such as marketing messages. Amazon SNS optimizes the
     * message delivery to incur the lowest cost.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Transactional</code> – Critical messages that support customer transactions, such as one-time passcodes for
     * multi-factor authentication. Amazon SNS optimizes the message delivery to achieve the highest reliability.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>UsageReportS3Bucket</code> – The name of the Amazon S3 bucket to receive daily SMS usage reports from
     * Amazon SNS. Each day, Amazon SNS will deliver a usage report as a CSV file to the bucket. The report includes the
     * following information for each SMS message that was successfully delivered by your account:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Time that the message was published (in UTC)
     * </p>
     * </li>
     * <li>
     * <p>
     * Message ID
     * </p>
     * </li>
     * <li>
     * <p>
     * Destination phone number
     * </p>
     * </li>
     * <li>
     * <p>
     * Message type
     * </p>
     * </li>
     * <li>
     * <p>
     * Delivery status
     * </p>
     * </li>
     * <li>
     * <p>
     * Message price (in USD)
     * </p>
     * </li>
     * <li>
     * <p>
     * Part number (a message is split into multiple parts if it is too long for a single message)
     * </p>
     * </li>
     * <li>
     * <p>
     * Total number of parts
     * </p>
     * </li>
     * </ul>
     * <p>
     * To receive the report, the bucket must have a policy that allows the Amazon SNS service principle to perform the
     * <code>s3:PutObject</code> and <code>s3:GetBucketLocation</code> actions.
     * </p>
     * <p>
     * For an example bucket policy and usage report, see <a
     * href="http://docs.aws.amazon.com/sns/latest/dg/sms_stats.html">Monitoring SMS Activity</a> in the <i>Amazon SNS
     * Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The default settings for sending SMS messages from your account. You can set values for the following
     *         attribute names:</p>
     *         <p>
     *         <code>MonthlySpendLimit</code> – The maximum amount in USD that you are willing to spend each month to
     *         send SMS messages. When Amazon SNS determines that sending an SMS message would incur a cost that exceeds
     *         this limit, it stops sending SMS messages within minutes.
     *         </p>
     *         <important>
     *         <p>
     *         Amazon SNS stops sending SMS messages within minutes of the limit being crossed. During that interval, if
     *         you continue to send SMS messages, you will incur costs that exceed your limit.
     *         </p>
     *         </important>
     *         <p>
     *         By default, the spend limit is set to the maximum allowed by Amazon SNS. If you want to raise the limit,
     *         submit an <a href=
     *         "https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&amp;limitType=service-code-sns"
     *         >SNS Limit Increase case</a>. For <b>New limit value</b>, enter your desired monthly spend limit. In the
     *         <b>Use Case Description</b> field, explain that you are requesting an SMS monthly spend limit increase.
     *         </p>
     *         <p>
     *         <code>DeliveryStatusIAMRole</code> – The ARN of the IAM role that allows Amazon SNS to write logs about
     *         SMS deliveries in CloudWatch Logs. For each SMS message that you send, Amazon SNS writes a log that
     *         includes the message price, the success or failure status, the reason for failure (if the message
     *         failed), the message dwell time, and other information.
     *         </p>
     *         <p>
     *         <code>DeliveryStatusSuccessSamplingRate</code> – The percentage of successful SMS deliveries for which
     *         Amazon SNS will write logs in CloudWatch Logs. The value can be an integer from 0 - 100. For example, to
     *         write logs only for failed deliveries, set this value to <code>0</code>. To write logs for 10% of your
     *         successful deliveries, set it to <code>10</code>.
     *         </p>
     *         <p>
     *         <code>DefaultSenderID</code> – A string, such as your business brand, that is displayed as the sender on
     *         the receiving device. Support for sender IDs varies by country. The sender ID can be 1 - 11 alphanumeric
     *         characters, and it must contain at least one letter.
     *         </p>
     *         <p>
     *         <code>DefaultSMSType</code> – The type of SMS message that you will send by default. You can assign the
     *         following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Promotional</code> – (Default) Noncritical messages, such as marketing messages. Amazon SNS
     *         optimizes the message delivery to incur the lowest cost.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Transactional</code> – Critical messages that support customer transactions, such as one-time
     *         passcodes for multi-factor authentication. Amazon SNS optimizes the message delivery to achieve the
     *         highest reliability.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <code>UsageReportS3Bucket</code> – The name of the Amazon S3 bucket to receive daily SMS usage reports
     *         from Amazon SNS. Each day, Amazon SNS will deliver a usage report as a CSV file to the bucket. The report
     *         includes the following information for each SMS message that was successfully delivered by your account:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Time that the message was published (in UTC)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message ID
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Destination phone number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message type
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delivery status
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message price (in USD)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Part number (a message is split into multiple parts if it is too long for a single message)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Total number of parts
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To receive the report, the bucket must have a policy that allows the Amazon SNS service principle to
     *         perform the <code>s3:PutObject</code> and <code>s3:GetBucketLocation</code> actions.
     *         </p>
     *         <p>
     *         For an example bucket policy and usage report, see <a
     *         href="http://docs.aws.amazon.com/sns/latest/dg/sms_stats.html">Monitoring SMS Activity</a> in the
     *         <i>Amazon SNS Developer Guide</i>.
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetSmsAttributesRequest)) {
            return false;
        }
        SetSmsAttributesRequest other = (SetSmsAttributesRequest) obj;
        return Objects.equals(attributes(), other.attributes());
    }

    @Override
    public String toString() {
        return ToString.builder("SetSmsAttributesRequest").add("Attributes", attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetSmsAttributesRequest, T> g) {
        return obj -> g.apply((SetSmsAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnsRequest.Builder, SdkPojo, CopyableBuilder<Builder, SetSmsAttributesRequest> {
        /**
         * <p>
         * The default settings for sending SMS messages from your account. You can set values for the following
         * attribute names:
         * </p>
         * <p>
         * <code>MonthlySpendLimit</code> – The maximum amount in USD that you are willing to spend each month to send
         * SMS messages. When Amazon SNS determines that sending an SMS message would incur a cost that exceeds this
         * limit, it stops sending SMS messages within minutes.
         * </p>
         * <important>
         * <p>
         * Amazon SNS stops sending SMS messages within minutes of the limit being crossed. During that interval, if you
         * continue to send SMS messages, you will incur costs that exceed your limit.
         * </p>
         * </important>
         * <p>
         * By default, the spend limit is set to the maximum allowed by Amazon SNS. If you want to raise the limit,
         * submit an <a href=
         * "https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&amp;limitType=service-code-sns"
         * >SNS Limit Increase case</a>. For <b>New limit value</b>, enter your desired monthly spend limit. In the
         * <b>Use Case Description</b> field, explain that you are requesting an SMS monthly spend limit increase.
         * </p>
         * <p>
         * <code>DeliveryStatusIAMRole</code> – The ARN of the IAM role that allows Amazon SNS to write logs about SMS
         * deliveries in CloudWatch Logs. For each SMS message that you send, Amazon SNS writes a log that includes the
         * message price, the success or failure status, the reason for failure (if the message failed), the message
         * dwell time, and other information.
         * </p>
         * <p>
         * <code>DeliveryStatusSuccessSamplingRate</code> – The percentage of successful SMS deliveries for which Amazon
         * SNS will write logs in CloudWatch Logs. The value can be an integer from 0 - 100. For example, to write logs
         * only for failed deliveries, set this value to <code>0</code>. To write logs for 10% of your successful
         * deliveries, set it to <code>10</code>.
         * </p>
         * <p>
         * <code>DefaultSenderID</code> – A string, such as your business brand, that is displayed as the sender on the
         * receiving device. Support for sender IDs varies by country. The sender ID can be 1 - 11 alphanumeric
         * characters, and it must contain at least one letter.
         * </p>
         * <p>
         * <code>DefaultSMSType</code> – The type of SMS message that you will send by default. You can assign the
         * following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Promotional</code> – (Default) Noncritical messages, such as marketing messages. Amazon SNS optimizes
         * the message delivery to incur the lowest cost.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Transactional</code> – Critical messages that support customer transactions, such as one-time passcodes
         * for multi-factor authentication. Amazon SNS optimizes the message delivery to achieve the highest
         * reliability.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <code>UsageReportS3Bucket</code> – The name of the Amazon S3 bucket to receive daily SMS usage reports from
         * Amazon SNS. Each day, Amazon SNS will deliver a usage report as a CSV file to the bucket. The report includes
         * the following information for each SMS message that was successfully delivered by your account:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Time that the message was published (in UTC)
         * </p>
         * </li>
         * <li>
         * <p>
         * Message ID
         * </p>
         * </li>
         * <li>
         * <p>
         * Destination phone number
         * </p>
         * </li>
         * <li>
         * <p>
         * Message type
         * </p>
         * </li>
         * <li>
         * <p>
         * Delivery status
         * </p>
         * </li>
         * <li>
         * <p>
         * Message price (in USD)
         * </p>
         * </li>
         * <li>
         * <p>
         * Part number (a message is split into multiple parts if it is too long for a single message)
         * </p>
         * </li>
         * <li>
         * <p>
         * Total number of parts
         * </p>
         * </li>
         * </ul>
         * <p>
         * To receive the report, the bucket must have a policy that allows the Amazon SNS service principle to perform
         * the <code>s3:PutObject</code> and <code>s3:GetBucketLocation</code> actions.
         * </p>
         * <p>
         * For an example bucket policy and usage report, see <a
         * href="http://docs.aws.amazon.com/sns/latest/dg/sms_stats.html">Monitoring SMS Activity</a> in the <i>Amazon
         * SNS Developer Guide</i>.
         * </p>
         * 
         * @param attributes
         *        The default settings for sending SMS messages from your account. You can set values for the following
         *        attribute names:</p>
         *        <p>
         *        <code>MonthlySpendLimit</code> – The maximum amount in USD that you are willing to spend each month to
         *        send SMS messages. When Amazon SNS determines that sending an SMS message would incur a cost that
         *        exceeds this limit, it stops sending SMS messages within minutes.
         *        </p>
         *        <important>
         *        <p>
         *        Amazon SNS stops sending SMS messages within minutes of the limit being crossed. During that interval,
         *        if you continue to send SMS messages, you will incur costs that exceed your limit.
         *        </p>
         *        </important>
         *        <p>
         *        By default, the spend limit is set to the maximum allowed by Amazon SNS. If you want to raise the
         *        limit, submit an <a href=
         *        "https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&amp;limitType=service-code-sns"
         *        >SNS Limit Increase case</a>. For <b>New limit value</b>, enter your desired monthly spend limit. In
         *        the <b>Use Case Description</b> field, explain that you are requesting an SMS monthly spend limit
         *        increase.
         *        </p>
         *        <p>
         *        <code>DeliveryStatusIAMRole</code> – The ARN of the IAM role that allows Amazon SNS to write logs
         *        about SMS deliveries in CloudWatch Logs. For each SMS message that you send, Amazon SNS writes a log
         *        that includes the message price, the success or failure status, the reason for failure (if the message
         *        failed), the message dwell time, and other information.
         *        </p>
         *        <p>
         *        <code>DeliveryStatusSuccessSamplingRate</code> – The percentage of successful SMS deliveries for which
         *        Amazon SNS will write logs in CloudWatch Logs. The value can be an integer from 0 - 100. For example,
         *        to write logs only for failed deliveries, set this value to <code>0</code>. To write logs for 10% of
         *        your successful deliveries, set it to <code>10</code>.
         *        </p>
         *        <p>
         *        <code>DefaultSenderID</code> – A string, such as your business brand, that is displayed as the sender
         *        on the receiving device. Support for sender IDs varies by country. The sender ID can be 1 - 11
         *        alphanumeric characters, and it must contain at least one letter.
         *        </p>
         *        <p>
         *        <code>DefaultSMSType</code> – The type of SMS message that you will send by default. You can assign
         *        the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Promotional</code> – (Default) Noncritical messages, such as marketing messages. Amazon SNS
         *        optimizes the message delivery to incur the lowest cost.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Transactional</code> – Critical messages that support customer transactions, such as one-time
         *        passcodes for multi-factor authentication. Amazon SNS optimizes the message delivery to achieve the
         *        highest reliability.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <code>UsageReportS3Bucket</code> – The name of the Amazon S3 bucket to receive daily SMS usage reports
         *        from Amazon SNS. Each day, Amazon SNS will deliver a usage report as a CSV file to the bucket. The
         *        report includes the following information for each SMS message that was successfully delivered by your
         *        account:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Time that the message was published (in UTC)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Message ID
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Destination phone number
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Message type
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Delivery status
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Message price (in USD)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Part number (a message is split into multiple parts if it is too long for a single message)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Total number of parts
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To receive the report, the bucket must have a policy that allows the Amazon SNS service principle to
         *        perform the <code>s3:PutObject</code> and <code>s3:GetBucketLocation</code> actions.
         *        </p>
         *        <p>
         *        For an example bucket policy and usage report, see <a
         *        href="http://docs.aws.amazon.com/sns/latest/dg/sms_stats.html">Monitoring SMS Activity</a> in the
         *        <i>Amazon SNS Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SnsRequest.BuilderImpl implements Builder {
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SetSmsAttributesRequest model) {
            super(model);
            attributes(model.attributes);
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetSmsAttributesRequest build() {
            return new SetSmsAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
