/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response for GetSubscriptionAttributes action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSubscriptionAttributesResponse extends SnsResponse implements
        ToCopyableBuilder<GetSubscriptionAttributesResponse.Builder, GetSubscriptionAttributesResponse> {
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(GetSubscriptionAttributesResponse::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD));

    private final Map<String, String> attributes;

    private GetSubscriptionAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * A map of the subscription's attributes. Attributes in this map include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ConfirmationWasAuthenticated</code> – <code>true</code> if the subscription confirmation request was
     * authenticated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeliveryPolicy</code> – The JSON serialization of the subscription's delivery policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EffectiveDeliveryPolicy</code> – The JSON serialization of the effective delivery policy that takes into
     * account the topic delivery policy and account system defaults.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FilterPolicy</code> – The filter policy JSON that is assigned to the subscription.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Owner</code> – The AWS account ID of the subscription's owner.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PendingConfirmation</code> – <code>true</code> if the subscription hasn't been confirmed. To confirm a
     * pending subscription, call the <code>ConfirmSubscription</code> action with a confirmation token.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RawMessageDelivery</code> – <code>true</code> if raw message delivery is enabled for the subscription. Raw
     * messages are free of JSON formatting and can be sent to HTTP/S and Amazon SQS endpoints.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SubscriptionArn</code> – The subscription's ARN.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TopicArn</code> – The topic ARN that the subscription is associated with.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of the subscription's attributes. Attributes in this map include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ConfirmationWasAuthenticated</code> – <code>true</code> if the subscription confirmation request
     *         was authenticated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeliveryPolicy</code> – The JSON serialization of the subscription's delivery policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EffectiveDeliveryPolicy</code> – The JSON serialization of the effective delivery policy that takes
     *         into account the topic delivery policy and account system defaults.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FilterPolicy</code> – The filter policy JSON that is assigned to the subscription.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Owner</code> – The AWS account ID of the subscription's owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PendingConfirmation</code> – <code>true</code> if the subscription hasn't been confirmed. To
     *         confirm a pending subscription, call the <code>ConfirmSubscription</code> action with a confirmation
     *         token.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RawMessageDelivery</code> – <code>true</code> if raw message delivery is enabled for the
     *         subscription. Raw messages are free of JSON formatting and can be sent to HTTP/S and Amazon SQS
     *         endpoints.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SubscriptionArn</code> – The subscription's ARN.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TopicArn</code> – The topic ARN that the subscription is associated with.
     *         </p>
     *         </li>
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSubscriptionAttributesResponse)) {
            return false;
        }
        GetSubscriptionAttributesResponse other = (GetSubscriptionAttributesResponse) obj;
        return Objects.equals(attributes(), other.attributes());
    }

    @Override
    public String toString() {
        return ToString.builder("GetSubscriptionAttributesResponse").add("Attributes", attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSubscriptionAttributesResponse, T> g) {
        return obj -> g.apply((GetSubscriptionAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSubscriptionAttributesResponse> {
        /**
         * <p>
         * A map of the subscription's attributes. Attributes in this map include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ConfirmationWasAuthenticated</code> – <code>true</code> if the subscription confirmation request was
         * authenticated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeliveryPolicy</code> – The JSON serialization of the subscription's delivery policy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EffectiveDeliveryPolicy</code> – The JSON serialization of the effective delivery policy that takes
         * into account the topic delivery policy and account system defaults.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FilterPolicy</code> – The filter policy JSON that is assigned to the subscription.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Owner</code> – The AWS account ID of the subscription's owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PendingConfirmation</code> – <code>true</code> if the subscription hasn't been confirmed. To confirm a
         * pending subscription, call the <code>ConfirmSubscription</code> action with a confirmation token.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RawMessageDelivery</code> – <code>true</code> if raw message delivery is enabled for the subscription.
         * Raw messages are free of JSON formatting and can be sent to HTTP/S and Amazon SQS endpoints.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SubscriptionArn</code> – The subscription's ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TopicArn</code> – The topic ARN that the subscription is associated with.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributes
         *        A map of the subscription's attributes. Attributes in this map include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ConfirmationWasAuthenticated</code> – <code>true</code> if the subscription confirmation request
         *        was authenticated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeliveryPolicy</code> – The JSON serialization of the subscription's delivery policy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EffectiveDeliveryPolicy</code> – The JSON serialization of the effective delivery policy that
         *        takes into account the topic delivery policy and account system defaults.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FilterPolicy</code> – The filter policy JSON that is assigned to the subscription.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Owner</code> – The AWS account ID of the subscription's owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PendingConfirmation</code> – <code>true</code> if the subscription hasn't been confirmed. To
         *        confirm a pending subscription, call the <code>ConfirmSubscription</code> action with a confirmation
         *        token.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RawMessageDelivery</code> – <code>true</code> if raw message delivery is enabled for the
         *        subscription. Raw messages are free of JSON formatting and can be sent to HTTP/S and Amazon SQS
         *        endpoints.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SubscriptionArn</code> – The subscription's ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TopicArn</code> – The topic ARN that the subscription is associated with.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);
    }

    static final class BuilderImpl extends SnsResponse.BuilderImpl implements Builder {
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSubscriptionAttributesResponse model) {
            super(model);
            attributes(model.attributes);
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = SubscriptionAttributesMapCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = SubscriptionAttributesMapCopier.copy(attributes);
        }

        @Override
        public GetSubscriptionAttributesResponse build() {
            return new GetSubscriptionAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
