/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Subscription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Subscription> {
    private static final SdkField<String> SUBSCRIPTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubscriptionArn").getter(Subscription.getter(Subscription::subscriptionArn)).setter(Subscription.setter(Builder::subscriptionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionArn").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(Subscription.getter(Subscription::owner)).setter(Subscription.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(Subscription.getter(Subscription::protocol)).setter(Subscription.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Endpoint").getter(Subscription.getter(Subscription::endpoint)).setter(Subscription.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicArn").getter(Subscription.getter(Subscription::topicArn)).setter(Subscription.setter(Builder::topicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_ARN_FIELD, OWNER_FIELD, PROTOCOL_FIELD, ENDPOINT_FIELD, TOPIC_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Subscription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String subscriptionArn;
    private final String owner;
    private final String protocol;
    private final String endpoint;
    private final String topicArn;

    private Subscription(BuilderImpl builder) {
        this.subscriptionArn = builder.subscriptionArn;
        this.owner = builder.owner;
        this.protocol = builder.protocol;
        this.endpoint = builder.endpoint;
        this.topicArn = builder.topicArn;
    }

    public final String subscriptionArn() {
        return this.subscriptionArn;
    }

    public final String owner() {
        return this.owner;
    }

    public final String protocol() {
        return this.protocol;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final String topicArn() {
        return this.topicArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)obj;
        return Objects.equals(this.subscriptionArn(), other.subscriptionArn()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.topicArn(), other.topicArn());
    }

    public final String toString() {
        return ToString.builder((String)"Subscription").add("SubscriptionArn", (Object)this.subscriptionArn()).add("Owner", (Object)this.owner()).add("Protocol", (Object)this.protocol()).add("Endpoint", (Object)this.endpoint()).add("TopicArn", (Object)this.topicArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubscriptionArn": {
                return Optional.ofNullable(clazz.cast(this.subscriptionArn()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "TopicArn": {
                return Optional.ofNullable(clazz.cast(this.topicArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("SubscriptionArn", SUBSCRIPTION_ARN_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("Endpoint", ENDPOINT_FIELD);
        map.put("TopicArn", TOPIC_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Subscription, T> g) {
        return obj -> g.apply((Subscription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String subscriptionArn;
        private String owner;
        private String protocol;
        private String endpoint;
        private String topicArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Subscription model) {
            this.subscriptionArn(model.subscriptionArn);
            this.owner(model.owner);
            this.protocol(model.protocol);
            this.endpoint(model.endpoint);
            this.topicArn(model.topicArn);
        }

        public final String getSubscriptionArn() {
            return this.subscriptionArn;
        }

        public final void setSubscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
        }

        @Override
        public final Builder subscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public Subscription build() {
            return new Subscription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Subscription> {
        public Builder subscriptionArn(String var1);

        public Builder owner(String var1);

        public Builder protocol(String var1);

        public Builder endpoint(String var1);

        public Builder topicArn(String var1);
    }
}

