/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for ListEndpointsByPlatformApplication action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEndpointsByPlatformApplicationRequest extends SnsRequest implements
        ToCopyableBuilder<ListEndpointsByPlatformApplicationRequest.Builder, ListEndpointsByPlatformApplicationRequest> {
    private static final SdkField<String> PLATFORM_APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListEndpointsByPlatformApplicationRequest::platformApplicationArn))
            .setter(setter(Builder::platformApplicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformApplicationArn").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListEndpointsByPlatformApplicationRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PLATFORM_APPLICATION_ARN_FIELD, NEXT_TOKEN_FIELD));

    private final String platformApplicationArn;

    private final String nextToken;

    private ListEndpointsByPlatformApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.platformApplicationArn = builder.platformApplicationArn;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * PlatformApplicationArn for ListEndpointsByPlatformApplicationInput action.
     * </p>
     * 
     * @return PlatformApplicationArn for ListEndpointsByPlatformApplicationInput action.
     */
    public String platformApplicationArn() {
        return platformApplicationArn;
    }

    /**
     * <p>
     * NextToken string is used when calling ListEndpointsByPlatformApplication action to retrieve additional records
     * that are available after the first page results.
     * </p>
     * 
     * @return NextToken string is used when calling ListEndpointsByPlatformApplication action to retrieve additional
     *         records that are available after the first page results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(platformApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEndpointsByPlatformApplicationRequest)) {
            return false;
        }
        ListEndpointsByPlatformApplicationRequest other = (ListEndpointsByPlatformApplicationRequest) obj;
        return Objects.equals(platformApplicationArn(), other.platformApplicationArn())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListEndpointsByPlatformApplicationRequest")
                .add("PlatformApplicationArn", platformApplicationArn()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlatformApplicationArn":
            return Optional.ofNullable(clazz.cast(platformApplicationArn()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEndpointsByPlatformApplicationRequest, T> g) {
        return obj -> g.apply((ListEndpointsByPlatformApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEndpointsByPlatformApplicationRequest> {
        /**
         * <p>
         * PlatformApplicationArn for ListEndpointsByPlatformApplicationInput action.
         * </p>
         * 
         * @param platformApplicationArn
         *        PlatformApplicationArn for ListEndpointsByPlatformApplicationInput action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformApplicationArn(String platformApplicationArn);

        /**
         * <p>
         * NextToken string is used when calling ListEndpointsByPlatformApplication action to retrieve additional
         * records that are available after the first page results.
         * </p>
         * 
         * @param nextToken
         *        NextToken string is used when calling ListEndpointsByPlatformApplication action to retrieve additional
         *        records that are available after the first page results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SnsRequest.BuilderImpl implements Builder {
        private String platformApplicationArn;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEndpointsByPlatformApplicationRequest model) {
            super(model);
            platformApplicationArn(model.platformApplicationArn);
            nextToken(model.nextToken);
        }

        public final String getPlatformApplicationArn() {
            return platformApplicationArn;
        }

        @Override
        public final Builder platformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
            return this;
        }

        public final void setPlatformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEndpointsByPlatformApplicationRequest build() {
            return new ListEndpointsByPlatformApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
