/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for CreatePlatformApplication action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePlatformApplicationRequest extends SnsRequest implements
        ToCopyableBuilder<CreatePlatformApplicationRequest.Builder, CreatePlatformApplicationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePlatformApplicationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePlatformApplicationRequest::platform)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreatePlatformApplicationRequest::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PLATFORM_FIELD,
            ATTRIBUTES_FIELD));

    private final String name;

    private final String platform;

    private final Map<String, String> attributes;

    private CreatePlatformApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.platform = builder.platform;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * Application names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, hyphens,
     * and periods, and must be between 1 and 256 characters long.
     * </p>
     * 
     * @return Application names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores,
     *         hyphens, and periods, and must be between 1 and 256 characters long.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The following platforms are supported: ADM (Amazon Device Messaging), APNS (Apple Push Notification Service),
     * APNS_SANDBOX, and GCM (Google Cloud Messaging).
     * </p>
     * 
     * @return The following platforms are supported: ADM (Amazon Device Messaging), APNS (Apple Push Notification
     *         Service), APNS_SANDBOX, and GCM (Google Cloud Messaging).
     */
    public String platform() {
        return platform;
    }

    /**
     * <p>
     * For a list of attributes, see <a
     * href="https://docs.aws.amazon.com/sns/latest/api/API_SetPlatformApplicationAttributes.html"
     * >SetPlatformApplicationAttributes</a>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return For a list of attributes, see <a
     *         href="https://docs.aws.amazon.com/sns/latest/api/API_SetPlatformApplicationAttributes.html"
     *         >SetPlatformApplicationAttributes</a>
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlatformApplicationRequest)) {
            return false;
        }
        CreatePlatformApplicationRequest other = (CreatePlatformApplicationRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(platform(), other.platform())
                && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreatePlatformApplicationRequest").add("Name", name()).add("Platform", platform())
                .add("Attributes", attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePlatformApplicationRequest, T> g) {
        return obj -> g.apply((CreatePlatformApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePlatformApplicationRequest> {
        /**
         * <p>
         * Application names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores,
         * hyphens, and periods, and must be between 1 and 256 characters long.
         * </p>
         * 
         * @param name
         *        Application names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores,
         *        hyphens, and periods, and must be between 1 and 256 characters long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The following platforms are supported: ADM (Amazon Device Messaging), APNS (Apple Push Notification Service),
         * APNS_SANDBOX, and GCM (Google Cloud Messaging).
         * </p>
         * 
         * @param platform
         *        The following platforms are supported: ADM (Amazon Device Messaging), APNS (Apple Push Notification
         *        Service), APNS_SANDBOX, and GCM (Google Cloud Messaging).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * For a list of attributes, see <a
         * href="https://docs.aws.amazon.com/sns/latest/api/API_SetPlatformApplicationAttributes.html"
         * >SetPlatformApplicationAttributes</a>
         * </p>
         * 
         * @param attributes
         *        For a list of attributes, see <a
         *        href="https://docs.aws.amazon.com/sns/latest/api/API_SetPlatformApplicationAttributes.html"
         *        >SetPlatformApplicationAttributes</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SnsRequest.BuilderImpl implements Builder {
        private String name;

        private String platform;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlatformApplicationRequest model) {
            super(model);
            name(model.name);
            platform(model.platform);
            attributes(model.attributes);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePlatformApplicationRequest build() {
            return new CreatePlatformApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
