/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLinkedWhatsAppBusinessAccountPhoneNumberResponse extends SocialMessagingResponse
        implements
        ToCopyableBuilder<GetLinkedWhatsAppBusinessAccountPhoneNumberResponse.Builder, GetLinkedWhatsAppBusinessAccountPhoneNumberResponse> {
    private static final SdkField<WhatsAppPhoneNumberDetail> PHONE_NUMBER_FIELD = SdkField
            .<WhatsAppPhoneNumberDetail> builder(MarshallingType.SDK_POJO).memberName("phoneNumber")
            .getter(getter(GetLinkedWhatsAppBusinessAccountPhoneNumberResponse::phoneNumber))
            .setter(setter(Builder::phoneNumber)).constructor(WhatsAppPhoneNumberDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phoneNumber").build()).build();

    private static final SdkField<String> LINKED_WHATS_APP_BUSINESS_ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("linkedWhatsAppBusinessAccountId")
            .getter(getter(GetLinkedWhatsAppBusinessAccountPhoneNumberResponse::linkedWhatsAppBusinessAccountId))
            .setter(setter(Builder::linkedWhatsAppBusinessAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linkedWhatsAppBusinessAccountId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_FIELD,
            LINKED_WHATS_APP_BUSINESS_ACCOUNT_ID_FIELD));

    private final WhatsAppPhoneNumberDetail phoneNumber;

    private final String linkedWhatsAppBusinessAccountId;

    private GetLinkedWhatsAppBusinessAccountPhoneNumberResponse(BuilderImpl builder) {
        super(builder);
        this.phoneNumber = builder.phoneNumber;
        this.linkedWhatsAppBusinessAccountId = builder.linkedWhatsAppBusinessAccountId;
    }

    /**
     * Returns the value of the PhoneNumber property for this object.
     * 
     * @return The value of the PhoneNumber property for this object.
     */
    public final WhatsAppPhoneNumberDetail phoneNumber() {
        return phoneNumber;
    }

    /**
     * <p>
     * The WABA identifier linked to the phone number, formatted as <code>waba-01234567890123456789012345678901</code>.
     * </p>
     * 
     * @return The WABA identifier linked to the phone number, formatted as
     *         <code>waba-01234567890123456789012345678901</code>.
     */
    public final String linkedWhatsAppBusinessAccountId() {
        return linkedWhatsAppBusinessAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(linkedWhatsAppBusinessAccountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLinkedWhatsAppBusinessAccountPhoneNumberResponse)) {
            return false;
        }
        GetLinkedWhatsAppBusinessAccountPhoneNumberResponse other = (GetLinkedWhatsAppBusinessAccountPhoneNumberResponse) obj;
        return Objects.equals(phoneNumber(), other.phoneNumber())
                && Objects.equals(linkedWhatsAppBusinessAccountId(), other.linkedWhatsAppBusinessAccountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLinkedWhatsAppBusinessAccountPhoneNumberResponse").add("PhoneNumber", phoneNumber())
                .add("LinkedWhatsAppBusinessAccountId", linkedWhatsAppBusinessAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "phoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "linkedWhatsAppBusinessAccountId":
            return Optional.ofNullable(clazz.cast(linkedWhatsAppBusinessAccountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLinkedWhatsAppBusinessAccountPhoneNumberResponse, T> g) {
        return obj -> g.apply((GetLinkedWhatsAppBusinessAccountPhoneNumberResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SocialMessagingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetLinkedWhatsAppBusinessAccountPhoneNumberResponse> {
        /**
         * Sets the value of the PhoneNumber property for this object.
         *
         * @param phoneNumber
         *        The new value for the PhoneNumber property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(WhatsAppPhoneNumberDetail phoneNumber);

        /**
         * Sets the value of the PhoneNumber property for this object.
         *
         * This is a convenience method that creates an instance of the {@link WhatsAppPhoneNumberDetail.Builder}
         * avoiding the need to create one manually via {@link WhatsAppPhoneNumberDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WhatsAppPhoneNumberDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #phoneNumber(WhatsAppPhoneNumberDetail)}.
         * 
         * @param phoneNumber
         *        a consumer that will call methods on {@link WhatsAppPhoneNumberDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phoneNumber(WhatsAppPhoneNumberDetail)
         */
        default Builder phoneNumber(Consumer<WhatsAppPhoneNumberDetail.Builder> phoneNumber) {
            return phoneNumber(WhatsAppPhoneNumberDetail.builder().applyMutation(phoneNumber).build());
        }

        /**
         * <p>
         * The WABA identifier linked to the phone number, formatted as
         * <code>waba-01234567890123456789012345678901</code>.
         * </p>
         * 
         * @param linkedWhatsAppBusinessAccountId
         *        The WABA identifier linked to the phone number, formatted as
         *        <code>waba-01234567890123456789012345678901</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkedWhatsAppBusinessAccountId(String linkedWhatsAppBusinessAccountId);
    }

    static final class BuilderImpl extends SocialMessagingResponse.BuilderImpl implements Builder {
        private WhatsAppPhoneNumberDetail phoneNumber;

        private String linkedWhatsAppBusinessAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLinkedWhatsAppBusinessAccountPhoneNumberResponse model) {
            super(model);
            phoneNumber(model.phoneNumber);
            linkedWhatsAppBusinessAccountId(model.linkedWhatsAppBusinessAccountId);
        }

        public final WhatsAppPhoneNumberDetail.Builder getPhoneNumber() {
            return phoneNumber != null ? phoneNumber.toBuilder() : null;
        }

        public final void setPhoneNumber(WhatsAppPhoneNumberDetail.BuilderImpl phoneNumber) {
            this.phoneNumber = phoneNumber != null ? phoneNumber.build() : null;
        }

        @Override
        public final Builder phoneNumber(WhatsAppPhoneNumberDetail phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getLinkedWhatsAppBusinessAccountId() {
            return linkedWhatsAppBusinessAccountId;
        }

        public final void setLinkedWhatsAppBusinessAccountId(String linkedWhatsAppBusinessAccountId) {
            this.linkedWhatsAppBusinessAccountId = linkedWhatsAppBusinessAccountId;
        }

        @Override
        public final Builder linkedWhatsAppBusinessAccountId(String linkedWhatsAppBusinessAccountId) {
            this.linkedWhatsAppBusinessAccountId = linkedWhatsAppBusinessAccountId;
            return this;
        }

        @Override
        public GetLinkedWhatsAppBusinessAccountPhoneNumberResponse build() {
            return new GetLinkedWhatsAppBusinessAccountPhoneNumberResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
