/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWhatsAppMessageMediaRequest extends SocialMessagingRequest implements
        ToCopyableBuilder<GetWhatsAppMessageMediaRequest.Builder, GetWhatsAppMessageMediaRequest> {
    private static final SdkField<String> MEDIA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mediaId").getter(getter(GetWhatsAppMessageMediaRequest::mediaId)).setter(setter(Builder::mediaId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaId").build()).build();

    private static final SdkField<String> ORIGINATION_PHONE_NUMBER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("originationPhoneNumberId").getter(getter(GetWhatsAppMessageMediaRequest::originationPhoneNumberId))
            .setter(setter(Builder::originationPhoneNumberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originationPhoneNumberId").build())
            .build();

    private static final SdkField<Boolean> METADATA_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("metadataOnly").getter(getter(GetWhatsAppMessageMediaRequest::metadataOnly))
            .setter(setter(Builder::metadataOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataOnly").build()).build();

    private static final SdkField<S3PresignedUrl> DESTINATION_S3_PRESIGNED_URL_FIELD = SdkField
            .<S3PresignedUrl> builder(MarshallingType.SDK_POJO).memberName("destinationS3PresignedUrl")
            .getter(getter(GetWhatsAppMessageMediaRequest::destinationS3PresignedUrl))
            .setter(setter(Builder::destinationS3PresignedUrl)).constructor(S3PresignedUrl::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationS3PresignedUrl").build())
            .build();

    private static final SdkField<S3File> DESTINATION_S3_FILE_FIELD = SdkField.<S3File> builder(MarshallingType.SDK_POJO)
            .memberName("destinationS3File").getter(getter(GetWhatsAppMessageMediaRequest::destinationS3File))
            .setter(setter(Builder::destinationS3File)).constructor(S3File::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationS3File").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MEDIA_ID_FIELD, ORIGINATION_PHONE_NUMBER_ID_FIELD, METADATA_ONLY_FIELD, DESTINATION_S3_PRESIGNED_URL_FIELD,
                    DESTINATION_S3_FILE_FIELD));

    private final String mediaId;

    private final String originationPhoneNumberId;

    private final Boolean metadataOnly;

    private final S3PresignedUrl destinationS3PresignedUrl;

    private final S3File destinationS3File;

    private GetWhatsAppMessageMediaRequest(BuilderImpl builder) {
        super(builder);
        this.mediaId = builder.mediaId;
        this.originationPhoneNumberId = builder.originationPhoneNumberId;
        this.metadataOnly = builder.metadataOnly;
        this.destinationS3PresignedUrl = builder.destinationS3PresignedUrl;
        this.destinationS3File = builder.destinationS3File;
    }

    /**
     * <p>
     * The unique identifier for the media file.
     * </p>
     * 
     * @return The unique identifier for the media file.
     */
    public final String mediaId() {
        return mediaId;
    }

    /**
     * <p>
     * The unique identifier of the originating phone number for the WhatsApp message media. The phone number
     * identifiers are formatted as <code>phone-number-id-01234567890123456789012345678901</code>. Use <a href=
     * "https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetLinkedWhatsAppBusinessAccountPhoneNumber.html"
     * >GetLinkedWhatsAppBusinessAccount</a> to find a phone number's id.
     * </p>
     * 
     * @return The unique identifier of the originating phone number for the WhatsApp message media. The phone number
     *         identifiers are formatted as <code>phone-number-id-01234567890123456789012345678901</code>. Use <a href=
     *         "https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetLinkedWhatsAppBusinessAccountPhoneNumber.html"
     *         >GetLinkedWhatsAppBusinessAccount</a> to find a phone number's id.
     */
    public final String originationPhoneNumberId() {
        return originationPhoneNumberId;
    }

    /**
     * <p>
     * Set to <code>True</code> to get only the metadata for the file.
     * </p>
     * 
     * @return Set to <code>True</code> to get only the metadata for the file.
     */
    public final Boolean metadataOnly() {
        return metadataOnly;
    }

    /**
     * <p>
     * The presign url of the media file.
     * </p>
     * 
     * @return The presign url of the media file.
     */
    public final S3PresignedUrl destinationS3PresignedUrl() {
        return destinationS3PresignedUrl;
    }

    /**
     * <p>
     * The <code>bucketName</code> and <code>key</code> of the S3 media file.
     * </p>
     * 
     * @return The <code>bucketName</code> and <code>key</code> of the S3 media file.
     */
    public final S3File destinationS3File() {
        return destinationS3File;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mediaId());
        hashCode = 31 * hashCode + Objects.hashCode(originationPhoneNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(metadataOnly());
        hashCode = 31 * hashCode + Objects.hashCode(destinationS3PresignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(destinationS3File());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWhatsAppMessageMediaRequest)) {
            return false;
        }
        GetWhatsAppMessageMediaRequest other = (GetWhatsAppMessageMediaRequest) obj;
        return Objects.equals(mediaId(), other.mediaId())
                && Objects.equals(originationPhoneNumberId(), other.originationPhoneNumberId())
                && Objects.equals(metadataOnly(), other.metadataOnly())
                && Objects.equals(destinationS3PresignedUrl(), other.destinationS3PresignedUrl())
                && Objects.equals(destinationS3File(), other.destinationS3File());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWhatsAppMessageMediaRequest").add("MediaId", mediaId())
                .add("OriginationPhoneNumberId", originationPhoneNumberId()).add("MetadataOnly", metadataOnly())
                .add("DestinationS3PresignedUrl", destinationS3PresignedUrl() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DestinationS3File", destinationS3File() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mediaId":
            return Optional.ofNullable(clazz.cast(mediaId()));
        case "originationPhoneNumberId":
            return Optional.ofNullable(clazz.cast(originationPhoneNumberId()));
        case "metadataOnly":
            return Optional.ofNullable(clazz.cast(metadataOnly()));
        case "destinationS3PresignedUrl":
            return Optional.ofNullable(clazz.cast(destinationS3PresignedUrl()));
        case "destinationS3File":
            return Optional.ofNullable(clazz.cast(destinationS3File()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWhatsAppMessageMediaRequest, T> g) {
        return obj -> g.apply((GetWhatsAppMessageMediaRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SocialMessagingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetWhatsAppMessageMediaRequest> {
        /**
         * <p>
         * The unique identifier for the media file.
         * </p>
         * 
         * @param mediaId
         *        The unique identifier for the media file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaId(String mediaId);

        /**
         * <p>
         * The unique identifier of the originating phone number for the WhatsApp message media. The phone number
         * identifiers are formatted as <code>phone-number-id-01234567890123456789012345678901</code>. Use <a href=
         * "https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetLinkedWhatsAppBusinessAccountPhoneNumber.html"
         * >GetLinkedWhatsAppBusinessAccount</a> to find a phone number's id.
         * </p>
         * 
         * @param originationPhoneNumberId
         *        The unique identifier of the originating phone number for the WhatsApp message media. The phone number
         *        identifiers are formatted as <code>phone-number-id-01234567890123456789012345678901</code>. Use <a
         *        href=
         *        "https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetLinkedWhatsAppBusinessAccountPhoneNumber.html"
         *        >GetLinkedWhatsAppBusinessAccount</a> to find a phone number's id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originationPhoneNumberId(String originationPhoneNumberId);

        /**
         * <p>
         * Set to <code>True</code> to get only the metadata for the file.
         * </p>
         * 
         * @param metadataOnly
         *        Set to <code>True</code> to get only the metadata for the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataOnly(Boolean metadataOnly);

        /**
         * <p>
         * The presign url of the media file.
         * </p>
         * 
         * @param destinationS3PresignedUrl
         *        The presign url of the media file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationS3PresignedUrl(S3PresignedUrl destinationS3PresignedUrl);

        /**
         * <p>
         * The presign url of the media file.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3PresignedUrl.Builder} avoiding the need
         * to create one manually via {@link S3PresignedUrl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3PresignedUrl.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationS3PresignedUrl(S3PresignedUrl)}.
         * 
         * @param destinationS3PresignedUrl
         *        a consumer that will call methods on {@link S3PresignedUrl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationS3PresignedUrl(S3PresignedUrl)
         */
        default Builder destinationS3PresignedUrl(Consumer<S3PresignedUrl.Builder> destinationS3PresignedUrl) {
            return destinationS3PresignedUrl(S3PresignedUrl.builder().applyMutation(destinationS3PresignedUrl).build());
        }

        /**
         * <p>
         * The <code>bucketName</code> and <code>key</code> of the S3 media file.
         * </p>
         * 
         * @param destinationS3File
         *        The <code>bucketName</code> and <code>key</code> of the S3 media file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationS3File(S3File destinationS3File);

        /**
         * <p>
         * The <code>bucketName</code> and <code>key</code> of the S3 media file.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3File.Builder} avoiding the need to
         * create one manually via {@link S3File#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3File.Builder#build()} is called immediately and its result is
         * passed to {@link #destinationS3File(S3File)}.
         * 
         * @param destinationS3File
         *        a consumer that will call methods on {@link S3File.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationS3File(S3File)
         */
        default Builder destinationS3File(Consumer<S3File.Builder> destinationS3File) {
            return destinationS3File(S3File.builder().applyMutation(destinationS3File).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SocialMessagingRequest.BuilderImpl implements Builder {
        private String mediaId;

        private String originationPhoneNumberId;

        private Boolean metadataOnly;

        private S3PresignedUrl destinationS3PresignedUrl;

        private S3File destinationS3File;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWhatsAppMessageMediaRequest model) {
            super(model);
            mediaId(model.mediaId);
            originationPhoneNumberId(model.originationPhoneNumberId);
            metadataOnly(model.metadataOnly);
            destinationS3PresignedUrl(model.destinationS3PresignedUrl);
            destinationS3File(model.destinationS3File);
        }

        public final String getMediaId() {
            return mediaId;
        }

        public final void setMediaId(String mediaId) {
            this.mediaId = mediaId;
        }

        @Override
        public final Builder mediaId(String mediaId) {
            this.mediaId = mediaId;
            return this;
        }

        public final String getOriginationPhoneNumberId() {
            return originationPhoneNumberId;
        }

        public final void setOriginationPhoneNumberId(String originationPhoneNumberId) {
            this.originationPhoneNumberId = originationPhoneNumberId;
        }

        @Override
        public final Builder originationPhoneNumberId(String originationPhoneNumberId) {
            this.originationPhoneNumberId = originationPhoneNumberId;
            return this;
        }

        public final Boolean getMetadataOnly() {
            return metadataOnly;
        }

        public final void setMetadataOnly(Boolean metadataOnly) {
            this.metadataOnly = metadataOnly;
        }

        @Override
        public final Builder metadataOnly(Boolean metadataOnly) {
            this.metadataOnly = metadataOnly;
            return this;
        }

        public final S3PresignedUrl.Builder getDestinationS3PresignedUrl() {
            return destinationS3PresignedUrl != null ? destinationS3PresignedUrl.toBuilder() : null;
        }

        public final void setDestinationS3PresignedUrl(S3PresignedUrl.BuilderImpl destinationS3PresignedUrl) {
            this.destinationS3PresignedUrl = destinationS3PresignedUrl != null ? destinationS3PresignedUrl.build() : null;
        }

        @Override
        public final Builder destinationS3PresignedUrl(S3PresignedUrl destinationS3PresignedUrl) {
            this.destinationS3PresignedUrl = destinationS3PresignedUrl;
            return this;
        }

        public final S3File.Builder getDestinationS3File() {
            return destinationS3File != null ? destinationS3File.toBuilder() : null;
        }

        public final void setDestinationS3File(S3File.BuilderImpl destinationS3File) {
            this.destinationS3File = destinationS3File != null ? destinationS3File.build() : null;
        }

        @Override
        public final Builder destinationS3File(S3File destinationS3File) {
            this.destinationS3File = destinationS3File;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetWhatsAppMessageMediaRequest build() {
            return new GetWhatsAppMessageMediaRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
