/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWhatsAppMessageMediaResponse extends SocialMessagingResponse implements
        ToCopyableBuilder<GetWhatsAppMessageMediaResponse.Builder, GetWhatsAppMessageMediaResponse> {
    private static final SdkField<String> MIME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mimeType").getter(getter(GetWhatsAppMessageMediaResponse::mimeType)).setter(setter(Builder::mimeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mimeType").build()).build();

    private static final SdkField<Long> FILE_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("fileSize")
            .getter(getter(GetWhatsAppMessageMediaResponse::fileSize)).setter(setter(Builder::fileSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIME_TYPE_FIELD,
            FILE_SIZE_FIELD));

    private final String mimeType;

    private final Long fileSize;

    private GetWhatsAppMessageMediaResponse(BuilderImpl builder) {
        super(builder);
        this.mimeType = builder.mimeType;
        this.fileSize = builder.fileSize;
    }

    /**
     * <p>
     * The MIME type of the media.
     * </p>
     * 
     * @return The MIME type of the media.
     */
    public final String mimeType() {
        return mimeType;
    }

    /**
     * <p>
     * The file size of the media, in KB.
     * </p>
     * 
     * @return The file size of the media, in KB.
     */
    public final Long fileSize() {
        return fileSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mimeType());
        hashCode = 31 * hashCode + Objects.hashCode(fileSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWhatsAppMessageMediaResponse)) {
            return false;
        }
        GetWhatsAppMessageMediaResponse other = (GetWhatsAppMessageMediaResponse) obj;
        return Objects.equals(mimeType(), other.mimeType()) && Objects.equals(fileSize(), other.fileSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWhatsAppMessageMediaResponse").add("MimeType", mimeType()).add("FileSize", fileSize())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mimeType":
            return Optional.ofNullable(clazz.cast(mimeType()));
        case "fileSize":
            return Optional.ofNullable(clazz.cast(fileSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWhatsAppMessageMediaResponse, T> g) {
        return obj -> g.apply((GetWhatsAppMessageMediaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SocialMessagingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetWhatsAppMessageMediaResponse> {
        /**
         * <p>
         * The MIME type of the media.
         * </p>
         * 
         * @param mimeType
         *        The MIME type of the media.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mimeType(String mimeType);

        /**
         * <p>
         * The file size of the media, in KB.
         * </p>
         * 
         * @param fileSize
         *        The file size of the media, in KB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSize(Long fileSize);
    }

    static final class BuilderImpl extends SocialMessagingResponse.BuilderImpl implements Builder {
        private String mimeType;

        private Long fileSize;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWhatsAppMessageMediaResponse model) {
            super(model);
            mimeType(model.mimeType);
            fileSize(model.fileSize);
        }

        public final String getMimeType() {
            return mimeType;
        }

        public final void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        @Override
        public final Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public final Long getFileSize() {
            return fileSize;
        }

        public final void setFileSize(Long fileSize) {
            this.fileSize = fileSize;
        }

        @Override
        public final Builder fileSize(Long fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        @Override
        public GetWhatsAppMessageMediaResponse build() {
            return new GetWhatsAppMessageMediaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
