/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a linked WhatsApp Business Account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LinkedWhatsAppBusinessAccountSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<LinkedWhatsAppBusinessAccountSummary.Builder, LinkedWhatsAppBusinessAccountSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(LinkedWhatsAppBusinessAccountSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(LinkedWhatsAppBusinessAccountSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> WABA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("wabaId")
            .getter(getter(LinkedWhatsAppBusinessAccountSummary::wabaId)).setter(setter(Builder::wabaId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wabaId").build()).build();

    private static final SdkField<String> REGISTRATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registrationStatus").getter(getter(LinkedWhatsAppBusinessAccountSummary::registrationStatusAsString))
            .setter(setter(Builder::registrationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationStatus").build())
            .build();

    private static final SdkField<Instant> LINK_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("linkDate").getter(getter(LinkedWhatsAppBusinessAccountSummary::linkDate))
            .setter(setter(Builder::linkDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linkDate").build()).build();

    private static final SdkField<String> WABA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("wabaName").getter(getter(LinkedWhatsAppBusinessAccountSummary::wabaName))
            .setter(setter(Builder::wabaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wabaName").build()).build();

    private static final SdkField<List<WhatsAppBusinessAccountEventDestination>> EVENT_DESTINATIONS_FIELD = SdkField
            .<List<WhatsAppBusinessAccountEventDestination>> builder(MarshallingType.LIST)
            .memberName("eventDestinations")
            .getter(getter(LinkedWhatsAppBusinessAccountSummary::eventDestinations))
            .setter(setter(Builder::eventDestinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventDestinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WhatsAppBusinessAccountEventDestination> builder(MarshallingType.SDK_POJO)
                                            .constructor(WhatsAppBusinessAccountEventDestination::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            WABA_ID_FIELD, REGISTRATION_STATUS_FIELD, LINK_DATE_FIELD, WABA_NAME_FIELD, EVENT_DESTINATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String id;

    private final String wabaId;

    private final String registrationStatus;

    private final Instant linkDate;

    private final String wabaName;

    private final List<WhatsAppBusinessAccountEventDestination> eventDestinations;

    private LinkedWhatsAppBusinessAccountSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.wabaId = builder.wabaId;
        this.registrationStatus = builder.registrationStatus;
        this.linkDate = builder.linkDate;
        this.wabaName = builder.wabaName;
        this.eventDestinations = builder.eventDestinations;
    }

    /**
     * <p>
     * The ARN of the linked WhatsApp Business Account.
     * </p>
     * 
     * @return The ARN of the linked WhatsApp Business Account.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the linked WhatsApp Business Account, formatted as <code>waba-01234567890123456789012345678901</code>.
     * </p>
     * 
     * @return The ID of the linked WhatsApp Business Account, formatted as
     *         <code>waba-01234567890123456789012345678901</code>.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The WhatsApp Business Account ID provided by Meta.
     * </p>
     * 
     * @return The WhatsApp Business Account ID provided by Meta.
     */
    public final String wabaId() {
        return wabaId;
    }

    /**
     * <p>
     * The registration status of the linked WhatsApp Business Account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #registrationStatus} will return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #registrationStatusAsString}.
     * </p>
     * 
     * @return The registration status of the linked WhatsApp Business Account.
     * @see RegistrationStatus
     */
    public final RegistrationStatus registrationStatus() {
        return RegistrationStatus.fromValue(registrationStatus);
    }

    /**
     * <p>
     * The registration status of the linked WhatsApp Business Account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #registrationStatus} will return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #registrationStatusAsString}.
     * </p>
     * 
     * @return The registration status of the linked WhatsApp Business Account.
     * @see RegistrationStatus
     */
    public final String registrationStatusAsString() {
        return registrationStatus;
    }

    /**
     * <p>
     * The date the WhatsApp Business Account was linked.
     * </p>
     * 
     * @return The date the WhatsApp Business Account was linked.
     */
    public final Instant linkDate() {
        return linkDate;
    }

    /**
     * <p>
     * The name of the linked WhatsApp Business Account.
     * </p>
     * 
     * @return The name of the linked WhatsApp Business Account.
     */
    public final String wabaName() {
        return wabaName;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventDestinations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventDestinations() {
        return eventDestinations != null && !(eventDestinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The event destinations for the linked WhatsApp Business Account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventDestinations} method.
     * </p>
     * 
     * @return The event destinations for the linked WhatsApp Business Account.
     */
    public final List<WhatsAppBusinessAccountEventDestination> eventDestinations() {
        return eventDestinations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(wabaId());
        hashCode = 31 * hashCode + Objects.hashCode(registrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(linkDate());
        hashCode = 31 * hashCode + Objects.hashCode(wabaName());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventDestinations() ? eventDestinations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinkedWhatsAppBusinessAccountSummary)) {
            return false;
        }
        LinkedWhatsAppBusinessAccountSummary other = (LinkedWhatsAppBusinessAccountSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id()) && Objects.equals(wabaId(), other.wabaId())
                && Objects.equals(registrationStatusAsString(), other.registrationStatusAsString())
                && Objects.equals(linkDate(), other.linkDate()) && Objects.equals(wabaName(), other.wabaName())
                && hasEventDestinations() == other.hasEventDestinations()
                && Objects.equals(eventDestinations(), other.eventDestinations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LinkedWhatsAppBusinessAccountSummary").add("Arn", arn()).add("Id", id()).add("WabaId", wabaId())
                .add("RegistrationStatus", registrationStatusAsString()).add("LinkDate", linkDate()).add("WabaName", wabaName())
                .add("EventDestinations", hasEventDestinations() ? eventDestinations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "wabaId":
            return Optional.ofNullable(clazz.cast(wabaId()));
        case "registrationStatus":
            return Optional.ofNullable(clazz.cast(registrationStatusAsString()));
        case "linkDate":
            return Optional.ofNullable(clazz.cast(linkDate()));
        case "wabaName":
            return Optional.ofNullable(clazz.cast(wabaName()));
        case "eventDestinations":
            return Optional.ofNullable(clazz.cast(eventDestinations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LinkedWhatsAppBusinessAccountSummary, T> g) {
        return obj -> g.apply((LinkedWhatsAppBusinessAccountSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LinkedWhatsAppBusinessAccountSummary> {
        /**
         * <p>
         * The ARN of the linked WhatsApp Business Account.
         * </p>
         * 
         * @param arn
         *        The ARN of the linked WhatsApp Business Account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the linked WhatsApp Business Account, formatted as
         * <code>waba-01234567890123456789012345678901</code>.
         * </p>
         * 
         * @param id
         *        The ID of the linked WhatsApp Business Account, formatted as
         *        <code>waba-01234567890123456789012345678901</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The WhatsApp Business Account ID provided by Meta.
         * </p>
         * 
         * @param wabaId
         *        The WhatsApp Business Account ID provided by Meta.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wabaId(String wabaId);

        /**
         * <p>
         * The registration status of the linked WhatsApp Business Account.
         * </p>
         * 
         * @param registrationStatus
         *        The registration status of the linked WhatsApp Business Account.
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder registrationStatus(String registrationStatus);

        /**
         * <p>
         * The registration status of the linked WhatsApp Business Account.
         * </p>
         * 
         * @param registrationStatus
         *        The registration status of the linked WhatsApp Business Account.
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder registrationStatus(RegistrationStatus registrationStatus);

        /**
         * <p>
         * The date the WhatsApp Business Account was linked.
         * </p>
         * 
         * @param linkDate
         *        The date the WhatsApp Business Account was linked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkDate(Instant linkDate);

        /**
         * <p>
         * The name of the linked WhatsApp Business Account.
         * </p>
         * 
         * @param wabaName
         *        The name of the linked WhatsApp Business Account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wabaName(String wabaName);

        /**
         * <p>
         * The event destinations for the linked WhatsApp Business Account.
         * </p>
         * 
         * @param eventDestinations
         *        The event destinations for the linked WhatsApp Business Account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDestinations(Collection<WhatsAppBusinessAccountEventDestination> eventDestinations);

        /**
         * <p>
         * The event destinations for the linked WhatsApp Business Account.
         * </p>
         * 
         * @param eventDestinations
         *        The event destinations for the linked WhatsApp Business Account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDestinations(WhatsAppBusinessAccountEventDestination... eventDestinations);

        /**
         * <p>
         * The event destinations for the linked WhatsApp Business Account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.socialmessaging.model.WhatsAppBusinessAccountEventDestination.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.socialmessaging.model.WhatsAppBusinessAccountEventDestination#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.socialmessaging.model.WhatsAppBusinessAccountEventDestination.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #eventDestinations(List<WhatsAppBusinessAccountEventDestination>)}.
         * 
         * @param eventDestinations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.socialmessaging.model.WhatsAppBusinessAccountEventDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventDestinations(java.util.Collection<WhatsAppBusinessAccountEventDestination>)
         */
        Builder eventDestinations(Consumer<WhatsAppBusinessAccountEventDestination.Builder>... eventDestinations);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String wabaId;

        private String registrationStatus;

        private Instant linkDate;

        private String wabaName;

        private List<WhatsAppBusinessAccountEventDestination> eventDestinations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LinkedWhatsAppBusinessAccountSummary model) {
            arn(model.arn);
            id(model.id);
            wabaId(model.wabaId);
            registrationStatus(model.registrationStatus);
            linkDate(model.linkDate);
            wabaName(model.wabaName);
            eventDestinations(model.eventDestinations);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getWabaId() {
            return wabaId;
        }

        public final void setWabaId(String wabaId) {
            this.wabaId = wabaId;
        }

        @Override
        public final Builder wabaId(String wabaId) {
            this.wabaId = wabaId;
            return this;
        }

        public final String getRegistrationStatus() {
            return registrationStatus;
        }

        public final void setRegistrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
        }

        @Override
        public final Builder registrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
            return this;
        }

        @Override
        public final Builder registrationStatus(RegistrationStatus registrationStatus) {
            this.registrationStatus(registrationStatus == null ? null : registrationStatus.toString());
            return this;
        }

        public final Instant getLinkDate() {
            return linkDate;
        }

        public final void setLinkDate(Instant linkDate) {
            this.linkDate = linkDate;
        }

        @Override
        public final Builder linkDate(Instant linkDate) {
            this.linkDate = linkDate;
            return this;
        }

        public final String getWabaName() {
            return wabaName;
        }

        public final void setWabaName(String wabaName) {
            this.wabaName = wabaName;
        }

        @Override
        public final Builder wabaName(String wabaName) {
            this.wabaName = wabaName;
            return this;
        }

        public final List<WhatsAppBusinessAccountEventDestination.Builder> getEventDestinations() {
            List<WhatsAppBusinessAccountEventDestination.Builder> result = WhatsAppBusinessAccountEventDestinationsCopier
                    .copyToBuilder(this.eventDestinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventDestinations(Collection<WhatsAppBusinessAccountEventDestination.BuilderImpl> eventDestinations) {
            this.eventDestinations = WhatsAppBusinessAccountEventDestinationsCopier.copyFromBuilder(eventDestinations);
        }

        @Override
        public final Builder eventDestinations(Collection<WhatsAppBusinessAccountEventDestination> eventDestinations) {
            this.eventDestinations = WhatsAppBusinessAccountEventDestinationsCopier.copy(eventDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventDestinations(WhatsAppBusinessAccountEventDestination... eventDestinations) {
            eventDestinations(Arrays.asList(eventDestinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventDestinations(Consumer<WhatsAppBusinessAccountEventDestination.Builder>... eventDestinations) {
            eventDestinations(Stream.of(eventDestinations)
                    .map(c -> WhatsAppBusinessAccountEventDestination.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public LinkedWhatsAppBusinessAccountSummary build() {
            return new LinkedWhatsAppBusinessAccountSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
