/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PostWhatsAppMessageMediaResponse extends SocialMessagingResponse implements
        ToCopyableBuilder<PostWhatsAppMessageMediaResponse.Builder, PostWhatsAppMessageMediaResponse> {
    private static final SdkField<String> MEDIA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mediaId").getter(getter(PostWhatsAppMessageMediaResponse::mediaId)).setter(setter(Builder::mediaId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_ID_FIELD));

    private final String mediaId;

    private PostWhatsAppMessageMediaResponse(BuilderImpl builder) {
        super(builder);
        this.mediaId = builder.mediaId;
    }

    /**
     * <p>
     * The unique identifier of the posted WhatsApp message.
     * </p>
     * 
     * @return The unique identifier of the posted WhatsApp message.
     */
    public final String mediaId() {
        return mediaId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mediaId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostWhatsAppMessageMediaResponse)) {
            return false;
        }
        PostWhatsAppMessageMediaResponse other = (PostWhatsAppMessageMediaResponse) obj;
        return Objects.equals(mediaId(), other.mediaId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PostWhatsAppMessageMediaResponse").add("MediaId", mediaId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mediaId":
            return Optional.ofNullable(clazz.cast(mediaId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PostWhatsAppMessageMediaResponse, T> g) {
        return obj -> g.apply((PostWhatsAppMessageMediaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SocialMessagingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PostWhatsAppMessageMediaResponse> {
        /**
         * <p>
         * The unique identifier of the posted WhatsApp message.
         * </p>
         * 
         * @param mediaId
         *        The unique identifier of the posted WhatsApp message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaId(String mediaId);
    }

    static final class BuilderImpl extends SocialMessagingResponse.BuilderImpl implements Builder {
        private String mediaId;

        private BuilderImpl() {
        }

        private BuilderImpl(PostWhatsAppMessageMediaResponse model) {
            super(model);
            mediaId(model.mediaId);
        }

        public final String getMediaId() {
            return mediaId;
        }

        public final void setMediaId(String mediaId) {
            this.mediaId = mediaId;
        }

        @Override
        public final Builder mediaId(String mediaId) {
            this.mediaId = mediaId;
            return this;
        }

        @Override
        public PostWhatsAppMessageMediaResponse build() {
            return new PostWhatsAppMessageMediaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
