/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendWhatsAppMessageRequest extends SocialMessagingRequest implements
        ToCopyableBuilder<SendWhatsAppMessageRequest.Builder, SendWhatsAppMessageRequest> {
    private static final SdkField<String> ORIGINATION_PHONE_NUMBER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("originationPhoneNumberId").getter(getter(SendWhatsAppMessageRequest::originationPhoneNumberId))
            .setter(setter(Builder::originationPhoneNumberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originationPhoneNumberId").build())
            .build();

    private static final SdkField<SdkBytes> MESSAGE_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("message").getter(getter(SendWhatsAppMessageRequest::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<String> META_API_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metaApiVersion").getter(getter(SendWhatsAppMessageRequest::metaApiVersion))
            .setter(setter(Builder::metaApiVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metaApiVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORIGINATION_PHONE_NUMBER_ID_FIELD, MESSAGE_FIELD, META_API_VERSION_FIELD));

    private final String originationPhoneNumberId;

    private final SdkBytes message;

    private final String metaApiVersion;

    private SendWhatsAppMessageRequest(BuilderImpl builder) {
        super(builder);
        this.originationPhoneNumberId = builder.originationPhoneNumberId;
        this.message = builder.message;
        this.metaApiVersion = builder.metaApiVersion;
    }

    /**
     * <p>
     * The ID of the phone number used to send the WhatsApp message. If you are sending a media file only the
     * <code>originationPhoneNumberId</code> used to upload the file can be used. Phone number identifiers are formatted
     * as <code>phone-number-id-01234567890123456789012345678901</code>. Use <a href=
     * "https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetLinkedWhatsAppBusinessAccountPhoneNumber.html"
     * >GetLinkedWhatsAppBusinessAccount</a> to find a phone number's id.
     * </p>
     * 
     * @return The ID of the phone number used to send the WhatsApp message. If you are sending a media file only the
     *         <code>originationPhoneNumberId</code> used to upload the file can be used. Phone number identifiers are
     *         formatted as <code>phone-number-id-01234567890123456789012345678901</code>. Use <a href=
     *         "https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetLinkedWhatsAppBusinessAccountPhoneNumber.html"
     *         >GetLinkedWhatsAppBusinessAccount</a> to find a phone number's id.
     */
    public final String originationPhoneNumberId() {
        return originationPhoneNumberId;
    }

    /**
     * <p>
     * The message to send through WhatsApp. The length is in KB. The message field passes through a WhatsApp Message
     * object, see <a href="https://developers.facebook.com/docs/whatsapp/cloud-api/reference/messages">Messages</a> in
     * the <i>WhatsApp Business Platform Cloud API Reference</i>.
     * </p>
     * 
     * @return The message to send through WhatsApp. The length is in KB. The message field passes through a WhatsApp
     *         Message object, see <a
     *         href="https://developers.facebook.com/docs/whatsapp/cloud-api/reference/messages">Messages</a> in the
     *         <i>WhatsApp Business Platform Cloud API Reference</i>.
     */
    public final SdkBytes message() {
        return message;
    }

    /**
     * <p>
     * The API version for the request formatted as <code>v{VersionNumber}</code>. For a list of supported API versions
     * and Amazon Web Services Regions, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/end-user-messaging.html"> <i>Amazon Web Services End User
     * Messaging Social API</i> Service Endpoints</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return The API version for the request formatted as <code>v{VersionNumber}</code>. For a list of supported API
     *         versions and Amazon Web Services Regions, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/end-user-messaging.html"> <i>Amazon Web Services End
     *         User Messaging Social API</i> Service Endpoints</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final String metaApiVersion() {
        return metaApiVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(originationPhoneNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(metaApiVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendWhatsAppMessageRequest)) {
            return false;
        }
        SendWhatsAppMessageRequest other = (SendWhatsAppMessageRequest) obj;
        return Objects.equals(originationPhoneNumberId(), other.originationPhoneNumberId())
                && Objects.equals(message(), other.message()) && Objects.equals(metaApiVersion(), other.metaApiVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendWhatsAppMessageRequest").add("OriginationPhoneNumberId", originationPhoneNumberId())
                .add("Message", message() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MetaApiVersion", metaApiVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "originationPhoneNumberId":
            return Optional.ofNullable(clazz.cast(originationPhoneNumberId()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "metaApiVersion":
            return Optional.ofNullable(clazz.cast(metaApiVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendWhatsAppMessageRequest, T> g) {
        return obj -> g.apply((SendWhatsAppMessageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SocialMessagingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SendWhatsAppMessageRequest> {
        /**
         * <p>
         * The ID of the phone number used to send the WhatsApp message. If you are sending a media file only the
         * <code>originationPhoneNumberId</code> used to upload the file can be used. Phone number identifiers are
         * formatted as <code>phone-number-id-01234567890123456789012345678901</code>. Use <a href=
         * "https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetLinkedWhatsAppBusinessAccountPhoneNumber.html"
         * >GetLinkedWhatsAppBusinessAccount</a> to find a phone number's id.
         * </p>
         * 
         * @param originationPhoneNumberId
         *        The ID of the phone number used to send the WhatsApp message. If you are sending a media file only the
         *        <code>originationPhoneNumberId</code> used to upload the file can be used. Phone number identifiers
         *        are formatted as <code>phone-number-id-01234567890123456789012345678901</code>. Use <a href=
         *        "https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetLinkedWhatsAppBusinessAccountPhoneNumber.html"
         *        >GetLinkedWhatsAppBusinessAccount</a> to find a phone number's id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originationPhoneNumberId(String originationPhoneNumberId);

        /**
         * <p>
         * The message to send through WhatsApp. The length is in KB. The message field passes through a WhatsApp
         * Message object, see <a
         * href="https://developers.facebook.com/docs/whatsapp/cloud-api/reference/messages">Messages</a> in the
         * <i>WhatsApp Business Platform Cloud API Reference</i>.
         * </p>
         * 
         * @param message
         *        The message to send through WhatsApp. The length is in KB. The message field passes through a WhatsApp
         *        Message object, see <a
         *        href="https://developers.facebook.com/docs/whatsapp/cloud-api/reference/messages">Messages</a> in the
         *        <i>WhatsApp Business Platform Cloud API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(SdkBytes message);

        /**
         * <p>
         * The API version for the request formatted as <code>v{VersionNumber}</code>. For a list of supported API
         * versions and Amazon Web Services Regions, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/end-user-messaging.html"> <i>Amazon Web Services End User
         * Messaging Social API</i> Service Endpoints</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param metaApiVersion
         *        The API version for the request formatted as <code>v{VersionNumber}</code>. For a list of supported
         *        API versions and Amazon Web Services Regions, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/end-user-messaging.html"> <i>Amazon Web Services
         *        End User Messaging Social API</i> Service Endpoints</a> in the <i>Amazon Web Services General
         *        Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metaApiVersion(String metaApiVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SocialMessagingRequest.BuilderImpl implements Builder {
        private String originationPhoneNumberId;

        private SdkBytes message;

        private String metaApiVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(SendWhatsAppMessageRequest model) {
            super(model);
            originationPhoneNumberId(model.originationPhoneNumberId);
            message(model.message);
            metaApiVersion(model.metaApiVersion);
        }

        public final String getOriginationPhoneNumberId() {
            return originationPhoneNumberId;
        }

        public final void setOriginationPhoneNumberId(String originationPhoneNumberId) {
            this.originationPhoneNumberId = originationPhoneNumberId;
        }

        @Override
        public final Builder originationPhoneNumberId(String originationPhoneNumberId) {
            this.originationPhoneNumberId = originationPhoneNumberId;
            return this;
        }

        public final ByteBuffer getMessage() {
            return message == null ? null : message.asByteBuffer();
        }

        public final void setMessage(ByteBuffer message) {
            message(message == null ? null : SdkBytes.fromByteBuffer(message));
        }

        @Override
        public final Builder message(SdkBytes message) {
            this.message = message;
            return this;
        }

        public final String getMetaApiVersion() {
            return metaApiVersion;
        }

        public final void setMetaApiVersion(String metaApiVersion) {
            this.metaApiVersion = metaApiVersion;
        }

        @Override
        public final Builder metaApiVersion(String metaApiVersion) {
            this.metaApiVersion = metaApiVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendWhatsAppMessageRequest build() {
            return new SendWhatsAppMessageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
