/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information on the event destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WhatsAppBusinessAccountEventDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<WhatsAppBusinessAccountEventDestination.Builder, WhatsAppBusinessAccountEventDestination> {
    private static final SdkField<String> EVENT_DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventDestinationArn").getter(getter(WhatsAppBusinessAccountEventDestination::eventDestinationArn))
            .setter(setter(Builder::eventDestinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventDestinationArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DESTINATION_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String eventDestinationArn;

    private WhatsAppBusinessAccountEventDestination(BuilderImpl builder) {
        this.eventDestinationArn = builder.eventDestinationArn;
    }

    /**
     * <p>
     * The ARN of the event destination.
     * </p>
     * 
     * @return The ARN of the event destination.
     */
    public final String eventDestinationArn() {
        return eventDestinationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventDestinationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WhatsAppBusinessAccountEventDestination)) {
            return false;
        }
        WhatsAppBusinessAccountEventDestination other = (WhatsAppBusinessAccountEventDestination) obj;
        return Objects.equals(eventDestinationArn(), other.eventDestinationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WhatsAppBusinessAccountEventDestination").add("EventDestinationArn", eventDestinationArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventDestinationArn":
            return Optional.ofNullable(clazz.cast(eventDestinationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WhatsAppBusinessAccountEventDestination, T> g) {
        return obj -> g.apply((WhatsAppBusinessAccountEventDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WhatsAppBusinessAccountEventDestination> {
        /**
         * <p>
         * The ARN of the event destination.
         * </p>
         * 
         * @param eventDestinationArn
         *        The ARN of the event destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDestinationArn(String eventDestinationArn);
    }

    static final class BuilderImpl implements Builder {
        private String eventDestinationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(WhatsAppBusinessAccountEventDestination model) {
            eventDestinationArn(model.eventDestinationArn);
        }

        public final String getEventDestinationArn() {
            return eventDestinationArn;
        }

        public final void setEventDestinationArn(String eventDestinationArn) {
            this.eventDestinationArn = eventDestinationArn;
        }

        @Override
        public final Builder eventDestinationArn(String eventDestinationArn) {
            this.eventDestinationArn = eventDestinationArn;
            return this;
        }

        @Override
        public WhatsAppBusinessAccountEventDestination build() {
            return new WhatsAppBusinessAccountEventDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
