/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class WhatsAppPhoneNumberSummaryListCopier {
    static List<WhatsAppPhoneNumberSummary> copy(
            Collection<? extends WhatsAppPhoneNumberSummary> whatsAppPhoneNumberSummaryListParam) {
        List<WhatsAppPhoneNumberSummary> list;
        if (whatsAppPhoneNumberSummaryListParam == null || whatsAppPhoneNumberSummaryListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<WhatsAppPhoneNumberSummary> modifiableList = new ArrayList<>(whatsAppPhoneNumberSummaryListParam.size());
            whatsAppPhoneNumberSummaryListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<WhatsAppPhoneNumberSummary> copyFromBuilder(
            Collection<? extends WhatsAppPhoneNumberSummary.Builder> whatsAppPhoneNumberSummaryListParam) {
        List<WhatsAppPhoneNumberSummary> list;
        if (whatsAppPhoneNumberSummaryListParam == null || whatsAppPhoneNumberSummaryListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<WhatsAppPhoneNumberSummary> modifiableList = new ArrayList<>(whatsAppPhoneNumberSummaryListParam.size());
            whatsAppPhoneNumberSummaryListParam.forEach(entry -> {
                WhatsAppPhoneNumberSummary member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<WhatsAppPhoneNumberSummary.Builder> copyToBuilder(
            Collection<? extends WhatsAppPhoneNumberSummary> whatsAppPhoneNumberSummaryListParam) {
        List<WhatsAppPhoneNumberSummary.Builder> list;
        if (whatsAppPhoneNumberSummaryListParam == null || whatsAppPhoneNumberSummaryListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<WhatsAppPhoneNumberSummary.Builder> modifiableList = new ArrayList<>(whatsAppPhoneNumberSummaryListParam.size());
            whatsAppPhoneNumberSummaryListParam.forEach(entry -> {
                WhatsAppPhoneNumberSummary.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
