/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.socialmessaging.model.AssociateWhatsAppBusinessAccountRequest;
import software.amazon.awssdk.services.socialmessaging.model.AssociateWhatsAppBusinessAccountResponse;
import software.amazon.awssdk.services.socialmessaging.model.DeleteWhatsAppMessageMediaRequest;
import software.amazon.awssdk.services.socialmessaging.model.DeleteWhatsAppMessageMediaResponse;
import software.amazon.awssdk.services.socialmessaging.model.DisassociateWhatsAppBusinessAccountRequest;
import software.amazon.awssdk.services.socialmessaging.model.DisassociateWhatsAppBusinessAccountResponse;
import software.amazon.awssdk.services.socialmessaging.model.GetLinkedWhatsAppBusinessAccountPhoneNumberRequest;
import software.amazon.awssdk.services.socialmessaging.model.GetLinkedWhatsAppBusinessAccountPhoneNumberResponse;
import software.amazon.awssdk.services.socialmessaging.model.GetLinkedWhatsAppBusinessAccountRequest;
import software.amazon.awssdk.services.socialmessaging.model.GetLinkedWhatsAppBusinessAccountResponse;
import software.amazon.awssdk.services.socialmessaging.model.GetWhatsAppMessageMediaRequest;
import software.amazon.awssdk.services.socialmessaging.model.GetWhatsAppMessageMediaResponse;
import software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsRequest;
import software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsResponse;
import software.amazon.awssdk.services.socialmessaging.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.socialmessaging.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.socialmessaging.model.PostWhatsAppMessageMediaRequest;
import software.amazon.awssdk.services.socialmessaging.model.PostWhatsAppMessageMediaResponse;
import software.amazon.awssdk.services.socialmessaging.model.PutWhatsAppBusinessAccountEventDestinationsRequest;
import software.amazon.awssdk.services.socialmessaging.model.PutWhatsAppBusinessAccountEventDestinationsResponse;
import software.amazon.awssdk.services.socialmessaging.model.SendWhatsAppMessageRequest;
import software.amazon.awssdk.services.socialmessaging.model.SendWhatsAppMessageResponse;
import software.amazon.awssdk.services.socialmessaging.model.TagResourceRequest;
import software.amazon.awssdk.services.socialmessaging.model.TagResourceResponse;
import software.amazon.awssdk.services.socialmessaging.model.UntagResourceRequest;
import software.amazon.awssdk.services.socialmessaging.model.UntagResourceResponse;
import software.amazon.awssdk.services.socialmessaging.paginators.ListLinkedWhatsAppBusinessAccountsPublisher;

/**
 * Service client for accessing AWS End User Messaging Social asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * <i>Amazon Web Services End User Messaging Social</i>, also referred to as Social messaging, is a messaging service
 * that enables application developers to incorporate WhatsApp into their existing workflows. The <i>Amazon Web Services
 * End User Messaging Social API</i> provides information about the <i>Amazon Web Services End User Messaging Social
 * API</i> resources, including supported HTTP methods, parameters, and schemas.
 * </p>
 * <p>
 * The <i>Amazon Web Services End User Messaging Social API</i> provides programmatic access to options that are unique
 * to the WhatsApp Business Platform.
 * </p>
 * <p>
 * If you're new to the <i>Amazon Web Services End User Messaging Social API</i>, it's also helpful to review <a
 * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/what-is-service.html">What is Amazon Web Services End
 * User Messaging Social</a> in the <i>Amazon Web Services End User Messaging Social User Guide</i>. The <i>Amazon Web
 * Services End User Messaging Social User Guide</i> provides tutorials, code samples, and procedures that demonstrate
 * how to use <i>Amazon Web Services End User Messaging Social API</i> features programmatically and how to integrate
 * functionality into applications. The guide also provides key information, such as integration with other Amazon Web
 * Services services, and the quotas that apply to use of the service.
 * </p>
 * <p>
 * <b>Regional availability</b>
 * </p>
 * <p>
 * The <i>Amazon Web Services End User Messaging Social API</i> is available across several Amazon Web Services Regions
 * and it provides a dedicated endpoint for each of these Regions. For a list of all the Regions and endpoints where the
 * API is currently available, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/rande.html#pinpoint_region">Amazon Web Services Service
 * Endpoints</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/end-user-messaging.html">Amazon Web Services
 * End User Messaging endpoints and quotas</a> in the Amazon Web Services General Reference. To learn more about Amazon
 * Web Services Regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html">Managing Amazon
 * Web Services Regions</a> in the Amazon Web Services General Reference.
 * </p>
 * <p>
 * In each Region, Amazon Web Services maintains multiple Availability Zones. These Availability Zones are physically
 * isolated from each other, but are united by private, low-latency, high-throughput, and highly redundant network
 * connections. These Availability Zones enable us to provide very high levels of availability and redundancy, while
 * also minimizing latency. To learn more about the number of Availability Zones that are available in each Region, see
 * <a href="https://aws.amazon.com/about-aws/global-infrastructure/">Amazon Web Services Global Infrastructure.</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SocialMessagingAsyncClient extends AwsClient {
    String SERVICE_NAME = "social-messaging";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "social-messaging";

    /**
     * <p>
     * This is only used through the Amazon Web Services console during sign-up to associate your WhatsApp Business
     * Account to your Amazon Web Services account.
     * </p>
     *
     * @param associateWhatsAppBusinessAccountRequest
     * @return A Java Future containing the result of the AssociateWhatsAppBusinessAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>DependencyException Thrown when performing an action because a dependency would be broken.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.AssociateWhatsAppBusinessAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/AssociateWhatsAppBusinessAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateWhatsAppBusinessAccountResponse> associateWhatsAppBusinessAccount(
            AssociateWhatsAppBusinessAccountRequest associateWhatsAppBusinessAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is only used through the Amazon Web Services console during sign-up to associate your WhatsApp Business
     * Account to your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateWhatsAppBusinessAccountRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateWhatsAppBusinessAccountRequest#builder()}
     * </p>
     *
     * @param associateWhatsAppBusinessAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.AssociateWhatsAppBusinessAccountRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AssociateWhatsAppBusinessAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>DependencyException Thrown when performing an action because a dependency would be broken.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.AssociateWhatsAppBusinessAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/AssociateWhatsAppBusinessAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateWhatsAppBusinessAccountResponse> associateWhatsAppBusinessAccount(
            Consumer<AssociateWhatsAppBusinessAccountRequest.Builder> associateWhatsAppBusinessAccountRequest) {
        return associateWhatsAppBusinessAccount(AssociateWhatsAppBusinessAccountRequest.builder()
                .applyMutation(associateWhatsAppBusinessAccountRequest).build());
    }

    /**
     * <p>
     * Delete a media object from the WhatsApp service. If the object is still in an Amazon S3 bucket you should delete
     * it from there too.
     * </p>
     *
     * @param deleteWhatsAppMessageMediaRequest
     * @return A Java Future containing the result of the DeleteWhatsAppMessageMedia operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedByMetaException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServiceException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>DependencyException Thrown when performing an action because a dependency would be broken.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.DeleteWhatsAppMessageMedia
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/DeleteWhatsAppMessageMedia"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWhatsAppMessageMediaResponse> deleteWhatsAppMessageMedia(
            DeleteWhatsAppMessageMediaRequest deleteWhatsAppMessageMediaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a media object from the WhatsApp service. If the object is still in an Amazon S3 bucket you should delete
     * it from there too.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWhatsAppMessageMediaRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteWhatsAppMessageMediaRequest#builder()}
     * </p>
     *
     * @param deleteWhatsAppMessageMediaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.DeleteWhatsAppMessageMediaRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteWhatsAppMessageMedia operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedByMetaException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServiceException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>DependencyException Thrown when performing an action because a dependency would be broken.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.DeleteWhatsAppMessageMedia
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/DeleteWhatsAppMessageMedia"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWhatsAppMessageMediaResponse> deleteWhatsAppMessageMedia(
            Consumer<DeleteWhatsAppMessageMediaRequest.Builder> deleteWhatsAppMessageMediaRequest) {
        return deleteWhatsAppMessageMedia(DeleteWhatsAppMessageMediaRequest.builder()
                .applyMutation(deleteWhatsAppMessageMediaRequest).build());
    }

    /**
     * <p>
     * Disassociate a WhatsApp Business Account (WABA) from your Amazon Web Services account.
     * </p>
     *
     * @param disassociateWhatsAppBusinessAccountRequest
     * @return A Java Future containing the result of the DisassociateWhatsAppBusinessAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>DependencyException Thrown when performing an action because a dependency would be broken.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.DisassociateWhatsAppBusinessAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/DisassociateWhatsAppBusinessAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateWhatsAppBusinessAccountResponse> disassociateWhatsAppBusinessAccount(
            DisassociateWhatsAppBusinessAccountRequest disassociateWhatsAppBusinessAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociate a WhatsApp Business Account (WABA) from your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateWhatsAppBusinessAccountRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateWhatsAppBusinessAccountRequest#builder()}
     * </p>
     *
     * @param disassociateWhatsAppBusinessAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.DisassociateWhatsAppBusinessAccountRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateWhatsAppBusinessAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>DependencyException Thrown when performing an action because a dependency would be broken.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.DisassociateWhatsAppBusinessAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/DisassociateWhatsAppBusinessAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateWhatsAppBusinessAccountResponse> disassociateWhatsAppBusinessAccount(
            Consumer<DisassociateWhatsAppBusinessAccountRequest.Builder> disassociateWhatsAppBusinessAccountRequest) {
        return disassociateWhatsAppBusinessAccount(DisassociateWhatsAppBusinessAccountRequest.builder()
                .applyMutation(disassociateWhatsAppBusinessAccountRequest).build());
    }

    /**
     * <p>
     * Get the details of your linked WhatsApp Business Account.
     * </p>
     *
     * @param getLinkedWhatsAppBusinessAccountRequest
     * @return A Java Future containing the result of the GetLinkedWhatsAppBusinessAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>InternalServiceException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>DependencyException Thrown when performing an action because a dependency would be broken.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.GetLinkedWhatsAppBusinessAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/GetLinkedWhatsAppBusinessAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLinkedWhatsAppBusinessAccountResponse> getLinkedWhatsAppBusinessAccount(
            GetLinkedWhatsAppBusinessAccountRequest getLinkedWhatsAppBusinessAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the details of your linked WhatsApp Business Account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLinkedWhatsAppBusinessAccountRequest.Builder}
     * avoiding the need to create one manually via {@link GetLinkedWhatsAppBusinessAccountRequest#builder()}
     * </p>
     *
     * @param getLinkedWhatsAppBusinessAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.GetLinkedWhatsAppBusinessAccountRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetLinkedWhatsAppBusinessAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>InternalServiceException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>DependencyException Thrown when performing an action because a dependency would be broken.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.GetLinkedWhatsAppBusinessAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/GetLinkedWhatsAppBusinessAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLinkedWhatsAppBusinessAccountResponse> getLinkedWhatsAppBusinessAccount(
            Consumer<GetLinkedWhatsAppBusinessAccountRequest.Builder> getLinkedWhatsAppBusinessAccountRequest) {
        return getLinkedWhatsAppBusinessAccount(GetLinkedWhatsAppBusinessAccountRequest.builder()
                .applyMutation(getLinkedWhatsAppBusinessAccountRequest).build());
    }

    /**
     * <p>
     * Use your WhatsApp phone number id to get the WABA account id and phone number details.
     * </p>
     *
     * @param getLinkedWhatsAppBusinessAccountPhoneNumberRequest
     * @return A Java Future containing the result of the GetLinkedWhatsAppBusinessAccountPhoneNumber operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>InternalServiceException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>DependencyException Thrown when performing an action because a dependency would be broken.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.GetLinkedWhatsAppBusinessAccountPhoneNumber
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/GetLinkedWhatsAppBusinessAccountPhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLinkedWhatsAppBusinessAccountPhoneNumberResponse> getLinkedWhatsAppBusinessAccountPhoneNumber(
            GetLinkedWhatsAppBusinessAccountPhoneNumberRequest getLinkedWhatsAppBusinessAccountPhoneNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use your WhatsApp phone number id to get the WABA account id and phone number details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetLinkedWhatsAppBusinessAccountPhoneNumberRequest.Builder} avoiding the need to create one manually via
     * {@link GetLinkedWhatsAppBusinessAccountPhoneNumberRequest#builder()}
     * </p>
     *
     * @param getLinkedWhatsAppBusinessAccountPhoneNumberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.GetLinkedWhatsAppBusinessAccountPhoneNumberRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetLinkedWhatsAppBusinessAccountPhoneNumber operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>InternalServiceException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>DependencyException Thrown when performing an action because a dependency would be broken.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.GetLinkedWhatsAppBusinessAccountPhoneNumber
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/GetLinkedWhatsAppBusinessAccountPhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLinkedWhatsAppBusinessAccountPhoneNumberResponse> getLinkedWhatsAppBusinessAccountPhoneNumber(
            Consumer<GetLinkedWhatsAppBusinessAccountPhoneNumberRequest.Builder> getLinkedWhatsAppBusinessAccountPhoneNumberRequest) {
        return getLinkedWhatsAppBusinessAccountPhoneNumber(GetLinkedWhatsAppBusinessAccountPhoneNumberRequest.builder()
                .applyMutation(getLinkedWhatsAppBusinessAccountPhoneNumberRequest).build());
    }

    /**
     * <p>
     * Get a media file from the WhatsApp service. On successful completion the media file is retrieved from Meta and
     * stored in the specified Amazon S3 bucket. Use either <code>destinationS3File</code> or
     * <code>destinationS3PresignedUrl</code> for the destination. If both are used then an
     * <code>InvalidParameterException</code> is returned.
     * </p>
     *
     * @param getWhatsAppMessageMediaRequest
     * @return A Java Future containing the result of the GetWhatsAppMessageMedia operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedByMetaException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServiceException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>DependencyException Thrown when performing an action because a dependency would be broken.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.GetWhatsAppMessageMedia
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/GetWhatsAppMessageMedia"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWhatsAppMessageMediaResponse> getWhatsAppMessageMedia(
            GetWhatsAppMessageMediaRequest getWhatsAppMessageMediaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a media file from the WhatsApp service. On successful completion the media file is retrieved from Meta and
     * stored in the specified Amazon S3 bucket. Use either <code>destinationS3File</code> or
     * <code>destinationS3PresignedUrl</code> for the destination. If both are used then an
     * <code>InvalidParameterException</code> is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWhatsAppMessageMediaRequest.Builder} avoiding
     * the need to create one manually via {@link GetWhatsAppMessageMediaRequest#builder()}
     * </p>
     *
     * @param getWhatsAppMessageMediaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.GetWhatsAppMessageMediaRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetWhatsAppMessageMedia operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedByMetaException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServiceException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>DependencyException Thrown when performing an action because a dependency would be broken.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.GetWhatsAppMessageMedia
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/GetWhatsAppMessageMedia"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWhatsAppMessageMediaResponse> getWhatsAppMessageMedia(
            Consumer<GetWhatsAppMessageMediaRequest.Builder> getWhatsAppMessageMediaRequest) {
        return getWhatsAppMessageMedia(GetWhatsAppMessageMediaRequest.builder().applyMutation(getWhatsAppMessageMediaRequest)
                .build());
    }

    /**
     * <p>
     * List all WhatsApp Business Accounts linked to your Amazon Web Services account.
     * </p>
     *
     * @param listLinkedWhatsAppBusinessAccountsRequest
     * @return A Java Future containing the result of the ListLinkedWhatsAppBusinessAccounts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>InternalServiceException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.ListLinkedWhatsAppBusinessAccounts
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/ListLinkedWhatsAppBusinessAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLinkedWhatsAppBusinessAccountsResponse> listLinkedWhatsAppBusinessAccounts(
            ListLinkedWhatsAppBusinessAccountsRequest listLinkedWhatsAppBusinessAccountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all WhatsApp Business Accounts linked to your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLinkedWhatsAppBusinessAccountsRequest.Builder}
     * avoiding the need to create one manually via {@link ListLinkedWhatsAppBusinessAccountsRequest#builder()}
     * </p>
     *
     * @param listLinkedWhatsAppBusinessAccountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListLinkedWhatsAppBusinessAccounts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>InternalServiceException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.ListLinkedWhatsAppBusinessAccounts
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/ListLinkedWhatsAppBusinessAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLinkedWhatsAppBusinessAccountsResponse> listLinkedWhatsAppBusinessAccounts(
            Consumer<ListLinkedWhatsAppBusinessAccountsRequest.Builder> listLinkedWhatsAppBusinessAccountsRequest) {
        return listLinkedWhatsAppBusinessAccounts(ListLinkedWhatsAppBusinessAccountsRequest.builder()
                .applyMutation(listLinkedWhatsAppBusinessAccountsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLinkedWhatsAppBusinessAccounts(software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.socialmessaging.paginators.ListLinkedWhatsAppBusinessAccountsPublisher publisher = client.listLinkedWhatsAppBusinessAccountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.socialmessaging.paginators.ListLinkedWhatsAppBusinessAccountsPublisher publisher = client.listLinkedWhatsAppBusinessAccountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLinkedWhatsAppBusinessAccounts(software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLinkedWhatsAppBusinessAccountsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>InternalServiceException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.ListLinkedWhatsAppBusinessAccounts
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/ListLinkedWhatsAppBusinessAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLinkedWhatsAppBusinessAccountsPublisher listLinkedWhatsAppBusinessAccountsPaginator(
            ListLinkedWhatsAppBusinessAccountsRequest listLinkedWhatsAppBusinessAccountsRequest) {
        return new ListLinkedWhatsAppBusinessAccountsPublisher(this, listLinkedWhatsAppBusinessAccountsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLinkedWhatsAppBusinessAccounts(software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.socialmessaging.paginators.ListLinkedWhatsAppBusinessAccountsPublisher publisher = client.listLinkedWhatsAppBusinessAccountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.socialmessaging.paginators.ListLinkedWhatsAppBusinessAccountsPublisher publisher = client.listLinkedWhatsAppBusinessAccountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLinkedWhatsAppBusinessAccounts(software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLinkedWhatsAppBusinessAccountsRequest.Builder}
     * avoiding the need to create one manually via {@link ListLinkedWhatsAppBusinessAccountsRequest#builder()}
     * </p>
     *
     * @param listLinkedWhatsAppBusinessAccountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>InternalServiceException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.ListLinkedWhatsAppBusinessAccounts
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/ListLinkedWhatsAppBusinessAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLinkedWhatsAppBusinessAccountsPublisher listLinkedWhatsAppBusinessAccountsPaginator(
            Consumer<ListLinkedWhatsAppBusinessAccountsRequest.Builder> listLinkedWhatsAppBusinessAccountsRequest) {
        return listLinkedWhatsAppBusinessAccountsPaginator(ListLinkedWhatsAppBusinessAccountsRequest.builder()
                .applyMutation(listLinkedWhatsAppBusinessAccountsRequest).build());
    }

    /**
     * <p>
     * List all tags associated with a resource, such as a phone number or WABA.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>InternalServiceException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all tags associated with a resource, such as a phone number or WABA.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.ListTagsForResourceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>InternalServiceException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Upload a media file to the WhatsApp service. Only the specified <code>originationPhoneNumberId</code> has the
     * permissions to send the media file when using <a
     * href="https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_SendWhatsAppMessage.html"
     * >SendWhatsAppMessage</a>. You must use either <code>sourceS3File</code> or <code>sourceS3PresignedUrl</code> for
     * the source. If both or neither are specified then an <code>InvalidParameterException</code> is returned.
     * </p>
     *
     * @param postWhatsAppMessageMediaRequest
     * @return A Java Future containing the result of the PostWhatsAppMessageMedia operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedByMetaException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServiceException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>DependencyException Thrown when performing an action because a dependency would be broken.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.PostWhatsAppMessageMedia
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/PostWhatsAppMessageMedia"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PostWhatsAppMessageMediaResponse> postWhatsAppMessageMedia(
            PostWhatsAppMessageMediaRequest postWhatsAppMessageMediaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Upload a media file to the WhatsApp service. Only the specified <code>originationPhoneNumberId</code> has the
     * permissions to send the media file when using <a
     * href="https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_SendWhatsAppMessage.html"
     * >SendWhatsAppMessage</a>. You must use either <code>sourceS3File</code> or <code>sourceS3PresignedUrl</code> for
     * the source. If both or neither are specified then an <code>InvalidParameterException</code> is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PostWhatsAppMessageMediaRequest.Builder} avoiding
     * the need to create one manually via {@link PostWhatsAppMessageMediaRequest#builder()}
     * </p>
     *
     * @param postWhatsAppMessageMediaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.PostWhatsAppMessageMediaRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PostWhatsAppMessageMedia operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedByMetaException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServiceException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>DependencyException Thrown when performing an action because a dependency would be broken.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.PostWhatsAppMessageMedia
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/PostWhatsAppMessageMedia"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PostWhatsAppMessageMediaResponse> postWhatsAppMessageMedia(
            Consumer<PostWhatsAppMessageMediaRequest.Builder> postWhatsAppMessageMediaRequest) {
        return postWhatsAppMessageMedia(PostWhatsAppMessageMediaRequest.builder().applyMutation(postWhatsAppMessageMediaRequest)
                .build());
    }

    /**
     * <p>
     * Add an event destination to log event data from WhatsApp for a WhatsApp Business Account (WABA). A WABA can only
     * have one event destination at a time. All resources associated with the WABA use the same event destination.
     * </p>
     *
     * @param putWhatsAppBusinessAccountEventDestinationsRequest
     * @return A Java Future containing the result of the PutWhatsAppBusinessAccountEventDestinations operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>InternalServiceException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.PutWhatsAppBusinessAccountEventDestinations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/PutWhatsAppBusinessAccountEventDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutWhatsAppBusinessAccountEventDestinationsResponse> putWhatsAppBusinessAccountEventDestinations(
            PutWhatsAppBusinessAccountEventDestinationsRequest putWhatsAppBusinessAccountEventDestinationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add an event destination to log event data from WhatsApp for a WhatsApp Business Account (WABA). A WABA can only
     * have one event destination at a time. All resources associated with the WABA use the same event destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutWhatsAppBusinessAccountEventDestinationsRequest.Builder} avoiding the need to create one manually via
     * {@link PutWhatsAppBusinessAccountEventDestinationsRequest#builder()}
     * </p>
     *
     * @param putWhatsAppBusinessAccountEventDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.PutWhatsAppBusinessAccountEventDestinationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the PutWhatsAppBusinessAccountEventDestinations operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>InternalServiceException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.PutWhatsAppBusinessAccountEventDestinations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/PutWhatsAppBusinessAccountEventDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutWhatsAppBusinessAccountEventDestinationsResponse> putWhatsAppBusinessAccountEventDestinations(
            Consumer<PutWhatsAppBusinessAccountEventDestinationsRequest.Builder> putWhatsAppBusinessAccountEventDestinationsRequest) {
        return putWhatsAppBusinessAccountEventDestinations(PutWhatsAppBusinessAccountEventDestinationsRequest.builder()
                .applyMutation(putWhatsAppBusinessAccountEventDestinationsRequest).build());
    }

    /**
     * <p>
     * Send a WhatsApp message. For examples of sending a message using the Amazon Web Services CLI, see <a
     * href="https://docs.aws.amazon.com/social-messaging/latest/userguide/send-message.html">Sending messages</a> in
     * the <i> <i>Amazon Web Services End User Messaging Social User Guide</i> </i>.
     * </p>
     *
     * @param sendWhatsAppMessageRequest
     * @return A Java Future containing the result of the SendWhatsAppMessage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>InternalServiceException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>DependencyException Thrown when performing an action because a dependency would be broken.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.SendWhatsAppMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/SendWhatsAppMessage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendWhatsAppMessageResponse> sendWhatsAppMessage(
            SendWhatsAppMessageRequest sendWhatsAppMessageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Send a WhatsApp message. For examples of sending a message using the Amazon Web Services CLI, see <a
     * href="https://docs.aws.amazon.com/social-messaging/latest/userguide/send-message.html">Sending messages</a> in
     * the <i> <i>Amazon Web Services End User Messaging Social User Guide</i> </i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendWhatsAppMessageRequest.Builder} avoiding the
     * need to create one manually via {@link SendWhatsAppMessageRequest#builder()}
     * </p>
     *
     * @param sendWhatsAppMessageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.SendWhatsAppMessageRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the SendWhatsAppMessage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>InternalServiceException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>DependencyException Thrown when performing an action because a dependency would be broken.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.SendWhatsAppMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/SendWhatsAppMessage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendWhatsAppMessageResponse> sendWhatsAppMessage(
            Consumer<SendWhatsAppMessageRequest.Builder> sendWhatsAppMessageRequest) {
        return sendWhatsAppMessage(SendWhatsAppMessageRequest.builder().applyMutation(sendWhatsAppMessageRequest).build());
    }

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified resource. When you specify an existing tag key, the
     * value is overwritten with the new value.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>InternalServiceException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified resource. When you specify an existing tag key, the
     * value is overwritten with the new value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>InternalServiceException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>InternalServiceException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParametersException One or more parameters provided to the action are not valid.</li>
     *         <li>ThrottledRequestException The request was denied due to request throttling.</li>
     *         <li>InternalServiceException The request processing has failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SocialMessagingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SocialMessagingAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    @Override
    default SocialMessagingServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link SocialMessagingAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SocialMessagingAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SocialMessagingAsyncClient}.
     */
    static SocialMessagingAsyncClientBuilder builder() {
        return new DefaultSocialMessagingAsyncClientBuilder();
    }
}
