/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateWhatsAppBusinessAccountRequest extends SocialMessagingRequest implements
        ToCopyableBuilder<AssociateWhatsAppBusinessAccountRequest.Builder, AssociateWhatsAppBusinessAccountRequest> {
    private static final SdkField<WhatsAppSignupCallback> SIGNUP_CALLBACK_FIELD = SdkField
            .<WhatsAppSignupCallback> builder(MarshallingType.SDK_POJO).memberName("signupCallback")
            .getter(getter(AssociateWhatsAppBusinessAccountRequest::signupCallback)).setter(setter(Builder::signupCallback))
            .constructor(WhatsAppSignupCallback::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signupCallback").build()).build();

    private static final SdkField<WhatsAppSetupFinalization> SETUP_FINALIZATION_FIELD = SdkField
            .<WhatsAppSetupFinalization> builder(MarshallingType.SDK_POJO).memberName("setupFinalization")
            .getter(getter(AssociateWhatsAppBusinessAccountRequest::setupFinalization))
            .setter(setter(Builder::setupFinalization)).constructor(WhatsAppSetupFinalization::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("setupFinalization").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNUP_CALLBACK_FIELD,
            SETUP_FINALIZATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final WhatsAppSignupCallback signupCallback;

    private final WhatsAppSetupFinalization setupFinalization;

    private AssociateWhatsAppBusinessAccountRequest(BuilderImpl builder) {
        super(builder);
        this.signupCallback = builder.signupCallback;
        this.setupFinalization = builder.setupFinalization;
    }

    /**
     * <p>
     * Contains the callback access token.
     * </p>
     * 
     * @return Contains the callback access token.
     */
    public final WhatsAppSignupCallback signupCallback() {
        return signupCallback;
    }

    /**
     * <p>
     * A JSON object that contains the phone numbers and WhatsApp Business Account to link to your account.
     * </p>
     * 
     * @return A JSON object that contains the phone numbers and WhatsApp Business Account to link to your account.
     */
    public final WhatsAppSetupFinalization setupFinalization() {
        return setupFinalization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(signupCallback());
        hashCode = 31 * hashCode + Objects.hashCode(setupFinalization());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateWhatsAppBusinessAccountRequest)) {
            return false;
        }
        AssociateWhatsAppBusinessAccountRequest other = (AssociateWhatsAppBusinessAccountRequest) obj;
        return Objects.equals(signupCallback(), other.signupCallback())
                && Objects.equals(setupFinalization(), other.setupFinalization());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateWhatsAppBusinessAccountRequest").add("SignupCallback", signupCallback())
                .add("SetupFinalization", setupFinalization()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "signupCallback":
            return Optional.ofNullable(clazz.cast(signupCallback()));
        case "setupFinalization":
            return Optional.ofNullable(clazz.cast(setupFinalization()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("signupCallback", SIGNUP_CALLBACK_FIELD);
        map.put("setupFinalization", SETUP_FINALIZATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateWhatsAppBusinessAccountRequest, T> g) {
        return obj -> g.apply((AssociateWhatsAppBusinessAccountRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SocialMessagingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateWhatsAppBusinessAccountRequest> {
        /**
         * <p>
         * Contains the callback access token.
         * </p>
         * 
         * @param signupCallback
         *        Contains the callback access token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signupCallback(WhatsAppSignupCallback signupCallback);

        /**
         * <p>
         * Contains the callback access token.
         * </p>
         * This is a convenience method that creates an instance of the {@link WhatsAppSignupCallback.Builder} avoiding
         * the need to create one manually via {@link WhatsAppSignupCallback#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WhatsAppSignupCallback.Builder#build()} is called immediately and
         * its result is passed to {@link #signupCallback(WhatsAppSignupCallback)}.
         * 
         * @param signupCallback
         *        a consumer that will call methods on {@link WhatsAppSignupCallback.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signupCallback(WhatsAppSignupCallback)
         */
        default Builder signupCallback(Consumer<WhatsAppSignupCallback.Builder> signupCallback) {
            return signupCallback(WhatsAppSignupCallback.builder().applyMutation(signupCallback).build());
        }

        /**
         * <p>
         * A JSON object that contains the phone numbers and WhatsApp Business Account to link to your account.
         * </p>
         * 
         * @param setupFinalization
         *        A JSON object that contains the phone numbers and WhatsApp Business Account to link to your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setupFinalization(WhatsAppSetupFinalization setupFinalization);

        /**
         * <p>
         * A JSON object that contains the phone numbers and WhatsApp Business Account to link to your account.
         * </p>
         * This is a convenience method that creates an instance of the {@link WhatsAppSetupFinalization.Builder}
         * avoiding the need to create one manually via {@link WhatsAppSetupFinalization#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WhatsAppSetupFinalization.Builder#build()} is called immediately
         * and its result is passed to {@link #setupFinalization(WhatsAppSetupFinalization)}.
         * 
         * @param setupFinalization
         *        a consumer that will call methods on {@link WhatsAppSetupFinalization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #setupFinalization(WhatsAppSetupFinalization)
         */
        default Builder setupFinalization(Consumer<WhatsAppSetupFinalization.Builder> setupFinalization) {
            return setupFinalization(WhatsAppSetupFinalization.builder().applyMutation(setupFinalization).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SocialMessagingRequest.BuilderImpl implements Builder {
        private WhatsAppSignupCallback signupCallback;

        private WhatsAppSetupFinalization setupFinalization;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateWhatsAppBusinessAccountRequest model) {
            super(model);
            signupCallback(model.signupCallback);
            setupFinalization(model.setupFinalization);
        }

        public final WhatsAppSignupCallback.Builder getSignupCallback() {
            return signupCallback != null ? signupCallback.toBuilder() : null;
        }

        public final void setSignupCallback(WhatsAppSignupCallback.BuilderImpl signupCallback) {
            this.signupCallback = signupCallback != null ? signupCallback.build() : null;
        }

        @Override
        public final Builder signupCallback(WhatsAppSignupCallback signupCallback) {
            this.signupCallback = signupCallback;
            return this;
        }

        public final WhatsAppSetupFinalization.Builder getSetupFinalization() {
            return setupFinalization != null ? setupFinalization.toBuilder() : null;
        }

        public final void setSetupFinalization(WhatsAppSetupFinalization.BuilderImpl setupFinalization) {
            this.setupFinalization = setupFinalization != null ? setupFinalization.build() : null;
        }

        @Override
        @Transient
        public final Builder setupFinalization(WhatsAppSetupFinalization setupFinalization) {
            this.setupFinalization = setupFinalization;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateWhatsAppBusinessAccountRequest build() {
            return new AssociateWhatsAppBusinessAccountRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
