/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateWhatsAppBusinessAccountResponse extends SocialMessagingResponse implements
        ToCopyableBuilder<AssociateWhatsAppBusinessAccountResponse.Builder, AssociateWhatsAppBusinessAccountResponse> {
    private static final SdkField<WhatsAppSignupCallbackResult> SIGNUP_CALLBACK_RESULT_FIELD = SdkField
            .<WhatsAppSignupCallbackResult> builder(MarshallingType.SDK_POJO).memberName("signupCallbackResult")
            .getter(getter(AssociateWhatsAppBusinessAccountResponse::signupCallbackResult))
            .setter(setter(Builder::signupCallbackResult)).constructor(WhatsAppSignupCallbackResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signupCallbackResult").build())
            .build();

    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("statusCode").getter(getter(AssociateWhatsAppBusinessAccountResponse::statusCode))
            .setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNUP_CALLBACK_RESULT_FIELD,
            STATUS_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final WhatsAppSignupCallbackResult signupCallbackResult;

    private final Integer statusCodeValue;

    private AssociateWhatsAppBusinessAccountResponse(BuilderImpl builder) {
        super(builder);
        this.signupCallbackResult = builder.signupCallbackResult;
        this.statusCodeValue = builder.statusCodeValue;
    }

    /**
     * <p>
     * Contains your WhatsApp registration status.
     * </p>
     * 
     * @return Contains your WhatsApp registration status.
     */
    public final WhatsAppSignupCallbackResult signupCallbackResult() {
        return signupCallbackResult;
    }

    /**
     * <p>
     * The status code for the response.
     * </p>
     * 
     * @return The status code for the response.
     */
    public final Integer statusCode() {
        return statusCodeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(signupCallbackResult());
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateWhatsAppBusinessAccountResponse)) {
            return false;
        }
        AssociateWhatsAppBusinessAccountResponse other = (AssociateWhatsAppBusinessAccountResponse) obj;
        return Objects.equals(signupCallbackResult(), other.signupCallbackResult())
                && Objects.equals(statusCode(), other.statusCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateWhatsAppBusinessAccountResponse").add("SignupCallbackResult", signupCallbackResult())
                .add("StatusCode", statusCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "signupCallbackResult":
            return Optional.ofNullable(clazz.cast(signupCallbackResult()));
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("signupCallbackResult", SIGNUP_CALLBACK_RESULT_FIELD);
        map.put("statusCode", STATUS_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateWhatsAppBusinessAccountResponse, T> g) {
        return obj -> g.apply((AssociateWhatsAppBusinessAccountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SocialMessagingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateWhatsAppBusinessAccountResponse> {
        /**
         * <p>
         * Contains your WhatsApp registration status.
         * </p>
         * 
         * @param signupCallbackResult
         *        Contains your WhatsApp registration status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signupCallbackResult(WhatsAppSignupCallbackResult signupCallbackResult);

        /**
         * <p>
         * Contains your WhatsApp registration status.
         * </p>
         * This is a convenience method that creates an instance of the {@link WhatsAppSignupCallbackResult.Builder}
         * avoiding the need to create one manually via {@link WhatsAppSignupCallbackResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WhatsAppSignupCallbackResult.Builder#build()} is called
         * immediately and its result is passed to {@link #signupCallbackResult(WhatsAppSignupCallbackResult)}.
         * 
         * @param signupCallbackResult
         *        a consumer that will call methods on {@link WhatsAppSignupCallbackResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signupCallbackResult(WhatsAppSignupCallbackResult)
         */
        default Builder signupCallbackResult(Consumer<WhatsAppSignupCallbackResult.Builder> signupCallbackResult) {
            return signupCallbackResult(WhatsAppSignupCallbackResult.builder().applyMutation(signupCallbackResult).build());
        }

        /**
         * <p>
         * The status code for the response.
         * </p>
         * 
         * @param statusCodeValue
         *        The status code for the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(Integer statusCodeValue);
    }

    static final class BuilderImpl extends SocialMessagingResponse.BuilderImpl implements Builder {
        private WhatsAppSignupCallbackResult signupCallbackResult;

        private Integer statusCodeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateWhatsAppBusinessAccountResponse model) {
            super(model);
            signupCallbackResult(model.signupCallbackResult);
            statusCode(model.statusCodeValue);
        }

        public final WhatsAppSignupCallbackResult.Builder getSignupCallbackResult() {
            return signupCallbackResult != null ? signupCallbackResult.toBuilder() : null;
        }

        public final void setSignupCallbackResult(WhatsAppSignupCallbackResult.BuilderImpl signupCallbackResult) {
            this.signupCallbackResult = signupCallbackResult != null ? signupCallbackResult.build() : null;
        }

        @Override
        public final Builder signupCallbackResult(WhatsAppSignupCallbackResult signupCallbackResult) {
            this.signupCallbackResult = signupCallbackResult;
            return this;
        }

        public final Integer getStatusCode() {
            return statusCodeValue;
        }

        public final void setStatusCode(Integer statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(Integer statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        @Override
        public AssociateWhatsAppBusinessAccountResponse build() {
            return new AssociateWhatsAppBusinessAccountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
