/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLinkedWhatsAppBusinessAccountResponse extends SocialMessagingResponse implements
        ToCopyableBuilder<GetLinkedWhatsAppBusinessAccountResponse.Builder, GetLinkedWhatsAppBusinessAccountResponse> {
    private static final SdkField<LinkedWhatsAppBusinessAccount> ACCOUNT_FIELD = SdkField
            .<LinkedWhatsAppBusinessAccount> builder(MarshallingType.SDK_POJO).memberName("account")
            .getter(getter(GetLinkedWhatsAppBusinessAccountResponse::account)).setter(setter(Builder::account))
            .constructor(LinkedWhatsAppBusinessAccount::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("account").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final LinkedWhatsAppBusinessAccount account;

    private GetLinkedWhatsAppBusinessAccountResponse(BuilderImpl builder) {
        super(builder);
        this.account = builder.account;
    }

    /**
     * <p>
     * The details of the linked WhatsApp Business Account.
     * </p>
     * 
     * @return The details of the linked WhatsApp Business Account.
     */
    public final LinkedWhatsAppBusinessAccount account() {
        return account;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(account());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLinkedWhatsAppBusinessAccountResponse)) {
            return false;
        }
        GetLinkedWhatsAppBusinessAccountResponse other = (GetLinkedWhatsAppBusinessAccountResponse) obj;
        return Objects.equals(account(), other.account());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLinkedWhatsAppBusinessAccountResponse").add("Account", account()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "account":
            return Optional.ofNullable(clazz.cast(account()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("account", ACCOUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLinkedWhatsAppBusinessAccountResponse, T> g) {
        return obj -> g.apply((GetLinkedWhatsAppBusinessAccountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SocialMessagingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetLinkedWhatsAppBusinessAccountResponse> {
        /**
         * <p>
         * The details of the linked WhatsApp Business Account.
         * </p>
         * 
         * @param account
         *        The details of the linked WhatsApp Business Account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder account(LinkedWhatsAppBusinessAccount account);

        /**
         * <p>
         * The details of the linked WhatsApp Business Account.
         * </p>
         * This is a convenience method that creates an instance of the {@link LinkedWhatsAppBusinessAccount.Builder}
         * avoiding the need to create one manually via {@link LinkedWhatsAppBusinessAccount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LinkedWhatsAppBusinessAccount.Builder#build()} is called
         * immediately and its result is passed to {@link #account(LinkedWhatsAppBusinessAccount)}.
         * 
         * @param account
         *        a consumer that will call methods on {@link LinkedWhatsAppBusinessAccount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #account(LinkedWhatsAppBusinessAccount)
         */
        default Builder account(Consumer<LinkedWhatsAppBusinessAccount.Builder> account) {
            return account(LinkedWhatsAppBusinessAccount.builder().applyMutation(account).build());
        }
    }

    static final class BuilderImpl extends SocialMessagingResponse.BuilderImpl implements Builder {
        private LinkedWhatsAppBusinessAccount account;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLinkedWhatsAppBusinessAccountResponse model) {
            super(model);
            account(model.account);
        }

        public final LinkedWhatsAppBusinessAccount.Builder getAccount() {
            return account != null ? account.toBuilder() : null;
        }

        public final void setAccount(LinkedWhatsAppBusinessAccount.BuilderImpl account) {
            this.account = account != null ? account.build() : null;
        }

        @Override
        public final Builder account(LinkedWhatsAppBusinessAccount account) {
            this.account = account;
            return this;
        }

        @Override
        public GetLinkedWhatsAppBusinessAccountResponse build() {
            return new GetLinkedWhatsAppBusinessAccountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
