/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PostWhatsAppMessageMediaRequest extends SocialMessagingRequest implements
        ToCopyableBuilder<PostWhatsAppMessageMediaRequest.Builder, PostWhatsAppMessageMediaRequest> {
    private static final SdkField<String> ORIGINATION_PHONE_NUMBER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("originationPhoneNumberId").getter(getter(PostWhatsAppMessageMediaRequest::originationPhoneNumberId))
            .setter(setter(Builder::originationPhoneNumberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originationPhoneNumberId").build())
            .build();

    private static final SdkField<S3PresignedUrl> SOURCE_S3_PRESIGNED_URL_FIELD = SdkField
            .<S3PresignedUrl> builder(MarshallingType.SDK_POJO).memberName("sourceS3PresignedUrl")
            .getter(getter(PostWhatsAppMessageMediaRequest::sourceS3PresignedUrl)).setter(setter(Builder::sourceS3PresignedUrl))
            .constructor(S3PresignedUrl::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceS3PresignedUrl").build())
            .build();

    private static final SdkField<S3File> SOURCE_S3_FILE_FIELD = SdkField.<S3File> builder(MarshallingType.SDK_POJO)
            .memberName("sourceS3File").getter(getter(PostWhatsAppMessageMediaRequest::sourceS3File))
            .setter(setter(Builder::sourceS3File)).constructor(S3File::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceS3File").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORIGINATION_PHONE_NUMBER_ID_FIELD, SOURCE_S3_PRESIGNED_URL_FIELD, SOURCE_S3_FILE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String originationPhoneNumberId;

    private final S3PresignedUrl sourceS3PresignedUrl;

    private final S3File sourceS3File;

    private PostWhatsAppMessageMediaRequest(BuilderImpl builder) {
        super(builder);
        this.originationPhoneNumberId = builder.originationPhoneNumberId;
        this.sourceS3PresignedUrl = builder.sourceS3PresignedUrl;
        this.sourceS3File = builder.sourceS3File;
    }

    /**
     * <p>
     * The ID of the phone number to associate with the WhatsApp media file. The phone number identifiers are formatted
     * as <code>phone-number-id-01234567890123456789012345678901</code>. Use <a href=
     * "https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetLinkedWhatsAppBusinessAccountPhoneNumber.html"
     * >GetLinkedWhatsAppBusinessAccount</a> to find a phone number's id.
     * </p>
     * 
     * @return The ID of the phone number to associate with the WhatsApp media file. The phone number identifiers are
     *         formatted as <code>phone-number-id-01234567890123456789012345678901</code>. Use <a href=
     *         "https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetLinkedWhatsAppBusinessAccountPhoneNumber.html"
     *         >GetLinkedWhatsAppBusinessAccount</a> to find a phone number's id.
     */
    public final String originationPhoneNumberId() {
        return originationPhoneNumberId;
    }

    /**
     * <p>
     * The source presign url of the media file.
     * </p>
     * 
     * @return The source presign url of the media file.
     */
    public final S3PresignedUrl sourceS3PresignedUrl() {
        return sourceS3PresignedUrl;
    }

    /**
     * <p>
     * The source S3 url for the media file.
     * </p>
     * 
     * @return The source S3 url for the media file.
     */
    public final S3File sourceS3File() {
        return sourceS3File;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(originationPhoneNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceS3PresignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(sourceS3File());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostWhatsAppMessageMediaRequest)) {
            return false;
        }
        PostWhatsAppMessageMediaRequest other = (PostWhatsAppMessageMediaRequest) obj;
        return Objects.equals(originationPhoneNumberId(), other.originationPhoneNumberId())
                && Objects.equals(sourceS3PresignedUrl(), other.sourceS3PresignedUrl())
                && Objects.equals(sourceS3File(), other.sourceS3File());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PostWhatsAppMessageMediaRequest").add("OriginationPhoneNumberId", originationPhoneNumberId())
                .add("SourceS3PresignedUrl", sourceS3PresignedUrl() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SourceS3File", sourceS3File() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "originationPhoneNumberId":
            return Optional.ofNullable(clazz.cast(originationPhoneNumberId()));
        case "sourceS3PresignedUrl":
            return Optional.ofNullable(clazz.cast(sourceS3PresignedUrl()));
        case "sourceS3File":
            return Optional.ofNullable(clazz.cast(sourceS3File()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("originationPhoneNumberId", ORIGINATION_PHONE_NUMBER_ID_FIELD);
        map.put("sourceS3PresignedUrl", SOURCE_S3_PRESIGNED_URL_FIELD);
        map.put("sourceS3File", SOURCE_S3_FILE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PostWhatsAppMessageMediaRequest, T> g) {
        return obj -> g.apply((PostWhatsAppMessageMediaRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SocialMessagingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PostWhatsAppMessageMediaRequest> {
        /**
         * <p>
         * The ID of the phone number to associate with the WhatsApp media file. The phone number identifiers are
         * formatted as <code>phone-number-id-01234567890123456789012345678901</code>. Use <a href=
         * "https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetLinkedWhatsAppBusinessAccountPhoneNumber.html"
         * >GetLinkedWhatsAppBusinessAccount</a> to find a phone number's id.
         * </p>
         * 
         * @param originationPhoneNumberId
         *        The ID of the phone number to associate with the WhatsApp media file. The phone number identifiers are
         *        formatted as <code>phone-number-id-01234567890123456789012345678901</code>. Use <a href=
         *        "https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetLinkedWhatsAppBusinessAccountPhoneNumber.html"
         *        >GetLinkedWhatsAppBusinessAccount</a> to find a phone number's id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originationPhoneNumberId(String originationPhoneNumberId);

        /**
         * <p>
         * The source presign url of the media file.
         * </p>
         * 
         * @param sourceS3PresignedUrl
         *        The source presign url of the media file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceS3PresignedUrl(S3PresignedUrl sourceS3PresignedUrl);

        /**
         * <p>
         * The source presign url of the media file.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3PresignedUrl.Builder} avoiding the need
         * to create one manually via {@link S3PresignedUrl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3PresignedUrl.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceS3PresignedUrl(S3PresignedUrl)}.
         * 
         * @param sourceS3PresignedUrl
         *        a consumer that will call methods on {@link S3PresignedUrl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceS3PresignedUrl(S3PresignedUrl)
         */
        default Builder sourceS3PresignedUrl(Consumer<S3PresignedUrl.Builder> sourceS3PresignedUrl) {
            return sourceS3PresignedUrl(S3PresignedUrl.builder().applyMutation(sourceS3PresignedUrl).build());
        }

        /**
         * <p>
         * The source S3 url for the media file.
         * </p>
         * 
         * @param sourceS3File
         *        The source S3 url for the media file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceS3File(S3File sourceS3File);

        /**
         * <p>
         * The source S3 url for the media file.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3File.Builder} avoiding the need to
         * create one manually via {@link S3File#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3File.Builder#build()} is called immediately and its result is
         * passed to {@link #sourceS3File(S3File)}.
         * 
         * @param sourceS3File
         *        a consumer that will call methods on {@link S3File.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceS3File(S3File)
         */
        default Builder sourceS3File(Consumer<S3File.Builder> sourceS3File) {
            return sourceS3File(S3File.builder().applyMutation(sourceS3File).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SocialMessagingRequest.BuilderImpl implements Builder {
        private String originationPhoneNumberId;

        private S3PresignedUrl sourceS3PresignedUrl;

        private S3File sourceS3File;

        private BuilderImpl() {
        }

        private BuilderImpl(PostWhatsAppMessageMediaRequest model) {
            super(model);
            originationPhoneNumberId(model.originationPhoneNumberId);
            sourceS3PresignedUrl(model.sourceS3PresignedUrl);
            sourceS3File(model.sourceS3File);
        }

        public final String getOriginationPhoneNumberId() {
            return originationPhoneNumberId;
        }

        public final void setOriginationPhoneNumberId(String originationPhoneNumberId) {
            this.originationPhoneNumberId = originationPhoneNumberId;
        }

        @Override
        public final Builder originationPhoneNumberId(String originationPhoneNumberId) {
            this.originationPhoneNumberId = originationPhoneNumberId;
            return this;
        }

        public final S3PresignedUrl.Builder getSourceS3PresignedUrl() {
            return sourceS3PresignedUrl != null ? sourceS3PresignedUrl.toBuilder() : null;
        }

        public final void setSourceS3PresignedUrl(S3PresignedUrl.BuilderImpl sourceS3PresignedUrl) {
            this.sourceS3PresignedUrl = sourceS3PresignedUrl != null ? sourceS3PresignedUrl.build() : null;
        }

        @Override
        public final Builder sourceS3PresignedUrl(S3PresignedUrl sourceS3PresignedUrl) {
            this.sourceS3PresignedUrl = sourceS3PresignedUrl;
            return this;
        }

        public final S3File.Builder getSourceS3File() {
            return sourceS3File != null ? sourceS3File.toBuilder() : null;
        }

        public final void setSourceS3File(S3File.BuilderImpl sourceS3File) {
            this.sourceS3File = sourceS3File != null ? sourceS3File.build() : null;
        }

        @Override
        public final Builder sourceS3File(S3File sourceS3File) {
            this.sourceS3File = sourceS3File;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PostWhatsAppMessageMediaRequest build() {
            return new PostWhatsAppMessageMediaRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
