/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The registration details for a linked phone number.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WabaPhoneNumberSetupFinalization implements SdkPojo, Serializable,
        ToCopyableBuilder<WabaPhoneNumberSetupFinalization.Builder, WabaPhoneNumberSetupFinalization> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(WabaPhoneNumberSetupFinalization::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> TWO_FACTOR_PIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("twoFactorPin").getter(getter(WabaPhoneNumberSetupFinalization::twoFactorPin))
            .setter(setter(Builder::twoFactorPin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("twoFactorPin").build()).build();

    private static final SdkField<String> DATA_LOCALIZATION_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataLocalizationRegion").getter(getter(WabaPhoneNumberSetupFinalization::dataLocalizationRegion))
            .setter(setter(Builder::dataLocalizationRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataLocalizationRegion").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(WabaPhoneNumberSetupFinalization::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            TWO_FACTOR_PIN_FIELD, DATA_LOCALIZATION_REGION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String twoFactorPin;

    private final String dataLocalizationRegion;

    private final List<Tag> tags;

    private WabaPhoneNumberSetupFinalization(BuilderImpl builder) {
        this.id = builder.id;
        this.twoFactorPin = builder.twoFactorPin;
        this.dataLocalizationRegion = builder.dataLocalizationRegion;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique identifier of the originating phone number associated with the media. Phone number identifiers are
     * formatted as <code>phone-number-id-01234567890123456789012345678901</code>. Use <a href=
     * "https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetLinkedWhatsAppBusinessAccountPhoneNumber.html"
     * >GetLinkedWhatsAppBusinessAccount</a> to find a phone number's id.
     * </p>
     * 
     * @return The unique identifier of the originating phone number associated with the media. Phone number identifiers
     *         are formatted as <code>phone-number-id-01234567890123456789012345678901</code>. Use <a href=
     *         "https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetLinkedWhatsAppBusinessAccountPhoneNumber.html"
     *         >GetLinkedWhatsAppBusinessAccount</a> to find a phone number's id.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The PIN to use for two-step verification. To reset your PIN follow the directions in <a
     * href="https://developers.facebook.com/docs/whatsapp/cloud-api/reference/two-step-verification/#updating-pin"
     * >Updating PIN</a> in the <i>WhatsApp Business Platform Cloud API Reference</i>.
     * </p>
     * 
     * @return The PIN to use for two-step verification. To reset your PIN follow the directions in <a
     *         href="https://developers.facebook.com/docs/whatsapp/cloud-api/reference/two-step-verification/#updating-pin"
     *         >Updating PIN</a> in the <i>WhatsApp Business Platform Cloud API Reference</i>.
     */
    public final String twoFactorPin() {
        return twoFactorPin;
    }

    /**
     * <p>
     * The two letter ISO region for the location of where Meta will store data.
     * </p>
     * <p class="title">
     * <b>Asia–Pacific (APAC)</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Australia <b>AU</b>
     * </p>
     * </li>
     * <li>
     * <p>
     * Indonesia <b>ID</b>
     * </p>
     * </li>
     * <li>
     * <p>
     * India <b>IN</b>
     * </p>
     * </li>
     * <li>
     * <p>
     * Japan <b>JP</b>
     * </p>
     * </li>
     * <li>
     * <p>
     * Singapore <b>SG</b>
     * </p>
     * </li>
     * <li>
     * <p>
     * South Korea <b>KR</b>
     * </p>
     * </li>
     * </ul>
     * <p class="title">
     * <b>Europe</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Germany <b>DE</b>
     * </p>
     * </li>
     * <li>
     * <p>
     * Switzerland <b>CH</b>
     * </p>
     * </li>
     * <li>
     * <p>
     * United Kingdom <b>GB</b>
     * </p>
     * </li>
     * </ul>
     * <p class="title">
     * <b>Latin America (LATAM)</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Brazil <b>BR</b>
     * </p>
     * </li>
     * </ul>
     * <p class="title">
     * <b>Middle East and Africa (MEA)</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Bahrain <b>BH</b>
     * </p>
     * </li>
     * <li>
     * <p>
     * South Africa <b>ZA</b>
     * </p>
     * </li>
     * <li>
     * <p>
     * United Arab Emirates <b>AE</b>
     * </p>
     * </li>
     * </ul>
     * <p class="title">
     * <b>North America (NORAM)</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Canada <b>CA</b>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The two letter ISO region for the location of where Meta will store data.</p>
     *         <p class="title">
     *         <b>Asia–Pacific (APAC)</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Australia <b>AU</b>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Indonesia <b>ID</b>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         India <b>IN</b>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Japan <b>JP</b>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Singapore <b>SG</b>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         South Korea <b>KR</b>
     *         </p>
     *         </li>
     *         </ul>
     *         <p class="title">
     *         <b>Europe</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Germany <b>DE</b>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Switzerland <b>CH</b>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         United Kingdom <b>GB</b>
     *         </p>
     *         </li>
     *         </ul>
     *         <p class="title">
     *         <b>Latin America (LATAM)</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Brazil <b>BR</b>
     *         </p>
     *         </li>
     *         </ul>
     *         <p class="title">
     *         <b>Middle East and Africa (MEA)</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Bahrain <b>BH</b>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         South Africa <b>ZA</b>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         United Arab Emirates <b>AE</b>
     *         </p>
     *         </li>
     *         </ul>
     *         <p class="title">
     *         <b>North America (NORAM)</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Canada <b>CA</b>
     *         </p>
     *         </li>
     */
    public final String dataLocalizationRegion() {
        return dataLocalizationRegion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key and value pair tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of key and value pair tags.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(twoFactorPin());
        hashCode = 31 * hashCode + Objects.hashCode(dataLocalizationRegion());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WabaPhoneNumberSetupFinalization)) {
            return false;
        }
        WabaPhoneNumberSetupFinalization other = (WabaPhoneNumberSetupFinalization) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(twoFactorPin(), other.twoFactorPin())
                && Objects.equals(dataLocalizationRegion(), other.dataLocalizationRegion()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WabaPhoneNumberSetupFinalization").add("Id", id())
                .add("TwoFactorPin", twoFactorPin() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DataLocalizationRegion", dataLocalizationRegion()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "twoFactorPin":
            return Optional.ofNullable(clazz.cast(twoFactorPin()));
        case "dataLocalizationRegion":
            return Optional.ofNullable(clazz.cast(dataLocalizationRegion()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("twoFactorPin", TWO_FACTOR_PIN_FIELD);
        map.put("dataLocalizationRegion", DATA_LOCALIZATION_REGION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WabaPhoneNumberSetupFinalization, T> g) {
        return obj -> g.apply((WabaPhoneNumberSetupFinalization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WabaPhoneNumberSetupFinalization> {
        /**
         * <p>
         * The unique identifier of the originating phone number associated with the media. Phone number identifiers are
         * formatted as <code>phone-number-id-01234567890123456789012345678901</code>. Use <a href=
         * "https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetLinkedWhatsAppBusinessAccountPhoneNumber.html"
         * >GetLinkedWhatsAppBusinessAccount</a> to find a phone number's id.
         * </p>
         * 
         * @param id
         *        The unique identifier of the originating phone number associated with the media. Phone number
         *        identifiers are formatted as <code>phone-number-id-01234567890123456789012345678901</code>. Use <a
         *        href=
         *        "https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetLinkedWhatsAppBusinessAccountPhoneNumber.html"
         *        >GetLinkedWhatsAppBusinessAccount</a> to find a phone number's id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The PIN to use for two-step verification. To reset your PIN follow the directions in <a href=
         * "https://developers.facebook.com/docs/whatsapp/cloud-api/reference/two-step-verification/#updating-pin"
         * >Updating PIN</a> in the <i>WhatsApp Business Platform Cloud API Reference</i>.
         * </p>
         * 
         * @param twoFactorPin
         *        The PIN to use for two-step verification. To reset your PIN follow the directions in <a href=
         *        "https://developers.facebook.com/docs/whatsapp/cloud-api/reference/two-step-verification/#updating-pin"
         *        >Updating PIN</a> in the <i>WhatsApp Business Platform Cloud API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder twoFactorPin(String twoFactorPin);

        /**
         * <p>
         * The two letter ISO region for the location of where Meta will store data.
         * </p>
         * <p class="title">
         * <b>Asia–Pacific (APAC)</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Australia <b>AU</b>
         * </p>
         * </li>
         * <li>
         * <p>
         * Indonesia <b>ID</b>
         * </p>
         * </li>
         * <li>
         * <p>
         * India <b>IN</b>
         * </p>
         * </li>
         * <li>
         * <p>
         * Japan <b>JP</b>
         * </p>
         * </li>
         * <li>
         * <p>
         * Singapore <b>SG</b>
         * </p>
         * </li>
         * <li>
         * <p>
         * South Korea <b>KR</b>
         * </p>
         * </li>
         * </ul>
         * <p class="title">
         * <b>Europe</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Germany <b>DE</b>
         * </p>
         * </li>
         * <li>
         * <p>
         * Switzerland <b>CH</b>
         * </p>
         * </li>
         * <li>
         * <p>
         * United Kingdom <b>GB</b>
         * </p>
         * </li>
         * </ul>
         * <p class="title">
         * <b>Latin America (LATAM)</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Brazil <b>BR</b>
         * </p>
         * </li>
         * </ul>
         * <p class="title">
         * <b>Middle East and Africa (MEA)</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Bahrain <b>BH</b>
         * </p>
         * </li>
         * <li>
         * <p>
         * South Africa <b>ZA</b>
         * </p>
         * </li>
         * <li>
         * <p>
         * United Arab Emirates <b>AE</b>
         * </p>
         * </li>
         * </ul>
         * <p class="title">
         * <b>North America (NORAM)</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Canada <b>CA</b>
         * </p>
         * </li>
         * </ul>
         * 
         * @param dataLocalizationRegion
         *        The two letter ISO region for the location of where Meta will store data.</p>
         *        <p class="title">
         *        <b>Asia–Pacific (APAC)</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Australia <b>AU</b>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Indonesia <b>ID</b>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        India <b>IN</b>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Japan <b>JP</b>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Singapore <b>SG</b>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        South Korea <b>KR</b>
         *        </p>
         *        </li>
         *        </ul>
         *        <p class="title">
         *        <b>Europe</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Germany <b>DE</b>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Switzerland <b>CH</b>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        United Kingdom <b>GB</b>
         *        </p>
         *        </li>
         *        </ul>
         *        <p class="title">
         *        <b>Latin America (LATAM)</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Brazil <b>BR</b>
         *        </p>
         *        </li>
         *        </ul>
         *        <p class="title">
         *        <b>Middle East and Africa (MEA)</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Bahrain <b>BH</b>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        South Africa <b>ZA</b>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        United Arab Emirates <b>AE</b>
         *        </p>
         *        </li>
         *        </ul>
         *        <p class="title">
         *        <b>North America (NORAM)</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Canada <b>CA</b>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLocalizationRegion(String dataLocalizationRegion);

        /**
         * <p>
         * An array of key and value pair tags.
         * </p>
         * 
         * @param tags
         *        An array of key and value pair tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of key and value pair tags.
         * </p>
         * 
         * @param tags
         *        An array of key and value pair tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of key and value pair tags.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.socialmessaging.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.socialmessaging.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.socialmessaging.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.socialmessaging.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String twoFactorPin;

        private String dataLocalizationRegion;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WabaPhoneNumberSetupFinalization model) {
            id(model.id);
            twoFactorPin(model.twoFactorPin);
            dataLocalizationRegion(model.dataLocalizationRegion);
            tags(model.tags);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getTwoFactorPin() {
            return twoFactorPin;
        }

        public final void setTwoFactorPin(String twoFactorPin) {
            this.twoFactorPin = twoFactorPin;
        }

        @Override
        public final Builder twoFactorPin(String twoFactorPin) {
            this.twoFactorPin = twoFactorPin;
            return this;
        }

        public final String getDataLocalizationRegion() {
            return dataLocalizationRegion;
        }

        public final void setDataLocalizationRegion(String dataLocalizationRegion) {
            this.dataLocalizationRegion = dataLocalizationRegion;
        }

        @Override
        public final Builder dataLocalizationRegion(String dataLocalizationRegion) {
            this.dataLocalizationRegion = dataLocalizationRegion;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public WabaPhoneNumberSetupFinalization build() {
            return new WabaPhoneNumberSetupFinalization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
