/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The registration details for a linked WhatsApp Business Account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WabaSetupFinalization implements SdkPojo, Serializable,
        ToCopyableBuilder<WabaSetupFinalization.Builder, WabaSetupFinalization> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(WabaSetupFinalization::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<List<WhatsAppBusinessAccountEventDestination>> EVENT_DESTINATIONS_FIELD = SdkField
            .<List<WhatsAppBusinessAccountEventDestination>> builder(MarshallingType.LIST)
            .memberName("eventDestinations")
            .getter(getter(WabaSetupFinalization::eventDestinations))
            .setter(setter(Builder::eventDestinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventDestinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WhatsAppBusinessAccountEventDestination> builder(MarshallingType.SDK_POJO)
                                            .constructor(WhatsAppBusinessAccountEventDestination::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(WabaSetupFinalization::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            EVENT_DESTINATIONS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final List<WhatsAppBusinessAccountEventDestination> eventDestinations;

    private final List<Tag> tags;

    private WabaSetupFinalization(BuilderImpl builder) {
        this.id = builder.id;
        this.eventDestinations = builder.eventDestinations;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the linked WhatsApp Business Account, formatted as <code>waba-01234567890123456789012345678901</code>.
     * </p>
     * 
     * @return The ID of the linked WhatsApp Business Account, formatted as
     *         <code>waba-01234567890123456789012345678901</code>.
     */
    public final String id() {
        return id;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventDestinations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventDestinations() {
        return eventDestinations != null && !(eventDestinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The event destinations for the linked WhatsApp Business Account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventDestinations} method.
     * </p>
     * 
     * @return The event destinations for the linked WhatsApp Business Account.
     */
    public final List<WhatsAppBusinessAccountEventDestination> eventDestinations() {
        return eventDestinations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key and value pair tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of key and value pair tags.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventDestinations() ? eventDestinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WabaSetupFinalization)) {
            return false;
        }
        WabaSetupFinalization other = (WabaSetupFinalization) obj;
        return Objects.equals(id(), other.id()) && hasEventDestinations() == other.hasEventDestinations()
                && Objects.equals(eventDestinations(), other.eventDestinations()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WabaSetupFinalization").add("Id", id())
                .add("EventDestinations", hasEventDestinations() ? eventDestinations() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "eventDestinations":
            return Optional.ofNullable(clazz.cast(eventDestinations()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("eventDestinations", EVENT_DESTINATIONS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WabaSetupFinalization, T> g) {
        return obj -> g.apply((WabaSetupFinalization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WabaSetupFinalization> {
        /**
         * <p>
         * The ID of the linked WhatsApp Business Account, formatted as
         * <code>waba-01234567890123456789012345678901</code>.
         * </p>
         * 
         * @param id
         *        The ID of the linked WhatsApp Business Account, formatted as
         *        <code>waba-01234567890123456789012345678901</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The event destinations for the linked WhatsApp Business Account.
         * </p>
         * 
         * @param eventDestinations
         *        The event destinations for the linked WhatsApp Business Account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDestinations(Collection<WhatsAppBusinessAccountEventDestination> eventDestinations);

        /**
         * <p>
         * The event destinations for the linked WhatsApp Business Account.
         * </p>
         * 
         * @param eventDestinations
         *        The event destinations for the linked WhatsApp Business Account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDestinations(WhatsAppBusinessAccountEventDestination... eventDestinations);

        /**
         * <p>
         * The event destinations for the linked WhatsApp Business Account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.socialmessaging.model.WhatsAppBusinessAccountEventDestination.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.socialmessaging.model.WhatsAppBusinessAccountEventDestination#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.socialmessaging.model.WhatsAppBusinessAccountEventDestination.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #eventDestinations(List<WhatsAppBusinessAccountEventDestination>)}.
         * 
         * @param eventDestinations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.socialmessaging.model.WhatsAppBusinessAccountEventDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventDestinations(java.util.Collection<WhatsAppBusinessAccountEventDestination>)
         */
        Builder eventDestinations(Consumer<WhatsAppBusinessAccountEventDestination.Builder>... eventDestinations);

        /**
         * <p>
         * An array of key and value pair tags.
         * </p>
         * 
         * @param tags
         *        An array of key and value pair tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of key and value pair tags.
         * </p>
         * 
         * @param tags
         *        An array of key and value pair tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of key and value pair tags.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.socialmessaging.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.socialmessaging.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.socialmessaging.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.socialmessaging.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private List<WhatsAppBusinessAccountEventDestination> eventDestinations = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WabaSetupFinalization model) {
            id(model.id);
            eventDestinations(model.eventDestinations);
            tags(model.tags);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<WhatsAppBusinessAccountEventDestination.Builder> getEventDestinations() {
            List<WhatsAppBusinessAccountEventDestination.Builder> result = WhatsAppBusinessAccountEventDestinationsCopier
                    .copyToBuilder(this.eventDestinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventDestinations(Collection<WhatsAppBusinessAccountEventDestination.BuilderImpl> eventDestinations) {
            this.eventDestinations = WhatsAppBusinessAccountEventDestinationsCopier.copyFromBuilder(eventDestinations);
        }

        @Override
        public final Builder eventDestinations(Collection<WhatsAppBusinessAccountEventDestination> eventDestinations) {
            this.eventDestinations = WhatsAppBusinessAccountEventDestinationsCopier.copy(eventDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventDestinations(WhatsAppBusinessAccountEventDestination... eventDestinations) {
            eventDestinations(Arrays.asList(eventDestinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventDestinations(Consumer<WhatsAppBusinessAccountEventDestination.Builder>... eventDestinations) {
            eventDestinations(Stream.of(eventDestinations)
                    .map(c -> WhatsAppBusinessAccountEventDestination.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public WabaSetupFinalization build() {
            return new WabaSetupFinalization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
