/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of your WhatsApp phone number.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WhatsAppPhoneNumberDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<WhatsAppPhoneNumberDetail.Builder, WhatsAppPhoneNumberDetail> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(WhatsAppPhoneNumberDetail::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("phoneNumber").getter(getter(WhatsAppPhoneNumberDetail::phoneNumber))
            .setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phoneNumber").build()).build();

    private static final SdkField<String> PHONE_NUMBER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("phoneNumberId").getter(getter(WhatsAppPhoneNumberDetail::phoneNumberId))
            .setter(setter(Builder::phoneNumberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phoneNumberId").build()).build();

    private static final SdkField<String> META_PHONE_NUMBER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metaPhoneNumberId").getter(getter(WhatsAppPhoneNumberDetail::metaPhoneNumberId))
            .setter(setter(Builder::metaPhoneNumberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metaPhoneNumberId").build()).build();

    private static final SdkField<String> DISPLAY_PHONE_NUMBER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayPhoneNumberName").getter(getter(WhatsAppPhoneNumberDetail::displayPhoneNumberName))
            .setter(setter(Builder::displayPhoneNumberName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayPhoneNumberName").build())
            .build();

    private static final SdkField<String> DISPLAY_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayPhoneNumber").getter(getter(WhatsAppPhoneNumberDetail::displayPhoneNumber))
            .setter(setter(Builder::displayPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayPhoneNumber").build())
            .build();

    private static final SdkField<String> QUALITY_RATING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("qualityRating").getter(getter(WhatsAppPhoneNumberDetail::qualityRating))
            .setter(setter(Builder::qualityRating))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qualityRating").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, PHONE_NUMBER_FIELD,
            PHONE_NUMBER_ID_FIELD, META_PHONE_NUMBER_ID_FIELD, DISPLAY_PHONE_NUMBER_NAME_FIELD, DISPLAY_PHONE_NUMBER_FIELD,
            QUALITY_RATING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String phoneNumber;

    private final String phoneNumberId;

    private final String metaPhoneNumberId;

    private final String displayPhoneNumberName;

    private final String displayPhoneNumber;

    private final String qualityRating;

    private WhatsAppPhoneNumberDetail(BuilderImpl builder) {
        this.arn = builder.arn;
        this.phoneNumber = builder.phoneNumber;
        this.phoneNumberId = builder.phoneNumberId;
        this.metaPhoneNumberId = builder.metaPhoneNumberId;
        this.displayPhoneNumberName = builder.displayPhoneNumberName;
        this.displayPhoneNumber = builder.displayPhoneNumber;
        this.qualityRating = builder.qualityRating;
    }

    /**
     * <p>
     * The ARN of the WhatsApp phone number.
     * </p>
     * 
     * @return The ARN of the WhatsApp phone number.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The phone number for sending WhatsApp.
     * </p>
     * 
     * @return The phone number for sending WhatsApp.
     */
    public final String phoneNumber() {
        return phoneNumber;
    }

    /**
     * <p>
     * The phone number ID. Phone number identifiers are formatted as
     * <code>phone-number-id-01234567890123456789012345678901</code>.
     * </p>
     * 
     * @return The phone number ID. Phone number identifiers are formatted as
     *         <code>phone-number-id-01234567890123456789012345678901</code>.
     */
    public final String phoneNumberId() {
        return phoneNumberId;
    }

    /**
     * <p>
     * The phone number ID from Meta.
     * </p>
     * 
     * @return The phone number ID from Meta.
     */
    public final String metaPhoneNumberId() {
        return metaPhoneNumberId;
    }

    /**
     * <p>
     * The display name for this phone number.
     * </p>
     * 
     * @return The display name for this phone number.
     */
    public final String displayPhoneNumberName() {
        return displayPhoneNumberName;
    }

    /**
     * <p>
     * The phone number that appears in the recipients display.
     * </p>
     * 
     * @return The phone number that appears in the recipients display.
     */
    public final String displayPhoneNumber() {
        return displayPhoneNumber;
    }

    /**
     * <p>
     * The quality rating of the phone number.
     * </p>
     * 
     * @return The quality rating of the phone number.
     */
    public final String qualityRating() {
        return qualityRating;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(metaPhoneNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(displayPhoneNumberName());
        hashCode = 31 * hashCode + Objects.hashCode(displayPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(qualityRating());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WhatsAppPhoneNumberDetail)) {
            return false;
        }
        WhatsAppPhoneNumberDetail other = (WhatsAppPhoneNumberDetail) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(phoneNumber(), other.phoneNumber())
                && Objects.equals(phoneNumberId(), other.phoneNumberId())
                && Objects.equals(metaPhoneNumberId(), other.metaPhoneNumberId())
                && Objects.equals(displayPhoneNumberName(), other.displayPhoneNumberName())
                && Objects.equals(displayPhoneNumber(), other.displayPhoneNumber())
                && Objects.equals(qualityRating(), other.qualityRating());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WhatsAppPhoneNumberDetail").add("Arn", arn()).add("PhoneNumber", phoneNumber())
                .add("PhoneNumberId", phoneNumberId()).add("MetaPhoneNumberId", metaPhoneNumberId())
                .add("DisplayPhoneNumberName", displayPhoneNumberName()).add("DisplayPhoneNumber", displayPhoneNumber())
                .add("QualityRating", qualityRating()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "phoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "phoneNumberId":
            return Optional.ofNullable(clazz.cast(phoneNumberId()));
        case "metaPhoneNumberId":
            return Optional.ofNullable(clazz.cast(metaPhoneNumberId()));
        case "displayPhoneNumberName":
            return Optional.ofNullable(clazz.cast(displayPhoneNumberName()));
        case "displayPhoneNumber":
            return Optional.ofNullable(clazz.cast(displayPhoneNumber()));
        case "qualityRating":
            return Optional.ofNullable(clazz.cast(qualityRating()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("phoneNumber", PHONE_NUMBER_FIELD);
        map.put("phoneNumberId", PHONE_NUMBER_ID_FIELD);
        map.put("metaPhoneNumberId", META_PHONE_NUMBER_ID_FIELD);
        map.put("displayPhoneNumberName", DISPLAY_PHONE_NUMBER_NAME_FIELD);
        map.put("displayPhoneNumber", DISPLAY_PHONE_NUMBER_FIELD);
        map.put("qualityRating", QUALITY_RATING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WhatsAppPhoneNumberDetail, T> g) {
        return obj -> g.apply((WhatsAppPhoneNumberDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WhatsAppPhoneNumberDetail> {
        /**
         * <p>
         * The ARN of the WhatsApp phone number.
         * </p>
         * 
         * @param arn
         *        The ARN of the WhatsApp phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The phone number for sending WhatsApp.
         * </p>
         * 
         * @param phoneNumber
         *        The phone number for sending WhatsApp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * The phone number ID. Phone number identifiers are formatted as
         * <code>phone-number-id-01234567890123456789012345678901</code>.
         * </p>
         * 
         * @param phoneNumberId
         *        The phone number ID. Phone number identifiers are formatted as
         *        <code>phone-number-id-01234567890123456789012345678901</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberId(String phoneNumberId);

        /**
         * <p>
         * The phone number ID from Meta.
         * </p>
         * 
         * @param metaPhoneNumberId
         *        The phone number ID from Meta.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metaPhoneNumberId(String metaPhoneNumberId);

        /**
         * <p>
         * The display name for this phone number.
         * </p>
         * 
         * @param displayPhoneNumberName
         *        The display name for this phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayPhoneNumberName(String displayPhoneNumberName);

        /**
         * <p>
         * The phone number that appears in the recipients display.
         * </p>
         * 
         * @param displayPhoneNumber
         *        The phone number that appears in the recipients display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayPhoneNumber(String displayPhoneNumber);

        /**
         * <p>
         * The quality rating of the phone number.
         * </p>
         * 
         * @param qualityRating
         *        The quality rating of the phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualityRating(String qualityRating);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String phoneNumber;

        private String phoneNumberId;

        private String metaPhoneNumberId;

        private String displayPhoneNumberName;

        private String displayPhoneNumber;

        private String qualityRating;

        private BuilderImpl() {
        }

        private BuilderImpl(WhatsAppPhoneNumberDetail model) {
            arn(model.arn);
            phoneNumber(model.phoneNumber);
            phoneNumberId(model.phoneNumberId);
            metaPhoneNumberId(model.metaPhoneNumberId);
            displayPhoneNumberName(model.displayPhoneNumberName);
            displayPhoneNumber(model.displayPhoneNumber);
            qualityRating(model.qualityRating);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getPhoneNumberId() {
            return phoneNumberId;
        }

        public final void setPhoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
        }

        @Override
        public final Builder phoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
            return this;
        }

        public final String getMetaPhoneNumberId() {
            return metaPhoneNumberId;
        }

        public final void setMetaPhoneNumberId(String metaPhoneNumberId) {
            this.metaPhoneNumberId = metaPhoneNumberId;
        }

        @Override
        public final Builder metaPhoneNumberId(String metaPhoneNumberId) {
            this.metaPhoneNumberId = metaPhoneNumberId;
            return this;
        }

        public final String getDisplayPhoneNumberName() {
            return displayPhoneNumberName;
        }

        public final void setDisplayPhoneNumberName(String displayPhoneNumberName) {
            this.displayPhoneNumberName = displayPhoneNumberName;
        }

        @Override
        public final Builder displayPhoneNumberName(String displayPhoneNumberName) {
            this.displayPhoneNumberName = displayPhoneNumberName;
            return this;
        }

        public final String getDisplayPhoneNumber() {
            return displayPhoneNumber;
        }

        public final void setDisplayPhoneNumber(String displayPhoneNumber) {
            this.displayPhoneNumber = displayPhoneNumber;
        }

        @Override
        public final Builder displayPhoneNumber(String displayPhoneNumber) {
            this.displayPhoneNumber = displayPhoneNumber;
            return this;
        }

        public final String getQualityRating() {
            return qualityRating;
        }

        public final void setQualityRating(String qualityRating) {
            this.qualityRating = qualityRating;
        }

        @Override
        public final Builder qualityRating(String qualityRating) {
            this.qualityRating = qualityRating;
            return this;
        }

        @Override
        public WhatsAppPhoneNumberDetail build() {
            return new WhatsAppPhoneNumberDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
