/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.socialmessaging.model.AccessDeniedByMetaException;
import software.amazon.awssdk.services.socialmessaging.model.AccessDeniedException;
import software.amazon.awssdk.services.socialmessaging.model.AssociateWhatsAppBusinessAccountRequest;
import software.amazon.awssdk.services.socialmessaging.model.AssociateWhatsAppBusinessAccountResponse;
import software.amazon.awssdk.services.socialmessaging.model.CreateWhatsAppMessageTemplateFromLibraryRequest;
import software.amazon.awssdk.services.socialmessaging.model.CreateWhatsAppMessageTemplateFromLibraryResponse;
import software.amazon.awssdk.services.socialmessaging.model.CreateWhatsAppMessageTemplateMediaRequest;
import software.amazon.awssdk.services.socialmessaging.model.CreateWhatsAppMessageTemplateMediaResponse;
import software.amazon.awssdk.services.socialmessaging.model.CreateWhatsAppMessageTemplateRequest;
import software.amazon.awssdk.services.socialmessaging.model.CreateWhatsAppMessageTemplateResponse;
import software.amazon.awssdk.services.socialmessaging.model.DeleteWhatsAppMessageMediaRequest;
import software.amazon.awssdk.services.socialmessaging.model.DeleteWhatsAppMessageMediaResponse;
import software.amazon.awssdk.services.socialmessaging.model.DeleteWhatsAppMessageTemplateRequest;
import software.amazon.awssdk.services.socialmessaging.model.DeleteWhatsAppMessageTemplateResponse;
import software.amazon.awssdk.services.socialmessaging.model.DependencyException;
import software.amazon.awssdk.services.socialmessaging.model.DisassociateWhatsAppBusinessAccountRequest;
import software.amazon.awssdk.services.socialmessaging.model.DisassociateWhatsAppBusinessAccountResponse;
import software.amazon.awssdk.services.socialmessaging.model.GetLinkedWhatsAppBusinessAccountPhoneNumberRequest;
import software.amazon.awssdk.services.socialmessaging.model.GetLinkedWhatsAppBusinessAccountPhoneNumberResponse;
import software.amazon.awssdk.services.socialmessaging.model.GetLinkedWhatsAppBusinessAccountRequest;
import software.amazon.awssdk.services.socialmessaging.model.GetLinkedWhatsAppBusinessAccountResponse;
import software.amazon.awssdk.services.socialmessaging.model.GetWhatsAppMessageMediaRequest;
import software.amazon.awssdk.services.socialmessaging.model.GetWhatsAppMessageMediaResponse;
import software.amazon.awssdk.services.socialmessaging.model.GetWhatsAppMessageTemplateRequest;
import software.amazon.awssdk.services.socialmessaging.model.GetWhatsAppMessageTemplateResponse;
import software.amazon.awssdk.services.socialmessaging.model.InternalServiceException;
import software.amazon.awssdk.services.socialmessaging.model.InvalidParametersException;
import software.amazon.awssdk.services.socialmessaging.model.LimitExceededException;
import software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsRequest;
import software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsResponse;
import software.amazon.awssdk.services.socialmessaging.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.socialmessaging.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppMessageTemplatesRequest;
import software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppMessageTemplatesResponse;
import software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppTemplateLibraryRequest;
import software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppTemplateLibraryResponse;
import software.amazon.awssdk.services.socialmessaging.model.PostWhatsAppMessageMediaRequest;
import software.amazon.awssdk.services.socialmessaging.model.PostWhatsAppMessageMediaResponse;
import software.amazon.awssdk.services.socialmessaging.model.PutWhatsAppBusinessAccountEventDestinationsRequest;
import software.amazon.awssdk.services.socialmessaging.model.PutWhatsAppBusinessAccountEventDestinationsResponse;
import software.amazon.awssdk.services.socialmessaging.model.ResourceNotFoundException;
import software.amazon.awssdk.services.socialmessaging.model.SendWhatsAppMessageRequest;
import software.amazon.awssdk.services.socialmessaging.model.SendWhatsAppMessageResponse;
import software.amazon.awssdk.services.socialmessaging.model.SocialMessagingException;
import software.amazon.awssdk.services.socialmessaging.model.TagResourceRequest;
import software.amazon.awssdk.services.socialmessaging.model.TagResourceResponse;
import software.amazon.awssdk.services.socialmessaging.model.ThrottledRequestException;
import software.amazon.awssdk.services.socialmessaging.model.UntagResourceRequest;
import software.amazon.awssdk.services.socialmessaging.model.UntagResourceResponse;
import software.amazon.awssdk.services.socialmessaging.model.UpdateWhatsAppMessageTemplateRequest;
import software.amazon.awssdk.services.socialmessaging.model.UpdateWhatsAppMessageTemplateResponse;
import software.amazon.awssdk.services.socialmessaging.model.ValidationException;
import software.amazon.awssdk.services.socialmessaging.paginators.ListLinkedWhatsAppBusinessAccountsIterable;
import software.amazon.awssdk.services.socialmessaging.paginators.ListWhatsAppMessageTemplatesIterable;
import software.amazon.awssdk.services.socialmessaging.paginators.ListWhatsAppTemplateLibraryIterable;

/**
 * Service client for accessing AWS End User Messaging Social. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * <i>Amazon Web Services End User Messaging Social</i>, also referred to as Social messaging, is a messaging service
 * that enables application developers to incorporate WhatsApp into their existing workflows. The <i>Amazon Web Services
 * End User Messaging Social API</i> provides information about the <i>Amazon Web Services End User Messaging Social
 * API</i> resources, including supported HTTP methods, parameters, and schemas.
 * </p>
 * <p>
 * The <i>Amazon Web Services End User Messaging Social API</i> provides programmatic access to options that are unique
 * to the WhatsApp Business Platform.
 * </p>
 * <p>
 * If you're new to the <i>Amazon Web Services End User Messaging Social API</i>, it's also helpful to review <a
 * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/what-is-service.html">What is Amazon Web Services End
 * User Messaging Social</a> in the <i>Amazon Web Services End User Messaging Social User Guide</i>. The <i>Amazon Web
 * Services End User Messaging Social User Guide</i> provides tutorials, code samples, and procedures that demonstrate
 * how to use <i>Amazon Web Services End User Messaging Social API</i> features programmatically and how to integrate
 * functionality into applications. The guide also provides key information, such as integration with other Amazon Web
 * Services services, and the quotas that apply to use of the service.
 * </p>
 * <p>
 * <b>Regional availability</b>
 * </p>
 * <p>
 * The <i>Amazon Web Services End User Messaging Social API</i> is available across several Amazon Web Services Regions
 * and it provides a dedicated endpoint for each of these Regions. For a list of all the Regions and endpoints where the
 * API is currently available, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/rande.html#pinpoint_region">Amazon Web Services Service
 * Endpoints</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/end-user-messaging.html">Amazon Web Services
 * End User Messaging endpoints and quotas</a> in the Amazon Web Services General Reference. To learn more about Amazon
 * Web Services Regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html">Managing Amazon
 * Web Services Regions</a> in the Amazon Web Services General Reference.
 * </p>
 * <p>
 * In each Region, Amazon Web Services maintains multiple Availability Zones. These Availability Zones are physically
 * isolated from each other, but are united by private, low-latency, high-throughput, and highly redundant network
 * connections. These Availability Zones enable us to provide very high levels of availability and redundancy, while
 * also minimizing latency. To learn more about the number of Availability Zones that are available in each Region, see
 * <a href="https://aws.amazon.com/about-aws/global-infrastructure/">Amazon Web Services Global Infrastructure.</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SocialMessagingClient extends AwsClient {
    String SERVICE_NAME = "social-messaging";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "social-messaging";

    /**
     * <p>
     * This is only used through the Amazon Web Services console during sign-up to associate your WhatsApp Business
     * Account to your Amazon Web Services account.
     * </p>
     *
     * @param associateWhatsAppBusinessAccountRequest
     * @return Result of the AssociateWhatsAppBusinessAccount operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws LimitExceededException
     *         The request was denied because it would exceed one or more service quotas or limits.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.AssociateWhatsAppBusinessAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/AssociateWhatsAppBusinessAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateWhatsAppBusinessAccountResponse associateWhatsAppBusinessAccount(
            AssociateWhatsAppBusinessAccountRequest associateWhatsAppBusinessAccountRequest) throws ValidationException,
            LimitExceededException, AccessDeniedException, InvalidParametersException, ThrottledRequestException,
            DependencyException, AwsServiceException, SdkClientException, SocialMessagingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is only used through the Amazon Web Services console during sign-up to associate your WhatsApp Business
     * Account to your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateWhatsAppBusinessAccountRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateWhatsAppBusinessAccountRequest#builder()}
     * </p>
     *
     * @param associateWhatsAppBusinessAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.AssociateWhatsAppBusinessAccountRequest.Builder}
     *        to create a request.
     * @return Result of the AssociateWhatsAppBusinessAccount operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws LimitExceededException
     *         The request was denied because it would exceed one or more service quotas or limits.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.AssociateWhatsAppBusinessAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/AssociateWhatsAppBusinessAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateWhatsAppBusinessAccountResponse associateWhatsAppBusinessAccount(
            Consumer<AssociateWhatsAppBusinessAccountRequest.Builder> associateWhatsAppBusinessAccountRequest)
            throws ValidationException, LimitExceededException, AccessDeniedException, InvalidParametersException,
            ThrottledRequestException, DependencyException, AwsServiceException, SdkClientException, SocialMessagingException {
        return associateWhatsAppBusinessAccount(AssociateWhatsAppBusinessAccountRequest.builder()
                .applyMutation(associateWhatsAppBusinessAccountRequest).build());
    }

    /**
     * <p>
     * Creates a new WhatsApp message template from a custom definition.
     * </p>
     *
     * @param createWhatsAppMessageTemplateRequest
     * @return Result of the CreateWhatsAppMessageTemplate operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.CreateWhatsAppMessageTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/CreateWhatsAppMessageTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWhatsAppMessageTemplateResponse createWhatsAppMessageTemplate(
            CreateWhatsAppMessageTemplateRequest createWhatsAppMessageTemplateRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException,
            InternalServiceException, DependencyException, AwsServiceException, SdkClientException, SocialMessagingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new WhatsApp message template from a custom definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWhatsAppMessageTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link CreateWhatsAppMessageTemplateRequest#builder()}
     * </p>
     *
     * @param createWhatsAppMessageTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.CreateWhatsAppMessageTemplateRequest.Builder}
     *        to create a request.
     * @return Result of the CreateWhatsAppMessageTemplate operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.CreateWhatsAppMessageTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/CreateWhatsAppMessageTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWhatsAppMessageTemplateResponse createWhatsAppMessageTemplate(
            Consumer<CreateWhatsAppMessageTemplateRequest.Builder> createWhatsAppMessageTemplateRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InvalidParametersException,
            ThrottledRequestException, InternalServiceException, DependencyException, AwsServiceException, SdkClientException,
            SocialMessagingException {
        return createWhatsAppMessageTemplate(CreateWhatsAppMessageTemplateRequest.builder()
                .applyMutation(createWhatsAppMessageTemplateRequest).build());
    }

    /**
     * <p>
     * Creates a new WhatsApp message template using a template from Meta's template library.
     * </p>
     *
     * @param createWhatsAppMessageTemplateFromLibraryRequest
     * @return Result of the CreateWhatsAppMessageTemplateFromLibrary operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.CreateWhatsAppMessageTemplateFromLibrary
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/CreateWhatsAppMessageTemplateFromLibrary"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWhatsAppMessageTemplateFromLibraryResponse createWhatsAppMessageTemplateFromLibrary(
            CreateWhatsAppMessageTemplateFromLibraryRequest createWhatsAppMessageTemplateFromLibraryRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InvalidParametersException,
            ThrottledRequestException, InternalServiceException, DependencyException, AwsServiceException, SdkClientException,
            SocialMessagingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new WhatsApp message template using a template from Meta's template library.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateWhatsAppMessageTemplateFromLibraryRequest.Builder} avoiding the need to create one manually via
     * {@link CreateWhatsAppMessageTemplateFromLibraryRequest#builder()}
     * </p>
     *
     * @param createWhatsAppMessageTemplateFromLibraryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.CreateWhatsAppMessageTemplateFromLibraryRequest.Builder}
     *        to create a request.
     * @return Result of the CreateWhatsAppMessageTemplateFromLibrary operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.CreateWhatsAppMessageTemplateFromLibrary
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/CreateWhatsAppMessageTemplateFromLibrary"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWhatsAppMessageTemplateFromLibraryResponse createWhatsAppMessageTemplateFromLibrary(
            Consumer<CreateWhatsAppMessageTemplateFromLibraryRequest.Builder> createWhatsAppMessageTemplateFromLibraryRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InvalidParametersException,
            ThrottledRequestException, InternalServiceException, DependencyException, AwsServiceException, SdkClientException,
            SocialMessagingException {
        return createWhatsAppMessageTemplateFromLibrary(CreateWhatsAppMessageTemplateFromLibraryRequest.builder()
                .applyMutation(createWhatsAppMessageTemplateFromLibraryRequest).build());
    }

    /**
     * <p>
     * Uploads media for use in a WhatsApp message template.
     * </p>
     *
     * @param createWhatsAppMessageTemplateMediaRequest
     * @return Result of the CreateWhatsAppMessageTemplateMedia operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.CreateWhatsAppMessageTemplateMedia
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/CreateWhatsAppMessageTemplateMedia"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWhatsAppMessageTemplateMediaResponse createWhatsAppMessageTemplateMedia(
            CreateWhatsAppMessageTemplateMediaRequest createWhatsAppMessageTemplateMediaRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException,
            InternalServiceException, DependencyException, AwsServiceException, SdkClientException, SocialMessagingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uploads media for use in a WhatsApp message template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWhatsAppMessageTemplateMediaRequest.Builder}
     * avoiding the need to create one manually via {@link CreateWhatsAppMessageTemplateMediaRequest#builder()}
     * </p>
     *
     * @param createWhatsAppMessageTemplateMediaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.CreateWhatsAppMessageTemplateMediaRequest.Builder}
     *        to create a request.
     * @return Result of the CreateWhatsAppMessageTemplateMedia operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.CreateWhatsAppMessageTemplateMedia
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/CreateWhatsAppMessageTemplateMedia"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWhatsAppMessageTemplateMediaResponse createWhatsAppMessageTemplateMedia(
            Consumer<CreateWhatsAppMessageTemplateMediaRequest.Builder> createWhatsAppMessageTemplateMediaRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InvalidParametersException,
            ThrottledRequestException, InternalServiceException, DependencyException, AwsServiceException, SdkClientException,
            SocialMessagingException {
        return createWhatsAppMessageTemplateMedia(CreateWhatsAppMessageTemplateMediaRequest.builder()
                .applyMutation(createWhatsAppMessageTemplateMediaRequest).build());
    }

    /**
     * <p>
     * Delete a media object from the WhatsApp service. If the object is still in an Amazon S3 bucket you should delete
     * it from there too.
     * </p>
     *
     * @param deleteWhatsAppMessageMediaRequest
     * @return Result of the DeleteWhatsAppMessageMedia operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedByMetaException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.DeleteWhatsAppMessageMedia
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/DeleteWhatsAppMessageMedia"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWhatsAppMessageMediaResponse deleteWhatsAppMessageMedia(
            DeleteWhatsAppMessageMediaRequest deleteWhatsAppMessageMediaRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException,
            AccessDeniedByMetaException, InternalServiceException, DependencyException, AwsServiceException, SdkClientException,
            SocialMessagingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a media object from the WhatsApp service. If the object is still in an Amazon S3 bucket you should delete
     * it from there too.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWhatsAppMessageMediaRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteWhatsAppMessageMediaRequest#builder()}
     * </p>
     *
     * @param deleteWhatsAppMessageMediaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.DeleteWhatsAppMessageMediaRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteWhatsAppMessageMedia operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedByMetaException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.DeleteWhatsAppMessageMedia
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/DeleteWhatsAppMessageMedia"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWhatsAppMessageMediaResponse deleteWhatsAppMessageMedia(
            Consumer<DeleteWhatsAppMessageMediaRequest.Builder> deleteWhatsAppMessageMediaRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException,
            AccessDeniedByMetaException, InternalServiceException, DependencyException, AwsServiceException, SdkClientException,
            SocialMessagingException {
        return deleteWhatsAppMessageMedia(DeleteWhatsAppMessageMediaRequest.builder()
                .applyMutation(deleteWhatsAppMessageMediaRequest).build());
    }

    /**
     * <p>
     * Deletes a WhatsApp message template.
     * </p>
     *
     * @param deleteWhatsAppMessageTemplateRequest
     * @return Result of the DeleteWhatsAppMessageTemplate operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.DeleteWhatsAppMessageTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/DeleteWhatsAppMessageTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWhatsAppMessageTemplateResponse deleteWhatsAppMessageTemplate(
            DeleteWhatsAppMessageTemplateRequest deleteWhatsAppMessageTemplateRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException,
            InternalServiceException, DependencyException, AwsServiceException, SdkClientException, SocialMessagingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a WhatsApp message template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWhatsAppMessageTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteWhatsAppMessageTemplateRequest#builder()}
     * </p>
     *
     * @param deleteWhatsAppMessageTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.DeleteWhatsAppMessageTemplateRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteWhatsAppMessageTemplate operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.DeleteWhatsAppMessageTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/DeleteWhatsAppMessageTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWhatsAppMessageTemplateResponse deleteWhatsAppMessageTemplate(
            Consumer<DeleteWhatsAppMessageTemplateRequest.Builder> deleteWhatsAppMessageTemplateRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InvalidParametersException,
            ThrottledRequestException, InternalServiceException, DependencyException, AwsServiceException, SdkClientException,
            SocialMessagingException {
        return deleteWhatsAppMessageTemplate(DeleteWhatsAppMessageTemplateRequest.builder()
                .applyMutation(deleteWhatsAppMessageTemplateRequest).build());
    }

    /**
     * <p>
     * Disassociate a WhatsApp Business Account (WABA) from your Amazon Web Services account.
     * </p>
     *
     * @param disassociateWhatsAppBusinessAccountRequest
     * @return Result of the DisassociateWhatsAppBusinessAccount operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.DisassociateWhatsAppBusinessAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/DisassociateWhatsAppBusinessAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateWhatsAppBusinessAccountResponse disassociateWhatsAppBusinessAccount(
            DisassociateWhatsAppBusinessAccountRequest disassociateWhatsAppBusinessAccountRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException,
            DependencyException, AwsServiceException, SdkClientException, SocialMessagingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociate a WhatsApp Business Account (WABA) from your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateWhatsAppBusinessAccountRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateWhatsAppBusinessAccountRequest#builder()}
     * </p>
     *
     * @param disassociateWhatsAppBusinessAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.DisassociateWhatsAppBusinessAccountRequest.Builder}
     *        to create a request.
     * @return Result of the DisassociateWhatsAppBusinessAccount operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.DisassociateWhatsAppBusinessAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/DisassociateWhatsAppBusinessAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateWhatsAppBusinessAccountResponse disassociateWhatsAppBusinessAccount(
            Consumer<DisassociateWhatsAppBusinessAccountRequest.Builder> disassociateWhatsAppBusinessAccountRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InvalidParametersException,
            ThrottledRequestException, DependencyException, AwsServiceException, SdkClientException, SocialMessagingException {
        return disassociateWhatsAppBusinessAccount(DisassociateWhatsAppBusinessAccountRequest.builder()
                .applyMutation(disassociateWhatsAppBusinessAccountRequest).build());
    }

    /**
     * <p>
     * Get the details of your linked WhatsApp Business Account.
     * </p>
     *
     * @param getLinkedWhatsAppBusinessAccountRequest
     * @return Result of the GetLinkedWhatsAppBusinessAccount operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.GetLinkedWhatsAppBusinessAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/GetLinkedWhatsAppBusinessAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLinkedWhatsAppBusinessAccountResponse getLinkedWhatsAppBusinessAccount(
            GetLinkedWhatsAppBusinessAccountRequest getLinkedWhatsAppBusinessAccountRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException,
            InternalServiceException, DependencyException, AwsServiceException, SdkClientException, SocialMessagingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the details of your linked WhatsApp Business Account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLinkedWhatsAppBusinessAccountRequest.Builder}
     * avoiding the need to create one manually via {@link GetLinkedWhatsAppBusinessAccountRequest#builder()}
     * </p>
     *
     * @param getLinkedWhatsAppBusinessAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.GetLinkedWhatsAppBusinessAccountRequest.Builder}
     *        to create a request.
     * @return Result of the GetLinkedWhatsAppBusinessAccount operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.GetLinkedWhatsAppBusinessAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/GetLinkedWhatsAppBusinessAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLinkedWhatsAppBusinessAccountResponse getLinkedWhatsAppBusinessAccount(
            Consumer<GetLinkedWhatsAppBusinessAccountRequest.Builder> getLinkedWhatsAppBusinessAccountRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InvalidParametersException,
            ThrottledRequestException, InternalServiceException, DependencyException, AwsServiceException, SdkClientException,
            SocialMessagingException {
        return getLinkedWhatsAppBusinessAccount(GetLinkedWhatsAppBusinessAccountRequest.builder()
                .applyMutation(getLinkedWhatsAppBusinessAccountRequest).build());
    }

    /**
     * <p>
     * Use your WhatsApp phone number id to get the WABA account id and phone number details.
     * </p>
     *
     * @param getLinkedWhatsAppBusinessAccountPhoneNumberRequest
     * @return Result of the GetLinkedWhatsAppBusinessAccountPhoneNumber operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.GetLinkedWhatsAppBusinessAccountPhoneNumber
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/GetLinkedWhatsAppBusinessAccountPhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLinkedWhatsAppBusinessAccountPhoneNumberResponse getLinkedWhatsAppBusinessAccountPhoneNumber(
            GetLinkedWhatsAppBusinessAccountPhoneNumberRequest getLinkedWhatsAppBusinessAccountPhoneNumberRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InvalidParametersException,
            ThrottledRequestException, InternalServiceException, DependencyException, AwsServiceException, SdkClientException,
            SocialMessagingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use your WhatsApp phone number id to get the WABA account id and phone number details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetLinkedWhatsAppBusinessAccountPhoneNumberRequest.Builder} avoiding the need to create one manually via
     * {@link GetLinkedWhatsAppBusinessAccountPhoneNumberRequest#builder()}
     * </p>
     *
     * @param getLinkedWhatsAppBusinessAccountPhoneNumberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.GetLinkedWhatsAppBusinessAccountPhoneNumberRequest.Builder}
     *        to create a request.
     * @return Result of the GetLinkedWhatsAppBusinessAccountPhoneNumber operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.GetLinkedWhatsAppBusinessAccountPhoneNumber
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/GetLinkedWhatsAppBusinessAccountPhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLinkedWhatsAppBusinessAccountPhoneNumberResponse getLinkedWhatsAppBusinessAccountPhoneNumber(
            Consumer<GetLinkedWhatsAppBusinessAccountPhoneNumberRequest.Builder> getLinkedWhatsAppBusinessAccountPhoneNumberRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InvalidParametersException,
            ThrottledRequestException, InternalServiceException, DependencyException, AwsServiceException, SdkClientException,
            SocialMessagingException {
        return getLinkedWhatsAppBusinessAccountPhoneNumber(GetLinkedWhatsAppBusinessAccountPhoneNumberRequest.builder()
                .applyMutation(getLinkedWhatsAppBusinessAccountPhoneNumberRequest).build());
    }

    /**
     * <p>
     * Get a media file from the WhatsApp service. On successful completion the media file is retrieved from Meta and
     * stored in the specified Amazon S3 bucket. Use either <code>destinationS3File</code> or
     * <code>destinationS3PresignedUrl</code> for the destination. If both are used then an
     * <code>InvalidParameterException</code> is returned.
     * </p>
     *
     * @param getWhatsAppMessageMediaRequest
     * @return Result of the GetWhatsAppMessageMedia operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedByMetaException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.GetWhatsAppMessageMedia
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/GetWhatsAppMessageMedia"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWhatsAppMessageMediaResponse getWhatsAppMessageMedia(GetWhatsAppMessageMediaRequest getWhatsAppMessageMediaRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InvalidParametersException,
            ThrottledRequestException, AccessDeniedByMetaException, InternalServiceException, DependencyException,
            AwsServiceException, SdkClientException, SocialMessagingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a media file from the WhatsApp service. On successful completion the media file is retrieved from Meta and
     * stored in the specified Amazon S3 bucket. Use either <code>destinationS3File</code> or
     * <code>destinationS3PresignedUrl</code> for the destination. If both are used then an
     * <code>InvalidParameterException</code> is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWhatsAppMessageMediaRequest.Builder} avoiding
     * the need to create one manually via {@link GetWhatsAppMessageMediaRequest#builder()}
     * </p>
     *
     * @param getWhatsAppMessageMediaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.GetWhatsAppMessageMediaRequest.Builder} to
     *        create a request.
     * @return Result of the GetWhatsAppMessageMedia operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedByMetaException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.GetWhatsAppMessageMedia
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/GetWhatsAppMessageMedia"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWhatsAppMessageMediaResponse getWhatsAppMessageMedia(
            Consumer<GetWhatsAppMessageMediaRequest.Builder> getWhatsAppMessageMediaRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException,
            AccessDeniedByMetaException, InternalServiceException, DependencyException, AwsServiceException, SdkClientException,
            SocialMessagingException {
        return getWhatsAppMessageMedia(GetWhatsAppMessageMediaRequest.builder().applyMutation(getWhatsAppMessageMediaRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a specific WhatsApp message template.
     * </p>
     *
     * @param getWhatsAppMessageTemplateRequest
     * @return Result of the GetWhatsAppMessageTemplate operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.GetWhatsAppMessageTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/GetWhatsAppMessageTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWhatsAppMessageTemplateResponse getWhatsAppMessageTemplate(
            GetWhatsAppMessageTemplateRequest getWhatsAppMessageTemplateRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException,
            InternalServiceException, DependencyException, AwsServiceException, SdkClientException, SocialMessagingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a specific WhatsApp message template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWhatsAppMessageTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link GetWhatsAppMessageTemplateRequest#builder()}
     * </p>
     *
     * @param getWhatsAppMessageTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.GetWhatsAppMessageTemplateRequest.Builder} to
     *        create a request.
     * @return Result of the GetWhatsAppMessageTemplate operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.GetWhatsAppMessageTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/GetWhatsAppMessageTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWhatsAppMessageTemplateResponse getWhatsAppMessageTemplate(
            Consumer<GetWhatsAppMessageTemplateRequest.Builder> getWhatsAppMessageTemplateRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException,
            InternalServiceException, DependencyException, AwsServiceException, SdkClientException, SocialMessagingException {
        return getWhatsAppMessageTemplate(GetWhatsAppMessageTemplateRequest.builder()
                .applyMutation(getWhatsAppMessageTemplateRequest).build());
    }

    /**
     * <p>
     * List all WhatsApp Business Accounts linked to your Amazon Web Services account.
     * </p>
     *
     * @param listLinkedWhatsAppBusinessAccountsRequest
     * @return Result of the ListLinkedWhatsAppBusinessAccounts operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.ListLinkedWhatsAppBusinessAccounts
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/ListLinkedWhatsAppBusinessAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLinkedWhatsAppBusinessAccountsResponse listLinkedWhatsAppBusinessAccounts(
            ListLinkedWhatsAppBusinessAccountsRequest listLinkedWhatsAppBusinessAccountsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException,
            InternalServiceException, AwsServiceException, SdkClientException, SocialMessagingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all WhatsApp Business Accounts linked to your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLinkedWhatsAppBusinessAccountsRequest.Builder}
     * avoiding the need to create one manually via {@link ListLinkedWhatsAppBusinessAccountsRequest#builder()}
     * </p>
     *
     * @param listLinkedWhatsAppBusinessAccountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsRequest.Builder}
     *        to create a request.
     * @return Result of the ListLinkedWhatsAppBusinessAccounts operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.ListLinkedWhatsAppBusinessAccounts
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/ListLinkedWhatsAppBusinessAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLinkedWhatsAppBusinessAccountsResponse listLinkedWhatsAppBusinessAccounts(
            Consumer<ListLinkedWhatsAppBusinessAccountsRequest.Builder> listLinkedWhatsAppBusinessAccountsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InvalidParametersException,
            ThrottledRequestException, InternalServiceException, AwsServiceException, SdkClientException,
            SocialMessagingException {
        return listLinkedWhatsAppBusinessAccounts(ListLinkedWhatsAppBusinessAccountsRequest.builder()
                .applyMutation(listLinkedWhatsAppBusinessAccountsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLinkedWhatsAppBusinessAccounts(software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.socialmessaging.paginators.ListLinkedWhatsAppBusinessAccountsIterable responses = client.listLinkedWhatsAppBusinessAccountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.socialmessaging.paginators.ListLinkedWhatsAppBusinessAccountsIterable responses = client
     *             .listLinkedWhatsAppBusinessAccountsPaginator(request);
     *     for (software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.socialmessaging.paginators.ListLinkedWhatsAppBusinessAccountsIterable responses = client.listLinkedWhatsAppBusinessAccountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLinkedWhatsAppBusinessAccounts(software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLinkedWhatsAppBusinessAccountsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.ListLinkedWhatsAppBusinessAccounts
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/ListLinkedWhatsAppBusinessAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLinkedWhatsAppBusinessAccountsIterable listLinkedWhatsAppBusinessAccountsPaginator(
            ListLinkedWhatsAppBusinessAccountsRequest listLinkedWhatsAppBusinessAccountsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException,
            InternalServiceException, AwsServiceException, SdkClientException, SocialMessagingException {
        return new ListLinkedWhatsAppBusinessAccountsIterable(this, listLinkedWhatsAppBusinessAccountsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLinkedWhatsAppBusinessAccounts(software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.socialmessaging.paginators.ListLinkedWhatsAppBusinessAccountsIterable responses = client.listLinkedWhatsAppBusinessAccountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.socialmessaging.paginators.ListLinkedWhatsAppBusinessAccountsIterable responses = client
     *             .listLinkedWhatsAppBusinessAccountsPaginator(request);
     *     for (software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.socialmessaging.paginators.ListLinkedWhatsAppBusinessAccountsIterable responses = client.listLinkedWhatsAppBusinessAccountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLinkedWhatsAppBusinessAccounts(software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLinkedWhatsAppBusinessAccountsRequest.Builder}
     * avoiding the need to create one manually via {@link ListLinkedWhatsAppBusinessAccountsRequest#builder()}
     * </p>
     *
     * @param listLinkedWhatsAppBusinessAccountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.ListLinkedWhatsAppBusinessAccounts
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/ListLinkedWhatsAppBusinessAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLinkedWhatsAppBusinessAccountsIterable listLinkedWhatsAppBusinessAccountsPaginator(
            Consumer<ListLinkedWhatsAppBusinessAccountsRequest.Builder> listLinkedWhatsAppBusinessAccountsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InvalidParametersException,
            ThrottledRequestException, InternalServiceException, AwsServiceException, SdkClientException,
            SocialMessagingException {
        return listLinkedWhatsAppBusinessAccountsPaginator(ListLinkedWhatsAppBusinessAccountsRequest.builder()
                .applyMutation(listLinkedWhatsAppBusinessAccountsRequest).build());
    }

    /**
     * <p>
     * List all tags associated with a resource, such as a phone number or WABA.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, AccessDeniedException, InvalidParametersException, ThrottledRequestException,
            InternalServiceException, AwsServiceException, SdkClientException, SocialMessagingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all tags associated with a resource, such as a phone number or WABA.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.ListTagsForResourceRequest.Builder} to create
     *        a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            AccessDeniedException, InvalidParametersException, ThrottledRequestException, InternalServiceException,
            AwsServiceException, SdkClientException, SocialMessagingException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists WhatsApp message templates for a specific WhatsApp Business Account.
     * </p>
     *
     * @param listWhatsAppMessageTemplatesRequest
     * @return Result of the ListWhatsAppMessageTemplates operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.ListWhatsAppMessageTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/ListWhatsAppMessageTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWhatsAppMessageTemplatesResponse listWhatsAppMessageTemplates(
            ListWhatsAppMessageTemplatesRequest listWhatsAppMessageTemplatesRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException,
            InternalServiceException, DependencyException, AwsServiceException, SdkClientException, SocialMessagingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists WhatsApp message templates for a specific WhatsApp Business Account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWhatsAppMessageTemplatesRequest.Builder}
     * avoiding the need to create one manually via {@link ListWhatsAppMessageTemplatesRequest#builder()}
     * </p>
     *
     * @param listWhatsAppMessageTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppMessageTemplatesRequest.Builder}
     *        to create a request.
     * @return Result of the ListWhatsAppMessageTemplates operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.ListWhatsAppMessageTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/ListWhatsAppMessageTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWhatsAppMessageTemplatesResponse listWhatsAppMessageTemplates(
            Consumer<ListWhatsAppMessageTemplatesRequest.Builder> listWhatsAppMessageTemplatesRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InvalidParametersException,
            ThrottledRequestException, InternalServiceException, DependencyException, AwsServiceException, SdkClientException,
            SocialMessagingException {
        return listWhatsAppMessageTemplates(ListWhatsAppMessageTemplatesRequest.builder()
                .applyMutation(listWhatsAppMessageTemplatesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWhatsAppMessageTemplates(software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppMessageTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.socialmessaging.paginators.ListWhatsAppMessageTemplatesIterable responses = client.listWhatsAppMessageTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.socialmessaging.paginators.ListWhatsAppMessageTemplatesIterable responses = client
     *             .listWhatsAppMessageTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppMessageTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.socialmessaging.paginators.ListWhatsAppMessageTemplatesIterable responses = client.listWhatsAppMessageTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWhatsAppMessageTemplates(software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppMessageTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWhatsAppMessageTemplatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.ListWhatsAppMessageTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/ListWhatsAppMessageTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWhatsAppMessageTemplatesIterable listWhatsAppMessageTemplatesPaginator(
            ListWhatsAppMessageTemplatesRequest listWhatsAppMessageTemplatesRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException,
            InternalServiceException, DependencyException, AwsServiceException, SdkClientException, SocialMessagingException {
        return new ListWhatsAppMessageTemplatesIterable(this, listWhatsAppMessageTemplatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWhatsAppMessageTemplates(software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppMessageTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.socialmessaging.paginators.ListWhatsAppMessageTemplatesIterable responses = client.listWhatsAppMessageTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.socialmessaging.paginators.ListWhatsAppMessageTemplatesIterable responses = client
     *             .listWhatsAppMessageTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppMessageTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.socialmessaging.paginators.ListWhatsAppMessageTemplatesIterable responses = client.listWhatsAppMessageTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWhatsAppMessageTemplates(software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppMessageTemplatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWhatsAppMessageTemplatesRequest.Builder}
     * avoiding the need to create one manually via {@link ListWhatsAppMessageTemplatesRequest#builder()}
     * </p>
     *
     * @param listWhatsAppMessageTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppMessageTemplatesRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.ListWhatsAppMessageTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/ListWhatsAppMessageTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWhatsAppMessageTemplatesIterable listWhatsAppMessageTemplatesPaginator(
            Consumer<ListWhatsAppMessageTemplatesRequest.Builder> listWhatsAppMessageTemplatesRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InvalidParametersException,
            ThrottledRequestException, InternalServiceException, DependencyException, AwsServiceException, SdkClientException,
            SocialMessagingException {
        return listWhatsAppMessageTemplatesPaginator(ListWhatsAppMessageTemplatesRequest.builder()
                .applyMutation(listWhatsAppMessageTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists templates available in Meta's template library for WhatsApp messaging.
     * </p>
     *
     * @param listWhatsAppTemplateLibraryRequest
     * @return Result of the ListWhatsAppTemplateLibrary operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.ListWhatsAppTemplateLibrary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/ListWhatsAppTemplateLibrary"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWhatsAppTemplateLibraryResponse listWhatsAppTemplateLibrary(
            ListWhatsAppTemplateLibraryRequest listWhatsAppTemplateLibraryRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException,
            InternalServiceException, DependencyException, AwsServiceException, SdkClientException, SocialMessagingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists templates available in Meta's template library for WhatsApp messaging.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWhatsAppTemplateLibraryRequest.Builder}
     * avoiding the need to create one manually via {@link ListWhatsAppTemplateLibraryRequest#builder()}
     * </p>
     *
     * @param listWhatsAppTemplateLibraryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppTemplateLibraryRequest.Builder}
     *        to create a request.
     * @return Result of the ListWhatsAppTemplateLibrary operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.ListWhatsAppTemplateLibrary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/ListWhatsAppTemplateLibrary"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWhatsAppTemplateLibraryResponse listWhatsAppTemplateLibrary(
            Consumer<ListWhatsAppTemplateLibraryRequest.Builder> listWhatsAppTemplateLibraryRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException,
            InternalServiceException, DependencyException, AwsServiceException, SdkClientException, SocialMessagingException {
        return listWhatsAppTemplateLibrary(ListWhatsAppTemplateLibraryRequest.builder()
                .applyMutation(listWhatsAppTemplateLibraryRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWhatsAppTemplateLibrary(software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppTemplateLibraryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.socialmessaging.paginators.ListWhatsAppTemplateLibraryIterable responses = client.listWhatsAppTemplateLibraryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.socialmessaging.paginators.ListWhatsAppTemplateLibraryIterable responses = client
     *             .listWhatsAppTemplateLibraryPaginator(request);
     *     for (software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppTemplateLibraryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.socialmessaging.paginators.ListWhatsAppTemplateLibraryIterable responses = client.listWhatsAppTemplateLibraryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWhatsAppTemplateLibrary(software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppTemplateLibraryRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWhatsAppTemplateLibraryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.ListWhatsAppTemplateLibrary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/ListWhatsAppTemplateLibrary"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWhatsAppTemplateLibraryIterable listWhatsAppTemplateLibraryPaginator(
            ListWhatsAppTemplateLibraryRequest listWhatsAppTemplateLibraryRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException,
            InternalServiceException, DependencyException, AwsServiceException, SdkClientException, SocialMessagingException {
        return new ListWhatsAppTemplateLibraryIterable(this, listWhatsAppTemplateLibraryRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWhatsAppTemplateLibrary(software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppTemplateLibraryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.socialmessaging.paginators.ListWhatsAppTemplateLibraryIterable responses = client.listWhatsAppTemplateLibraryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.socialmessaging.paginators.ListWhatsAppTemplateLibraryIterable responses = client
     *             .listWhatsAppTemplateLibraryPaginator(request);
     *     for (software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppTemplateLibraryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.socialmessaging.paginators.ListWhatsAppTemplateLibraryIterable responses = client.listWhatsAppTemplateLibraryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWhatsAppTemplateLibrary(software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppTemplateLibraryRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWhatsAppTemplateLibraryRequest.Builder}
     * avoiding the need to create one manually via {@link ListWhatsAppTemplateLibraryRequest#builder()}
     * </p>
     *
     * @param listWhatsAppTemplateLibraryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppTemplateLibraryRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.ListWhatsAppTemplateLibrary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/ListWhatsAppTemplateLibrary"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWhatsAppTemplateLibraryIterable listWhatsAppTemplateLibraryPaginator(
            Consumer<ListWhatsAppTemplateLibraryRequest.Builder> listWhatsAppTemplateLibraryRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException,
            InternalServiceException, DependencyException, AwsServiceException, SdkClientException, SocialMessagingException {
        return listWhatsAppTemplateLibraryPaginator(ListWhatsAppTemplateLibraryRequest.builder()
                .applyMutation(listWhatsAppTemplateLibraryRequest).build());
    }

    /**
     * <p>
     * Upload a media file to the WhatsApp service. Only the specified <code>originationPhoneNumberId</code> has the
     * permissions to send the media file when using <a
     * href="https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_SendWhatsAppMessage.html"
     * >SendWhatsAppMessage</a>. You must use either <code>sourceS3File</code> or <code>sourceS3PresignedUrl</code> for
     * the source. If both or neither are specified then an <code>InvalidParameterException</code> is returned.
     * </p>
     *
     * @param postWhatsAppMessageMediaRequest
     * @return Result of the PostWhatsAppMessageMedia operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedByMetaException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.PostWhatsAppMessageMedia
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/PostWhatsAppMessageMedia"
     *      target="_top">AWS API Documentation</a>
     */
    default PostWhatsAppMessageMediaResponse postWhatsAppMessageMedia(
            PostWhatsAppMessageMediaRequest postWhatsAppMessageMediaRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, InvalidParametersException, ThrottledRequestException, AccessDeniedByMetaException,
            InternalServiceException, DependencyException, AwsServiceException, SdkClientException, SocialMessagingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Upload a media file to the WhatsApp service. Only the specified <code>originationPhoneNumberId</code> has the
     * permissions to send the media file when using <a
     * href="https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_SendWhatsAppMessage.html"
     * >SendWhatsAppMessage</a>. You must use either <code>sourceS3File</code> or <code>sourceS3PresignedUrl</code> for
     * the source. If both or neither are specified then an <code>InvalidParameterException</code> is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PostWhatsAppMessageMediaRequest.Builder} avoiding
     * the need to create one manually via {@link PostWhatsAppMessageMediaRequest#builder()}
     * </p>
     *
     * @param postWhatsAppMessageMediaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.PostWhatsAppMessageMediaRequest.Builder} to
     *        create a request.
     * @return Result of the PostWhatsAppMessageMedia operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedByMetaException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.PostWhatsAppMessageMedia
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/PostWhatsAppMessageMedia"
     *      target="_top">AWS API Documentation</a>
     */
    default PostWhatsAppMessageMediaResponse postWhatsAppMessageMedia(
            Consumer<PostWhatsAppMessageMediaRequest.Builder> postWhatsAppMessageMediaRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException,
            AccessDeniedByMetaException, InternalServiceException, DependencyException, AwsServiceException, SdkClientException,
            SocialMessagingException {
        return postWhatsAppMessageMedia(PostWhatsAppMessageMediaRequest.builder().applyMutation(postWhatsAppMessageMediaRequest)
                .build());
    }

    /**
     * <p>
     * Add an event destination to log event data from WhatsApp for a WhatsApp Business Account (WABA). A WABA can only
     * have one event destination at a time. All resources associated with the WABA use the same event destination.
     * </p>
     *
     * @param putWhatsAppBusinessAccountEventDestinationsRequest
     * @return Result of the PutWhatsAppBusinessAccountEventDestinations operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.PutWhatsAppBusinessAccountEventDestinations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/PutWhatsAppBusinessAccountEventDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default PutWhatsAppBusinessAccountEventDestinationsResponse putWhatsAppBusinessAccountEventDestinations(
            PutWhatsAppBusinessAccountEventDestinationsRequest putWhatsAppBusinessAccountEventDestinationsRequest)
            throws ValidationException, AccessDeniedException, InvalidParametersException, ThrottledRequestException,
            InternalServiceException, AwsServiceException, SdkClientException, SocialMessagingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add an event destination to log event data from WhatsApp for a WhatsApp Business Account (WABA). A WABA can only
     * have one event destination at a time. All resources associated with the WABA use the same event destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutWhatsAppBusinessAccountEventDestinationsRequest.Builder} avoiding the need to create one manually via
     * {@link PutWhatsAppBusinessAccountEventDestinationsRequest#builder()}
     * </p>
     *
     * @param putWhatsAppBusinessAccountEventDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.PutWhatsAppBusinessAccountEventDestinationsRequest.Builder}
     *        to create a request.
     * @return Result of the PutWhatsAppBusinessAccountEventDestinations operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.PutWhatsAppBusinessAccountEventDestinations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/PutWhatsAppBusinessAccountEventDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default PutWhatsAppBusinessAccountEventDestinationsResponse putWhatsAppBusinessAccountEventDestinations(
            Consumer<PutWhatsAppBusinessAccountEventDestinationsRequest.Builder> putWhatsAppBusinessAccountEventDestinationsRequest)
            throws ValidationException, AccessDeniedException, InvalidParametersException, ThrottledRequestException,
            InternalServiceException, AwsServiceException, SdkClientException, SocialMessagingException {
        return putWhatsAppBusinessAccountEventDestinations(PutWhatsAppBusinessAccountEventDestinationsRequest.builder()
                .applyMutation(putWhatsAppBusinessAccountEventDestinationsRequest).build());
    }

    /**
     * <p>
     * Send a WhatsApp message. For examples of sending a message using the Amazon Web Services CLI, see <a
     * href="https://docs.aws.amazon.com/social-messaging/latest/userguide/send-message.html">Sending messages</a> in
     * the <i> <i>Amazon Web Services End User Messaging Social User Guide</i> </i>.
     * </p>
     *
     * @param sendWhatsAppMessageRequest
     * @return Result of the SendWhatsAppMessage operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.SendWhatsAppMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/SendWhatsAppMessage"
     *      target="_top">AWS API Documentation</a>
     */
    default SendWhatsAppMessageResponse sendWhatsAppMessage(SendWhatsAppMessageRequest sendWhatsAppMessageRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InvalidParametersException,
            ThrottledRequestException, InternalServiceException, DependencyException, AwsServiceException, SdkClientException,
            SocialMessagingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Send a WhatsApp message. For examples of sending a message using the Amazon Web Services CLI, see <a
     * href="https://docs.aws.amazon.com/social-messaging/latest/userguide/send-message.html">Sending messages</a> in
     * the <i> <i>Amazon Web Services End User Messaging Social User Guide</i> </i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendWhatsAppMessageRequest.Builder} avoiding the
     * need to create one manually via {@link SendWhatsAppMessageRequest#builder()}
     * </p>
     *
     * @param sendWhatsAppMessageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.SendWhatsAppMessageRequest.Builder} to create
     *        a request.
     * @return Result of the SendWhatsAppMessage operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.SendWhatsAppMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/SendWhatsAppMessage"
     *      target="_top">AWS API Documentation</a>
     */
    default SendWhatsAppMessageResponse sendWhatsAppMessage(
            Consumer<SendWhatsAppMessageRequest.Builder> sendWhatsAppMessageRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException,
            InternalServiceException, DependencyException, AwsServiceException, SdkClientException, SocialMessagingException {
        return sendWhatsAppMessage(SendWhatsAppMessageRequest.builder().applyMutation(sendWhatsAppMessageRequest).build());
    }

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified resource. When you specify an existing tag key, the
     * value is overwritten with the new value.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            AccessDeniedException, InvalidParametersException, ThrottledRequestException, InternalServiceException,
            AwsServiceException, SdkClientException, SocialMessagingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified resource. When you specify an existing tag key, the
     * value is overwritten with the new value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException,
            AccessDeniedException, InvalidParametersException, ThrottledRequestException, InternalServiceException,
            AwsServiceException, SdkClientException, SocialMessagingException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            AccessDeniedException, InvalidParametersException, ThrottledRequestException, InternalServiceException,
            AwsServiceException, SdkClientException, SocialMessagingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, AccessDeniedException, InvalidParametersException, ThrottledRequestException,
            InternalServiceException, AwsServiceException, SdkClientException, SocialMessagingException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing WhatsApp message template.
     * </p>
     *
     * @param updateWhatsAppMessageTemplateRequest
     * @return Result of the UpdateWhatsAppMessageTemplate operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.UpdateWhatsAppMessageTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/UpdateWhatsAppMessageTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWhatsAppMessageTemplateResponse updateWhatsAppMessageTemplate(
            UpdateWhatsAppMessageTemplateRequest updateWhatsAppMessageTemplateRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException,
            InternalServiceException, DependencyException, AwsServiceException, SdkClientException, SocialMessagingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing WhatsApp message template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWhatsAppMessageTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateWhatsAppMessageTemplateRequest#builder()}
     * </p>
     *
     * @param updateWhatsAppMessageTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.socialmessaging.model.UpdateWhatsAppMessageTemplateRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateWhatsAppMessageTemplate operation returned by the service.
     * @throws ValidationException
     *         The request contains an invalid parameter value.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the action are not valid.
     * @throws ThrottledRequestException
     *         The request was denied due to request throttling.
     * @throws InternalServiceException
     *         The request processing has failed because of an unknown error, exception, or failure.
     * @throws DependencyException
     *         Thrown when performing an action because a dependency would be broken.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SocialMessagingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SocialMessagingClient.UpdateWhatsAppMessageTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/UpdateWhatsAppMessageTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWhatsAppMessageTemplateResponse updateWhatsAppMessageTemplate(
            Consumer<UpdateWhatsAppMessageTemplateRequest.Builder> updateWhatsAppMessageTemplateRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InvalidParametersException,
            ThrottledRequestException, InternalServiceException, DependencyException, AwsServiceException, SdkClientException,
            SocialMessagingException {
        return updateWhatsAppMessageTemplate(UpdateWhatsAppMessageTemplateRequest.builder()
                .applyMutation(updateWhatsAppMessageTemplateRequest).build());
    }

    /**
     * Create a {@link SocialMessagingClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SocialMessagingClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SocialMessagingClient}.
     */
    static SocialMessagingClientBuilder builder() {
        return new DefaultSocialMessagingClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default SocialMessagingServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
