/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWhatsAppMessageTemplateResponse extends SocialMessagingResponse implements
        ToCopyableBuilder<CreateWhatsAppMessageTemplateResponse.Builder, CreateWhatsAppMessageTemplateResponse> {
    private static final SdkField<String> META_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metaTemplateId").getter(getter(CreateWhatsAppMessageTemplateResponse::metaTemplateId))
            .setter(setter(Builder::metaTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metaTemplateId").build()).build();

    private static final SdkField<String> TEMPLATE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateStatus").getter(getter(CreateWhatsAppMessageTemplateResponse::templateStatus))
            .setter(setter(Builder::templateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateStatus").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("category").getter(getter(CreateWhatsAppMessageTemplateResponse::category))
            .setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(META_TEMPLATE_ID_FIELD,
            TEMPLATE_STATUS_FIELD, CATEGORY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String metaTemplateId;

    private final String templateStatus;

    private final String category;

    private CreateWhatsAppMessageTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.metaTemplateId = builder.metaTemplateId;
        this.templateStatus = builder.templateStatus;
        this.category = builder.category;
    }

    /**
     * <p>
     * The numeric ID assigned to the template by Meta.
     * </p>
     * 
     * @return The numeric ID assigned to the template by Meta.
     */
    public final String metaTemplateId() {
        return metaTemplateId;
    }

    /**
     * <p>
     * The status of the created template, such as PENDING or APPROVED..
     * </p>
     * 
     * @return The status of the created template, such as PENDING or APPROVED..
     */
    public final String templateStatus() {
        return templateStatus;
    }

    /**
     * <p>
     * The category of the template, such as UTILITY or MARKETING.
     * </p>
     * 
     * @return The category of the template, such as UTILITY or MARKETING.
     */
    public final String category() {
        return category;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metaTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(templateStatus());
        hashCode = 31 * hashCode + Objects.hashCode(category());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWhatsAppMessageTemplateResponse)) {
            return false;
        }
        CreateWhatsAppMessageTemplateResponse other = (CreateWhatsAppMessageTemplateResponse) obj;
        return Objects.equals(metaTemplateId(), other.metaTemplateId())
                && Objects.equals(templateStatus(), other.templateStatus()) && Objects.equals(category(), other.category());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWhatsAppMessageTemplateResponse").add("MetaTemplateId", metaTemplateId())
                .add("TemplateStatus", templateStatus()).add("Category", category()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metaTemplateId":
            return Optional.ofNullable(clazz.cast(metaTemplateId()));
        case "templateStatus":
            return Optional.ofNullable(clazz.cast(templateStatus()));
        case "category":
            return Optional.ofNullable(clazz.cast(category()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("metaTemplateId", META_TEMPLATE_ID_FIELD);
        map.put("templateStatus", TEMPLATE_STATUS_FIELD);
        map.put("category", CATEGORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWhatsAppMessageTemplateResponse, T> g) {
        return obj -> g.apply((CreateWhatsAppMessageTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SocialMessagingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateWhatsAppMessageTemplateResponse> {
        /**
         * <p>
         * The numeric ID assigned to the template by Meta.
         * </p>
         * 
         * @param metaTemplateId
         *        The numeric ID assigned to the template by Meta.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metaTemplateId(String metaTemplateId);

        /**
         * <p>
         * The status of the created template, such as PENDING or APPROVED..
         * </p>
         * 
         * @param templateStatus
         *        The status of the created template, such as PENDING or APPROVED..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateStatus(String templateStatus);

        /**
         * <p>
         * The category of the template, such as UTILITY or MARKETING.
         * </p>
         * 
         * @param category
         *        The category of the template, such as UTILITY or MARKETING.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(String category);
    }

    static final class BuilderImpl extends SocialMessagingResponse.BuilderImpl implements Builder {
        private String metaTemplateId;

        private String templateStatus;

        private String category;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWhatsAppMessageTemplateResponse model) {
            super(model);
            metaTemplateId(model.metaTemplateId);
            templateStatus(model.templateStatus);
            category(model.category);
        }

        public final String getMetaTemplateId() {
            return metaTemplateId;
        }

        public final void setMetaTemplateId(String metaTemplateId) {
            this.metaTemplateId = metaTemplateId;
        }

        @Override
        public final Builder metaTemplateId(String metaTemplateId) {
            this.metaTemplateId = metaTemplateId;
            return this;
        }

        public final String getTemplateStatus() {
            return templateStatus;
        }

        public final void setTemplateStatus(String templateStatus) {
            this.templateStatus = templateStatus;
        }

        @Override
        public final Builder templateStatus(String templateStatus) {
            this.templateStatus = templateStatus;
            return this;
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public CreateWhatsAppMessageTemplateResponse build() {
            return new CreateWhatsAppMessageTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
