/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteWhatsAppMessageMediaRequest extends SocialMessagingRequest implements
        ToCopyableBuilder<DeleteWhatsAppMessageMediaRequest.Builder, DeleteWhatsAppMessageMediaRequest> {
    private static final SdkField<String> MEDIA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mediaId").getter(getter(DeleteWhatsAppMessageMediaRequest::mediaId)).setter(setter(Builder::mediaId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("mediaId").build()).build();

    private static final SdkField<String> ORIGINATION_PHONE_NUMBER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("originationPhoneNumberId")
            .getter(getter(DeleteWhatsAppMessageMediaRequest::originationPhoneNumberId))
            .setter(setter(Builder::originationPhoneNumberId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("originationPhoneNumberId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_ID_FIELD,
            ORIGINATION_PHONE_NUMBER_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String mediaId;

    private final String originationPhoneNumberId;

    private DeleteWhatsAppMessageMediaRequest(BuilderImpl builder) {
        super(builder);
        this.mediaId = builder.mediaId;
        this.originationPhoneNumberId = builder.originationPhoneNumberId;
    }

    /**
     * <p>
     * The unique identifier of the media file to delete. Use the <code>mediaId</code> returned from <a
     * href="https://console.aws.amazon.com/social-messaging/latest/APIReference/API_PostWhatsAppMessageMedia.html"
     * >PostWhatsAppMessageMedia</a>.
     * </p>
     * 
     * @return The unique identifier of the media file to delete. Use the <code>mediaId</code> returned from <a
     *         href="https://console.aws.amazon.com/social-messaging/latest/APIReference/API_PostWhatsAppMessageMedia.html"
     *         >PostWhatsAppMessageMedia</a>.
     */
    public final String mediaId() {
        return mediaId;
    }

    /**
     * <p>
     * The unique identifier of the originating phone number associated with the media. Phone number identifiers are
     * formatted as <code>phone-number-id-01234567890123456789012345678901</code>. Use <a href=
     * "https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetLinkedWhatsAppBusinessAccountPhoneNumber.html"
     * >GetLinkedWhatsAppBusinessAccount</a> to find a phone number's id.
     * </p>
     * 
     * @return The unique identifier of the originating phone number associated with the media. Phone number identifiers
     *         are formatted as <code>phone-number-id-01234567890123456789012345678901</code>. Use <a href=
     *         "https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetLinkedWhatsAppBusinessAccountPhoneNumber.html"
     *         >GetLinkedWhatsAppBusinessAccount</a> to find a phone number's id.
     */
    public final String originationPhoneNumberId() {
        return originationPhoneNumberId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mediaId());
        hashCode = 31 * hashCode + Objects.hashCode(originationPhoneNumberId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteWhatsAppMessageMediaRequest)) {
            return false;
        }
        DeleteWhatsAppMessageMediaRequest other = (DeleteWhatsAppMessageMediaRequest) obj;
        return Objects.equals(mediaId(), other.mediaId())
                && Objects.equals(originationPhoneNumberId(), other.originationPhoneNumberId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteWhatsAppMessageMediaRequest").add("MediaId", mediaId())
                .add("OriginationPhoneNumberId", originationPhoneNumberId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mediaId":
            return Optional.ofNullable(clazz.cast(mediaId()));
        case "originationPhoneNumberId":
            return Optional.ofNullable(clazz.cast(originationPhoneNumberId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("mediaId", MEDIA_ID_FIELD);
        map.put("originationPhoneNumberId", ORIGINATION_PHONE_NUMBER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteWhatsAppMessageMediaRequest, T> g) {
        return obj -> g.apply((DeleteWhatsAppMessageMediaRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SocialMessagingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteWhatsAppMessageMediaRequest> {
        /**
         * <p>
         * The unique identifier of the media file to delete. Use the <code>mediaId</code> returned from <a href=
         * "https://console.aws.amazon.com/social-messaging/latest/APIReference/API_PostWhatsAppMessageMedia.html"
         * >PostWhatsAppMessageMedia</a>.
         * </p>
         * 
         * @param mediaId
         *        The unique identifier of the media file to delete. Use the <code>mediaId</code> returned from <a href=
         *        "https://console.aws.amazon.com/social-messaging/latest/APIReference/API_PostWhatsAppMessageMedia.html"
         *        >PostWhatsAppMessageMedia</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaId(String mediaId);

        /**
         * <p>
         * The unique identifier of the originating phone number associated with the media. Phone number identifiers are
         * formatted as <code>phone-number-id-01234567890123456789012345678901</code>. Use <a href=
         * "https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetLinkedWhatsAppBusinessAccountPhoneNumber.html"
         * >GetLinkedWhatsAppBusinessAccount</a> to find a phone number's id.
         * </p>
         * 
         * @param originationPhoneNumberId
         *        The unique identifier of the originating phone number associated with the media. Phone number
         *        identifiers are formatted as <code>phone-number-id-01234567890123456789012345678901</code>. Use <a
         *        href=
         *        "https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetLinkedWhatsAppBusinessAccountPhoneNumber.html"
         *        >GetLinkedWhatsAppBusinessAccount</a> to find a phone number's id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originationPhoneNumberId(String originationPhoneNumberId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SocialMessagingRequest.BuilderImpl implements Builder {
        private String mediaId;

        private String originationPhoneNumberId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteWhatsAppMessageMediaRequest model) {
            super(model);
            mediaId(model.mediaId);
            originationPhoneNumberId(model.originationPhoneNumberId);
        }

        public final String getMediaId() {
            return mediaId;
        }

        public final void setMediaId(String mediaId) {
            this.mediaId = mediaId;
        }

        @Override
        public final Builder mediaId(String mediaId) {
            this.mediaId = mediaId;
            return this;
        }

        public final String getOriginationPhoneNumberId() {
            return originationPhoneNumberId;
        }

        public final void setOriginationPhoneNumberId(String originationPhoneNumberId) {
            this.originationPhoneNumberId = originationPhoneNumberId;
        }

        @Override
        public final Builder originationPhoneNumberId(String originationPhoneNumberId) {
            this.originationPhoneNumberId = originationPhoneNumberId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteWhatsAppMessageMediaRequest build() {
            return new DeleteWhatsAppMessageMediaRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
