/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains your WhatsApp registration status and details of any unregistered WhatsApp phone number.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LinkedWhatsAppBusinessAccountIdMetaData implements SdkPojo, Serializable,
        ToCopyableBuilder<LinkedWhatsAppBusinessAccountIdMetaData.Builder, LinkedWhatsAppBusinessAccountIdMetaData> {
    private static final SdkField<String> ACCOUNT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountName").getter(getter(LinkedWhatsAppBusinessAccountIdMetaData::accountName))
            .setter(setter(Builder::accountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountName").build()).build();

    private static final SdkField<String> REGISTRATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registrationStatus").getter(getter(LinkedWhatsAppBusinessAccountIdMetaData::registrationStatusAsString))
            .setter(setter(Builder::registrationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationStatus").build())
            .build();

    private static final SdkField<List<WhatsAppPhoneNumberDetail>> UNREGISTERED_WHATS_APP_PHONE_NUMBERS_FIELD = SdkField
            .<List<WhatsAppPhoneNumberDetail>> builder(MarshallingType.LIST)
            .memberName("unregisteredWhatsAppPhoneNumbers")
            .getter(getter(LinkedWhatsAppBusinessAccountIdMetaData::unregisteredWhatsAppPhoneNumbers))
            .setter(setter(Builder::unregisteredWhatsAppPhoneNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unregisteredWhatsAppPhoneNumbers")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WhatsAppPhoneNumberDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(WhatsAppPhoneNumberDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WABA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("wabaId")
            .getter(getter(LinkedWhatsAppBusinessAccountIdMetaData::wabaId)).setter(setter(Builder::wabaId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wabaId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_NAME_FIELD,
            REGISTRATION_STATUS_FIELD, UNREGISTERED_WHATS_APP_PHONE_NUMBERS_FIELD, WABA_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountName;

    private final String registrationStatus;

    private final List<WhatsAppPhoneNumberDetail> unregisteredWhatsAppPhoneNumbers;

    private final String wabaId;

    private LinkedWhatsAppBusinessAccountIdMetaData(BuilderImpl builder) {
        this.accountName = builder.accountName;
        this.registrationStatus = builder.registrationStatus;
        this.unregisteredWhatsAppPhoneNumbers = builder.unregisteredWhatsAppPhoneNumbers;
        this.wabaId = builder.wabaId;
    }

    /**
     * <p>
     * The name of your account.
     * </p>
     * 
     * @return The name of your account.
     */
    public final String accountName() {
        return accountName;
    }

    /**
     * <p>
     * The registration status of the linked WhatsApp Business Account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #registrationStatus} will return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #registrationStatusAsString}.
     * </p>
     * 
     * @return The registration status of the linked WhatsApp Business Account.
     * @see RegistrationStatus
     */
    public final RegistrationStatus registrationStatus() {
        return RegistrationStatus.fromValue(registrationStatus);
    }

    /**
     * <p>
     * The registration status of the linked WhatsApp Business Account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #registrationStatus} will return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #registrationStatusAsString}.
     * </p>
     * 
     * @return The registration status of the linked WhatsApp Business Account.
     * @see RegistrationStatus
     */
    public final String registrationStatusAsString() {
        return registrationStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnregisteredWhatsAppPhoneNumbers
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasUnregisteredWhatsAppPhoneNumbers() {
        return unregisteredWhatsAppPhoneNumbers != null && !(unregisteredWhatsAppPhoneNumbers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details for unregistered WhatsApp phone numbers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnregisteredWhatsAppPhoneNumbers}
     * method.
     * </p>
     * 
     * @return The details for unregistered WhatsApp phone numbers.
     */
    public final List<WhatsAppPhoneNumberDetail> unregisteredWhatsAppPhoneNumbers() {
        return unregisteredWhatsAppPhoneNumbers;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the WhatsApp Business Account ID.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the WhatsApp Business Account ID.
     */
    public final String wabaId() {
        return wabaId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountName());
        hashCode = 31 * hashCode + Objects.hashCode(registrationStatusAsString());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasUnregisteredWhatsAppPhoneNumbers() ? unregisteredWhatsAppPhoneNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(wabaId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinkedWhatsAppBusinessAccountIdMetaData)) {
            return false;
        }
        LinkedWhatsAppBusinessAccountIdMetaData other = (LinkedWhatsAppBusinessAccountIdMetaData) obj;
        return Objects.equals(accountName(), other.accountName())
                && Objects.equals(registrationStatusAsString(), other.registrationStatusAsString())
                && hasUnregisteredWhatsAppPhoneNumbers() == other.hasUnregisteredWhatsAppPhoneNumbers()
                && Objects.equals(unregisteredWhatsAppPhoneNumbers(), other.unregisteredWhatsAppPhoneNumbers())
                && Objects.equals(wabaId(), other.wabaId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("LinkedWhatsAppBusinessAccountIdMetaData")
                .add("AccountName", accountName())
                .add("RegistrationStatus", registrationStatusAsString())
                .add("UnregisteredWhatsAppPhoneNumbers",
                        hasUnregisteredWhatsAppPhoneNumbers() ? unregisteredWhatsAppPhoneNumbers() : null)
                .add("WabaId", wabaId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountName":
            return Optional.ofNullable(clazz.cast(accountName()));
        case "registrationStatus":
            return Optional.ofNullable(clazz.cast(registrationStatusAsString()));
        case "unregisteredWhatsAppPhoneNumbers":
            return Optional.ofNullable(clazz.cast(unregisteredWhatsAppPhoneNumbers()));
        case "wabaId":
            return Optional.ofNullable(clazz.cast(wabaId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountName", ACCOUNT_NAME_FIELD);
        map.put("registrationStatus", REGISTRATION_STATUS_FIELD);
        map.put("unregisteredWhatsAppPhoneNumbers", UNREGISTERED_WHATS_APP_PHONE_NUMBERS_FIELD);
        map.put("wabaId", WABA_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LinkedWhatsAppBusinessAccountIdMetaData, T> g) {
        return obj -> g.apply((LinkedWhatsAppBusinessAccountIdMetaData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LinkedWhatsAppBusinessAccountIdMetaData> {
        /**
         * <p>
         * The name of your account.
         * </p>
         * 
         * @param accountName
         *        The name of your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountName(String accountName);

        /**
         * <p>
         * The registration status of the linked WhatsApp Business Account.
         * </p>
         * 
         * @param registrationStatus
         *        The registration status of the linked WhatsApp Business Account.
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder registrationStatus(String registrationStatus);

        /**
         * <p>
         * The registration status of the linked WhatsApp Business Account.
         * </p>
         * 
         * @param registrationStatus
         *        The registration status of the linked WhatsApp Business Account.
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder registrationStatus(RegistrationStatus registrationStatus);

        /**
         * <p>
         * The details for unregistered WhatsApp phone numbers.
         * </p>
         * 
         * @param unregisteredWhatsAppPhoneNumbers
         *        The details for unregistered WhatsApp phone numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unregisteredWhatsAppPhoneNumbers(Collection<WhatsAppPhoneNumberDetail> unregisteredWhatsAppPhoneNumbers);

        /**
         * <p>
         * The details for unregistered WhatsApp phone numbers.
         * </p>
         * 
         * @param unregisteredWhatsAppPhoneNumbers
         *        The details for unregistered WhatsApp phone numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unregisteredWhatsAppPhoneNumbers(WhatsAppPhoneNumberDetail... unregisteredWhatsAppPhoneNumbers);

        /**
         * <p>
         * The details for unregistered WhatsApp phone numbers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.socialmessaging.model.WhatsAppPhoneNumberDetail.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.socialmessaging.model.WhatsAppPhoneNumberDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.socialmessaging.model.WhatsAppPhoneNumberDetail.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #unregisteredWhatsAppPhoneNumbers(List<WhatsAppPhoneNumberDetail>)}.
         * 
         * @param unregisteredWhatsAppPhoneNumbers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.socialmessaging.model.WhatsAppPhoneNumberDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unregisteredWhatsAppPhoneNumbers(java.util.Collection<WhatsAppPhoneNumberDetail>)
         */
        Builder unregisteredWhatsAppPhoneNumbers(Consumer<WhatsAppPhoneNumberDetail.Builder>... unregisteredWhatsAppPhoneNumbers);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the WhatsApp Business Account ID.
         * </p>
         * 
         * @param wabaId
         *        The Amazon Resource Name (ARN) of the WhatsApp Business Account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wabaId(String wabaId);
    }

    static final class BuilderImpl implements Builder {
        private String accountName;

        private String registrationStatus;

        private List<WhatsAppPhoneNumberDetail> unregisteredWhatsAppPhoneNumbers = DefaultSdkAutoConstructList.getInstance();

        private String wabaId;

        private BuilderImpl() {
        }

        private BuilderImpl(LinkedWhatsAppBusinessAccountIdMetaData model) {
            accountName(model.accountName);
            registrationStatus(model.registrationStatus);
            unregisteredWhatsAppPhoneNumbers(model.unregisteredWhatsAppPhoneNumbers);
            wabaId(model.wabaId);
        }

        public final String getAccountName() {
            return accountName;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public final String getRegistrationStatus() {
            return registrationStatus;
        }

        public final void setRegistrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
        }

        @Override
        public final Builder registrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
            return this;
        }

        @Override
        public final Builder registrationStatus(RegistrationStatus registrationStatus) {
            this.registrationStatus(registrationStatus == null ? null : registrationStatus.toString());
            return this;
        }

        public final List<WhatsAppPhoneNumberDetail.Builder> getUnregisteredWhatsAppPhoneNumbers() {
            List<WhatsAppPhoneNumberDetail.Builder> result = WhatsAppPhoneNumberDetailListCopier
                    .copyToBuilder(this.unregisteredWhatsAppPhoneNumbers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnregisteredWhatsAppPhoneNumbers(
                Collection<WhatsAppPhoneNumberDetail.BuilderImpl> unregisteredWhatsAppPhoneNumbers) {
            this.unregisteredWhatsAppPhoneNumbers = WhatsAppPhoneNumberDetailListCopier
                    .copyFromBuilder(unregisteredWhatsAppPhoneNumbers);
        }

        @Override
        public final Builder unregisteredWhatsAppPhoneNumbers(
                Collection<WhatsAppPhoneNumberDetail> unregisteredWhatsAppPhoneNumbers) {
            this.unregisteredWhatsAppPhoneNumbers = WhatsAppPhoneNumberDetailListCopier.copy(unregisteredWhatsAppPhoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unregisteredWhatsAppPhoneNumbers(WhatsAppPhoneNumberDetail... unregisteredWhatsAppPhoneNumbers) {
            unregisteredWhatsAppPhoneNumbers(Arrays.asList(unregisteredWhatsAppPhoneNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unregisteredWhatsAppPhoneNumbers(
                Consumer<WhatsAppPhoneNumberDetail.Builder>... unregisteredWhatsAppPhoneNumbers) {
            unregisteredWhatsAppPhoneNumbers(Stream.of(unregisteredWhatsAppPhoneNumbers)
                    .map(c -> WhatsAppPhoneNumberDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getWabaId() {
            return wabaId;
        }

        public final void setWabaId(String wabaId) {
            this.wabaId = wabaId;
        }

        @Override
        public final Builder wabaId(String wabaId) {
            this.wabaId = wabaId;
            return this;
        }

        @Override
        public LinkedWhatsAppBusinessAccountIdMetaData build() {
            return new LinkedWhatsAppBusinessAccountIdMetaData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
