/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLinkedWhatsAppBusinessAccountsResponse extends SocialMessagingResponse implements
        ToCopyableBuilder<ListLinkedWhatsAppBusinessAccountsResponse.Builder, ListLinkedWhatsAppBusinessAccountsResponse> {
    private static final SdkField<List<LinkedWhatsAppBusinessAccountSummary>> LINKED_ACCOUNTS_FIELD = SdkField
            .<List<LinkedWhatsAppBusinessAccountSummary>> builder(MarshallingType.LIST)
            .memberName("linkedAccounts")
            .getter(getter(ListLinkedWhatsAppBusinessAccountsResponse::linkedAccounts))
            .setter(setter(Builder::linkedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linkedAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LinkedWhatsAppBusinessAccountSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(LinkedWhatsAppBusinessAccountSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListLinkedWhatsAppBusinessAccountsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINKED_ACCOUNTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<LinkedWhatsAppBusinessAccountSummary> linkedAccounts;

    private final String nextToken;

    private ListLinkedWhatsAppBusinessAccountsResponse(BuilderImpl builder) {
        super(builder);
        this.linkedAccounts = builder.linkedAccounts;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the LinkedAccounts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLinkedAccounts() {
        return linkedAccounts != null && !(linkedAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of WhatsApp Business Accounts linked to your Amazon Web Services account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLinkedAccounts} method.
     * </p>
     * 
     * @return A list of WhatsApp Business Accounts linked to your Amazon Web Services account.
     */
    public final List<LinkedWhatsAppBusinessAccountSummary> linkedAccounts() {
        return linkedAccounts;
    }

    /**
     * <p>
     * The next token for pagination.
     * </p>
     * 
     * @return The next token for pagination.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLinkedAccounts() ? linkedAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLinkedWhatsAppBusinessAccountsResponse)) {
            return false;
        }
        ListLinkedWhatsAppBusinessAccountsResponse other = (ListLinkedWhatsAppBusinessAccountsResponse) obj;
        return hasLinkedAccounts() == other.hasLinkedAccounts() && Objects.equals(linkedAccounts(), other.linkedAccounts())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLinkedWhatsAppBusinessAccountsResponse")
                .add("LinkedAccounts", hasLinkedAccounts() ? linkedAccounts() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "linkedAccounts":
            return Optional.ofNullable(clazz.cast(linkedAccounts()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("linkedAccounts", LINKED_ACCOUNTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLinkedWhatsAppBusinessAccountsResponse, T> g) {
        return obj -> g.apply((ListLinkedWhatsAppBusinessAccountsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SocialMessagingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListLinkedWhatsAppBusinessAccountsResponse> {
        /**
         * <p>
         * A list of WhatsApp Business Accounts linked to your Amazon Web Services account.
         * </p>
         * 
         * @param linkedAccounts
         *        A list of WhatsApp Business Accounts linked to your Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkedAccounts(Collection<LinkedWhatsAppBusinessAccountSummary> linkedAccounts);

        /**
         * <p>
         * A list of WhatsApp Business Accounts linked to your Amazon Web Services account.
         * </p>
         * 
         * @param linkedAccounts
         *        A list of WhatsApp Business Accounts linked to your Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkedAccounts(LinkedWhatsAppBusinessAccountSummary... linkedAccounts);

        /**
         * <p>
         * A list of WhatsApp Business Accounts linked to your Amazon Web Services account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.socialmessaging.model.LinkedWhatsAppBusinessAccountSummary.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.socialmessaging.model.LinkedWhatsAppBusinessAccountSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.socialmessaging.model.LinkedWhatsAppBusinessAccountSummary.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #linkedAccounts(List<LinkedWhatsAppBusinessAccountSummary>)}.
         * 
         * @param linkedAccounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.socialmessaging.model.LinkedWhatsAppBusinessAccountSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #linkedAccounts(java.util.Collection<LinkedWhatsAppBusinessAccountSummary>)
         */
        Builder linkedAccounts(Consumer<LinkedWhatsAppBusinessAccountSummary.Builder>... linkedAccounts);

        /**
         * <p>
         * The next token for pagination.
         * </p>
         * 
         * @param nextToken
         *        The next token for pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SocialMessagingResponse.BuilderImpl implements Builder {
        private List<LinkedWhatsAppBusinessAccountSummary> linkedAccounts = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLinkedWhatsAppBusinessAccountsResponse model) {
            super(model);
            linkedAccounts(model.linkedAccounts);
            nextToken(model.nextToken);
        }

        public final List<LinkedWhatsAppBusinessAccountSummary.Builder> getLinkedAccounts() {
            List<LinkedWhatsAppBusinessAccountSummary.Builder> result = LinkedWhatsAppBusinessAccountSummaryListCopier
                    .copyToBuilder(this.linkedAccounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLinkedAccounts(Collection<LinkedWhatsAppBusinessAccountSummary.BuilderImpl> linkedAccounts) {
            this.linkedAccounts = LinkedWhatsAppBusinessAccountSummaryListCopier.copyFromBuilder(linkedAccounts);
        }

        @Override
        public final Builder linkedAccounts(Collection<LinkedWhatsAppBusinessAccountSummary> linkedAccounts) {
            this.linkedAccounts = LinkedWhatsAppBusinessAccountSummaryListCopier.copy(linkedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkedAccounts(LinkedWhatsAppBusinessAccountSummary... linkedAccounts) {
            linkedAccounts(Arrays.asList(linkedAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkedAccounts(Consumer<LinkedWhatsAppBusinessAccountSummary.Builder>... linkedAccounts) {
            linkedAccounts(Stream.of(linkedAccounts)
                    .map(c -> LinkedWhatsAppBusinessAccountSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLinkedWhatsAppBusinessAccountsResponse build() {
            return new ListLinkedWhatsAppBusinessAccountsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
