/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the complete structure and content of a template in Meta's library.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetaLibraryTemplateDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<MetaLibraryTemplateDefinition.Builder, MetaLibraryTemplateDefinition> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateName").getter(getter(MetaLibraryTemplateDefinition::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()).build();

    private static final SdkField<String> TEMPLATE_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateLanguage").getter(getter(MetaLibraryTemplateDefinition::templateLanguage))
            .setter(setter(Builder::templateLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateLanguage").build()).build();

    private static final SdkField<String> TEMPLATE_CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateCategory").getter(getter(MetaLibraryTemplateDefinition::templateCategory))
            .setter(setter(Builder::templateCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateCategory").build()).build();

    private static final SdkField<String> TEMPLATE_TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateTopic").getter(getter(MetaLibraryTemplateDefinition::templateTopic))
            .setter(setter(Builder::templateTopic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateTopic").build()).build();

    private static final SdkField<String> TEMPLATE_USE_CASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateUseCase").getter(getter(MetaLibraryTemplateDefinition::templateUseCase))
            .setter(setter(Builder::templateUseCase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateUseCase").build()).build();

    private static final SdkField<List<String>> TEMPLATE_INDUSTRY_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("templateIndustry")
            .getter(getter(MetaLibraryTemplateDefinition::templateIndustry))
            .setter(setter(Builder::templateIndustry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateIndustry").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TEMPLATE_HEADER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateHeader").getter(getter(MetaLibraryTemplateDefinition::templateHeader))
            .setter(setter(Builder::templateHeader))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateHeader").build()).build();

    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateBody").getter(getter(MetaLibraryTemplateDefinition::templateBody))
            .setter(setter(Builder::templateBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateBody").build()).build();

    private static final SdkField<List<LibraryTemplateButtonList>> TEMPLATE_BUTTONS_FIELD = SdkField
            .<List<LibraryTemplateButtonList>> builder(MarshallingType.LIST)
            .memberName("templateButtons")
            .getter(getter(MetaLibraryTemplateDefinition::templateButtons))
            .setter(setter(Builder::templateButtons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateButtons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LibraryTemplateButtonList> builder(MarshallingType.SDK_POJO)
                                            .constructor(LibraryTemplateButtonList::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateId").getter(getter(MetaLibraryTemplateDefinition::templateId))
            .setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD,
            TEMPLATE_LANGUAGE_FIELD, TEMPLATE_CATEGORY_FIELD, TEMPLATE_TOPIC_FIELD, TEMPLATE_USE_CASE_FIELD,
            TEMPLATE_INDUSTRY_FIELD, TEMPLATE_HEADER_FIELD, TEMPLATE_BODY_FIELD, TEMPLATE_BUTTONS_FIELD, TEMPLATE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String templateName;

    private final String templateLanguage;

    private final String templateCategory;

    private final String templateTopic;

    private final String templateUseCase;

    private final List<String> templateIndustry;

    private final String templateHeader;

    private final String templateBody;

    private final List<LibraryTemplateButtonList> templateButtons;

    private final String templateId;

    private MetaLibraryTemplateDefinition(BuilderImpl builder) {
        this.templateName = builder.templateName;
        this.templateLanguage = builder.templateLanguage;
        this.templateCategory = builder.templateCategory;
        this.templateTopic = builder.templateTopic;
        this.templateUseCase = builder.templateUseCase;
        this.templateIndustry = builder.templateIndustry;
        this.templateHeader = builder.templateHeader;
        this.templateBody = builder.templateBody;
        this.templateButtons = builder.templateButtons;
        this.templateId = builder.templateId;
    }

    /**
     * <p>
     * The name of the template.
     * </p>
     * 
     * @return The name of the template.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The language code for the template (for example, en_US).
     * </p>
     * 
     * @return The language code for the template (for example, en_US).
     */
    public final String templateLanguage() {
        return templateLanguage;
    }

    /**
     * <p>
     * The category of the template (for example, UTILITY or MARKETING).
     * </p>
     * 
     * @return The category of the template (for example, UTILITY or MARKETING).
     */
    public final String templateCategory() {
        return templateCategory;
    }

    /**
     * <p>
     * The topic or subject matter of the template.
     * </p>
     * 
     * @return The topic or subject matter of the template.
     */
    public final String templateTopic() {
        return templateTopic;
    }

    /**
     * <p>
     * The intended use case for the template.
     * </p>
     * 
     * @return The intended use case for the template.
     */
    public final String templateUseCase() {
        return templateUseCase;
    }

    /**
     * For responses, this returns true if the service returned a value for the TemplateIndustry property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTemplateIndustry() {
        return templateIndustry != null && !(templateIndustry instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The industries the template is designed for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTemplateIndustry} method.
     * </p>
     * 
     * @return The industries the template is designed for.
     */
    public final List<String> templateIndustry() {
        return templateIndustry;
    }

    /**
     * <p>
     * The header text of the template.
     * </p>
     * 
     * @return The header text of the template.
     */
    public final String templateHeader() {
        return templateHeader;
    }

    /**
     * <p>
     * The body text of the template.
     * </p>
     * 
     * @return The body text of the template.
     */
    public final String templateBody() {
        return templateBody;
    }

    /**
     * For responses, this returns true if the service returned a value for the TemplateButtons property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTemplateButtons() {
        return templateButtons != null && !(templateButtons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The buttons included in the template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTemplateButtons} method.
     * </p>
     * 
     * @return The buttons included in the template.
     */
    public final List<LibraryTemplateButtonList> templateButtons() {
        return templateButtons;
    }

    /**
     * <p>
     * The ID of the template in Meta's library.
     * </p>
     * 
     * @return The ID of the template in Meta's library.
     */
    public final String templateId() {
        return templateId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(templateLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(templateCategory());
        hashCode = 31 * hashCode + Objects.hashCode(templateTopic());
        hashCode = 31 * hashCode + Objects.hashCode(templateUseCase());
        hashCode = 31 * hashCode + Objects.hashCode(hasTemplateIndustry() ? templateIndustry() : null);
        hashCode = 31 * hashCode + Objects.hashCode(templateHeader());
        hashCode = 31 * hashCode + Objects.hashCode(templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(hasTemplateButtons() ? templateButtons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetaLibraryTemplateDefinition)) {
            return false;
        }
        MetaLibraryTemplateDefinition other = (MetaLibraryTemplateDefinition) obj;
        return Objects.equals(templateName(), other.templateName())
                && Objects.equals(templateLanguage(), other.templateLanguage())
                && Objects.equals(templateCategory(), other.templateCategory())
                && Objects.equals(templateTopic(), other.templateTopic())
                && Objects.equals(templateUseCase(), other.templateUseCase())
                && hasTemplateIndustry() == other.hasTemplateIndustry()
                && Objects.equals(templateIndustry(), other.templateIndustry())
                && Objects.equals(templateHeader(), other.templateHeader())
                && Objects.equals(templateBody(), other.templateBody()) && hasTemplateButtons() == other.hasTemplateButtons()
                && Objects.equals(templateButtons(), other.templateButtons()) && Objects.equals(templateId(), other.templateId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetaLibraryTemplateDefinition").add("TemplateName", templateName())
                .add("TemplateLanguage", templateLanguage()).add("TemplateCategory", templateCategory())
                .add("TemplateTopic", templateTopic()).add("TemplateUseCase", templateUseCase())
                .add("TemplateIndustry", hasTemplateIndustry() ? templateIndustry() : null)
                .add("TemplateHeader", templateHeader()).add("TemplateBody", templateBody())
                .add("TemplateButtons", hasTemplateButtons() ? templateButtons() : null).add("TemplateId", templateId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "templateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "templateLanguage":
            return Optional.ofNullable(clazz.cast(templateLanguage()));
        case "templateCategory":
            return Optional.ofNullable(clazz.cast(templateCategory()));
        case "templateTopic":
            return Optional.ofNullable(clazz.cast(templateTopic()));
        case "templateUseCase":
            return Optional.ofNullable(clazz.cast(templateUseCase()));
        case "templateIndustry":
            return Optional.ofNullable(clazz.cast(templateIndustry()));
        case "templateHeader":
            return Optional.ofNullable(clazz.cast(templateHeader()));
        case "templateBody":
            return Optional.ofNullable(clazz.cast(templateBody()));
        case "templateButtons":
            return Optional.ofNullable(clazz.cast(templateButtons()));
        case "templateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("templateName", TEMPLATE_NAME_FIELD);
        map.put("templateLanguage", TEMPLATE_LANGUAGE_FIELD);
        map.put("templateCategory", TEMPLATE_CATEGORY_FIELD);
        map.put("templateTopic", TEMPLATE_TOPIC_FIELD);
        map.put("templateUseCase", TEMPLATE_USE_CASE_FIELD);
        map.put("templateIndustry", TEMPLATE_INDUSTRY_FIELD);
        map.put("templateHeader", TEMPLATE_HEADER_FIELD);
        map.put("templateBody", TEMPLATE_BODY_FIELD);
        map.put("templateButtons", TEMPLATE_BUTTONS_FIELD);
        map.put("templateId", TEMPLATE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetaLibraryTemplateDefinition, T> g) {
        return obj -> g.apply((MetaLibraryTemplateDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetaLibraryTemplateDefinition> {
        /**
         * <p>
         * The name of the template.
         * </p>
         * 
         * @param templateName
         *        The name of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The language code for the template (for example, en_US).
         * </p>
         * 
         * @param templateLanguage
         *        The language code for the template (for example, en_US).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateLanguage(String templateLanguage);

        /**
         * <p>
         * The category of the template (for example, UTILITY or MARKETING).
         * </p>
         * 
         * @param templateCategory
         *        The category of the template (for example, UTILITY or MARKETING).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateCategory(String templateCategory);

        /**
         * <p>
         * The topic or subject matter of the template.
         * </p>
         * 
         * @param templateTopic
         *        The topic or subject matter of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateTopic(String templateTopic);

        /**
         * <p>
         * The intended use case for the template.
         * </p>
         * 
         * @param templateUseCase
         *        The intended use case for the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateUseCase(String templateUseCase);

        /**
         * <p>
         * The industries the template is designed for.
         * </p>
         * 
         * @param templateIndustry
         *        The industries the template is designed for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateIndustry(Collection<String> templateIndustry);

        /**
         * <p>
         * The industries the template is designed for.
         * </p>
         * 
         * @param templateIndustry
         *        The industries the template is designed for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateIndustry(String... templateIndustry);

        /**
         * <p>
         * The header text of the template.
         * </p>
         * 
         * @param templateHeader
         *        The header text of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateHeader(String templateHeader);

        /**
         * <p>
         * The body text of the template.
         * </p>
         * 
         * @param templateBody
         *        The body text of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateBody(String templateBody);

        /**
         * <p>
         * The buttons included in the template.
         * </p>
         * 
         * @param templateButtons
         *        The buttons included in the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateButtons(Collection<LibraryTemplateButtonList> templateButtons);

        /**
         * <p>
         * The buttons included in the template.
         * </p>
         * 
         * @param templateButtons
         *        The buttons included in the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateButtons(LibraryTemplateButtonList... templateButtons);

        /**
         * <p>
         * The buttons included in the template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.socialmessaging.model.LibraryTemplateButtonList.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.socialmessaging.model.LibraryTemplateButtonList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.socialmessaging.model.LibraryTemplateButtonList.Builder#build()} is
         * called immediately and its result is passed to {@link #templateButtons(List<LibraryTemplateButtonList>)}.
         * 
         * @param templateButtons
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.socialmessaging.model.LibraryTemplateButtonList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateButtons(java.util.Collection<LibraryTemplateButtonList>)
         */
        Builder templateButtons(Consumer<LibraryTemplateButtonList.Builder>... templateButtons);

        /**
         * <p>
         * The ID of the template in Meta's library.
         * </p>
         * 
         * @param templateId
         *        The ID of the template in Meta's library.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);
    }

    static final class BuilderImpl implements Builder {
        private String templateName;

        private String templateLanguage;

        private String templateCategory;

        private String templateTopic;

        private String templateUseCase;

        private List<String> templateIndustry = DefaultSdkAutoConstructList.getInstance();

        private String templateHeader;

        private String templateBody;

        private List<LibraryTemplateButtonList> templateButtons = DefaultSdkAutoConstructList.getInstance();

        private String templateId;

        private BuilderImpl() {
        }

        private BuilderImpl(MetaLibraryTemplateDefinition model) {
            templateName(model.templateName);
            templateLanguage(model.templateLanguage);
            templateCategory(model.templateCategory);
            templateTopic(model.templateTopic);
            templateUseCase(model.templateUseCase);
            templateIndustry(model.templateIndustry);
            templateHeader(model.templateHeader);
            templateBody(model.templateBody);
            templateButtons(model.templateButtons);
            templateId(model.templateId);
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getTemplateLanguage() {
            return templateLanguage;
        }

        public final void setTemplateLanguage(String templateLanguage) {
            this.templateLanguage = templateLanguage;
        }

        @Override
        public final Builder templateLanguage(String templateLanguage) {
            this.templateLanguage = templateLanguage;
            return this;
        }

        public final String getTemplateCategory() {
            return templateCategory;
        }

        public final void setTemplateCategory(String templateCategory) {
            this.templateCategory = templateCategory;
        }

        @Override
        public final Builder templateCategory(String templateCategory) {
            this.templateCategory = templateCategory;
            return this;
        }

        public final String getTemplateTopic() {
            return templateTopic;
        }

        public final void setTemplateTopic(String templateTopic) {
            this.templateTopic = templateTopic;
        }

        @Override
        public final Builder templateTopic(String templateTopic) {
            this.templateTopic = templateTopic;
            return this;
        }

        public final String getTemplateUseCase() {
            return templateUseCase;
        }

        public final void setTemplateUseCase(String templateUseCase) {
            this.templateUseCase = templateUseCase;
        }

        @Override
        public final Builder templateUseCase(String templateUseCase) {
            this.templateUseCase = templateUseCase;
            return this;
        }

        public final Collection<String> getTemplateIndustry() {
            if (templateIndustry instanceof SdkAutoConstructList) {
                return null;
            }
            return templateIndustry;
        }

        public final void setTemplateIndustry(Collection<String> templateIndustry) {
            this.templateIndustry = MetaIndustriesCopier.copy(templateIndustry);
        }

        @Override
        public final Builder templateIndustry(Collection<String> templateIndustry) {
            this.templateIndustry = MetaIndustriesCopier.copy(templateIndustry);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateIndustry(String... templateIndustry) {
            templateIndustry(Arrays.asList(templateIndustry));
            return this;
        }

        public final String getTemplateHeader() {
            return templateHeader;
        }

        public final void setTemplateHeader(String templateHeader) {
            this.templateHeader = templateHeader;
        }

        @Override
        public final Builder templateHeader(String templateHeader) {
            this.templateHeader = templateHeader;
            return this;
        }

        public final String getTemplateBody() {
            return templateBody;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final List<LibraryTemplateButtonList.Builder> getTemplateButtons() {
            List<LibraryTemplateButtonList.Builder> result = MetaLibraryTemplateButtonListCopier
                    .copyToBuilder(this.templateButtons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTemplateButtons(Collection<LibraryTemplateButtonList.BuilderImpl> templateButtons) {
            this.templateButtons = MetaLibraryTemplateButtonListCopier.copyFromBuilder(templateButtons);
        }

        @Override
        public final Builder templateButtons(Collection<LibraryTemplateButtonList> templateButtons) {
            this.templateButtons = MetaLibraryTemplateButtonListCopier.copy(templateButtons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateButtons(LibraryTemplateButtonList... templateButtons) {
            templateButtons(Arrays.asList(templateButtons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateButtons(Consumer<LibraryTemplateButtonList.Builder>... templateButtons) {
            templateButtons(Stream.of(templateButtons).map(c -> LibraryTemplateButtonList.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTemplateId() {
            return templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        @Override
        public MetaLibraryTemplateDefinition build() {
            return new MetaLibraryTemplateDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
