/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of a WhatsApp message template's key attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateSummary implements SdkPojo, Serializable, ToCopyableBuilder<TemplateSummary.Builder, TemplateSummary> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateName").getter(getter(TemplateSummary::templateName)).setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()).build();

    private static final SdkField<String> META_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metaTemplateId").getter(getter(TemplateSummary::metaTemplateId)).setter(setter(Builder::metaTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metaTemplateId").build()).build();

    private static final SdkField<String> TEMPLATE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateStatus").getter(getter(TemplateSummary::templateStatus)).setter(setter(Builder::templateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateStatus").build()).build();

    private static final SdkField<String> TEMPLATE_QUALITY_SCORE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateQualityScore").getter(getter(TemplateSummary::templateQualityScore))
            .setter(setter(Builder::templateQualityScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateQualityScore").build())
            .build();

    private static final SdkField<String> TEMPLATE_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateLanguage").getter(getter(TemplateSummary::templateLanguage))
            .setter(setter(Builder::templateLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateLanguage").build()).build();

    private static final SdkField<String> TEMPLATE_CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateCategory").getter(getter(TemplateSummary::templateCategory))
            .setter(setter(Builder::templateCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateCategory").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD,
            META_TEMPLATE_ID_FIELD, TEMPLATE_STATUS_FIELD, TEMPLATE_QUALITY_SCORE_FIELD, TEMPLATE_LANGUAGE_FIELD,
            TEMPLATE_CATEGORY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String templateName;

    private final String metaTemplateId;

    private final String templateStatus;

    private final String templateQualityScore;

    private final String templateLanguage;

    private final String templateCategory;

    private TemplateSummary(BuilderImpl builder) {
        this.templateName = builder.templateName;
        this.metaTemplateId = builder.metaTemplateId;
        this.templateStatus = builder.templateStatus;
        this.templateQualityScore = builder.templateQualityScore;
        this.templateLanguage = builder.templateLanguage;
        this.templateCategory = builder.templateCategory;
    }

    /**
     * <p>
     * The name of the template.
     * </p>
     * 
     * @return The name of the template.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The numeric ID assigned to the template by Meta.
     * </p>
     * 
     * @return The numeric ID assigned to the template by Meta.
     */
    public final String metaTemplateId() {
        return metaTemplateId;
    }

    /**
     * <p>
     * The current status of the template (for example, APPROVED, PENDING, or REJECTED).
     * </p>
     * 
     * @return The current status of the template (for example, APPROVED, PENDING, or REJECTED).
     */
    public final String templateStatus() {
        return templateStatus;
    }

    /**
     * <p>
     * The quality score assigned to the template by Meta.
     * </p>
     * 
     * @return The quality score assigned to the template by Meta.
     */
    public final String templateQualityScore() {
        return templateQualityScore;
    }

    /**
     * <p>
     * The language code of the template (for example, en_US).
     * </p>
     * 
     * @return The language code of the template (for example, en_US).
     */
    public final String templateLanguage() {
        return templateLanguage;
    }

    /**
     * <p>
     * The category of the template (for example, UTILITY or MARKETING).
     * </p>
     * 
     * @return The category of the template (for example, UTILITY or MARKETING).
     */
    public final String templateCategory() {
        return templateCategory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(metaTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(templateStatus());
        hashCode = 31 * hashCode + Objects.hashCode(templateQualityScore());
        hashCode = 31 * hashCode + Objects.hashCode(templateLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(templateCategory());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateSummary)) {
            return false;
        }
        TemplateSummary other = (TemplateSummary) obj;
        return Objects.equals(templateName(), other.templateName()) && Objects.equals(metaTemplateId(), other.metaTemplateId())
                && Objects.equals(templateStatus(), other.templateStatus())
                && Objects.equals(templateQualityScore(), other.templateQualityScore())
                && Objects.equals(templateLanguage(), other.templateLanguage())
                && Objects.equals(templateCategory(), other.templateCategory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TemplateSummary").add("TemplateName", templateName()).add("MetaTemplateId", metaTemplateId())
                .add("TemplateStatus", templateStatus()).add("TemplateQualityScore", templateQualityScore())
                .add("TemplateLanguage", templateLanguage()).add("TemplateCategory", templateCategory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "templateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "metaTemplateId":
            return Optional.ofNullable(clazz.cast(metaTemplateId()));
        case "templateStatus":
            return Optional.ofNullable(clazz.cast(templateStatus()));
        case "templateQualityScore":
            return Optional.ofNullable(clazz.cast(templateQualityScore()));
        case "templateLanguage":
            return Optional.ofNullable(clazz.cast(templateLanguage()));
        case "templateCategory":
            return Optional.ofNullable(clazz.cast(templateCategory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("templateName", TEMPLATE_NAME_FIELD);
        map.put("metaTemplateId", META_TEMPLATE_ID_FIELD);
        map.put("templateStatus", TEMPLATE_STATUS_FIELD);
        map.put("templateQualityScore", TEMPLATE_QUALITY_SCORE_FIELD);
        map.put("templateLanguage", TEMPLATE_LANGUAGE_FIELD);
        map.put("templateCategory", TEMPLATE_CATEGORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TemplateSummary, T> g) {
        return obj -> g.apply((TemplateSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateSummary> {
        /**
         * <p>
         * The name of the template.
         * </p>
         * 
         * @param templateName
         *        The name of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The numeric ID assigned to the template by Meta.
         * </p>
         * 
         * @param metaTemplateId
         *        The numeric ID assigned to the template by Meta.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metaTemplateId(String metaTemplateId);

        /**
         * <p>
         * The current status of the template (for example, APPROVED, PENDING, or REJECTED).
         * </p>
         * 
         * @param templateStatus
         *        The current status of the template (for example, APPROVED, PENDING, or REJECTED).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateStatus(String templateStatus);

        /**
         * <p>
         * The quality score assigned to the template by Meta.
         * </p>
         * 
         * @param templateQualityScore
         *        The quality score assigned to the template by Meta.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateQualityScore(String templateQualityScore);

        /**
         * <p>
         * The language code of the template (for example, en_US).
         * </p>
         * 
         * @param templateLanguage
         *        The language code of the template (for example, en_US).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateLanguage(String templateLanguage);

        /**
         * <p>
         * The category of the template (for example, UTILITY or MARKETING).
         * </p>
         * 
         * @param templateCategory
         *        The category of the template (for example, UTILITY or MARKETING).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateCategory(String templateCategory);
    }

    static final class BuilderImpl implements Builder {
        private String templateName;

        private String metaTemplateId;

        private String templateStatus;

        private String templateQualityScore;

        private String templateLanguage;

        private String templateCategory;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateSummary model) {
            templateName(model.templateName);
            metaTemplateId(model.metaTemplateId);
            templateStatus(model.templateStatus);
            templateQualityScore(model.templateQualityScore);
            templateLanguage(model.templateLanguage);
            templateCategory(model.templateCategory);
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getMetaTemplateId() {
            return metaTemplateId;
        }

        public final void setMetaTemplateId(String metaTemplateId) {
            this.metaTemplateId = metaTemplateId;
        }

        @Override
        public final Builder metaTemplateId(String metaTemplateId) {
            this.metaTemplateId = metaTemplateId;
            return this;
        }

        public final String getTemplateStatus() {
            return templateStatus;
        }

        public final void setTemplateStatus(String templateStatus) {
            this.templateStatus = templateStatus;
        }

        @Override
        public final Builder templateStatus(String templateStatus) {
            this.templateStatus = templateStatus;
            return this;
        }

        public final String getTemplateQualityScore() {
            return templateQualityScore;
        }

        public final void setTemplateQualityScore(String templateQualityScore) {
            this.templateQualityScore = templateQualityScore;
        }

        @Override
        public final Builder templateQualityScore(String templateQualityScore) {
            this.templateQualityScore = templateQualityScore;
            return this;
        }

        public final String getTemplateLanguage() {
            return templateLanguage;
        }

        public final void setTemplateLanguage(String templateLanguage) {
            this.templateLanguage = templateLanguage;
        }

        @Override
        public final Builder templateLanguage(String templateLanguage) {
            this.templateLanguage = templateLanguage;
            return this;
        }

        public final String getTemplateCategory() {
            return templateCategory;
        }

        public final void setTemplateCategory(String templateCategory) {
            this.templateCategory = templateCategory;
        }

        @Override
        public final Builder templateCategory(String templateCategory) {
            this.templateCategory = templateCategory;
            return this;
        }

        @Override
        public TemplateSummary build() {
            return new TemplateSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
