/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of linking a WhatsApp Business Account to your Amazon Web Services account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WhatsAppSetupFinalization implements SdkPojo, Serializable,
        ToCopyableBuilder<WhatsAppSetupFinalization.Builder, WhatsAppSetupFinalization> {
    private static final SdkField<String> ASSOCIATE_IN_PROGRESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associateInProgressToken").getter(getter(WhatsAppSetupFinalization::associateInProgressToken))
            .setter(setter(Builder::associateInProgressToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associateInProgressToken").build())
            .build();

    private static final SdkField<List<WabaPhoneNumberSetupFinalization>> PHONE_NUMBERS_FIELD = SdkField
            .<List<WabaPhoneNumberSetupFinalization>> builder(MarshallingType.LIST)
            .memberName("phoneNumbers")
            .getter(getter(WhatsAppSetupFinalization::phoneNumbers))
            .setter(setter(Builder::phoneNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phoneNumbers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WabaPhoneNumberSetupFinalization> builder(MarshallingType.SDK_POJO)
                                            .constructor(WabaPhoneNumberSetupFinalization::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PHONE_NUMBER_PARENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("phoneNumberParent").getter(getter(WhatsAppSetupFinalization::phoneNumberParent))
            .setter(setter(Builder::phoneNumberParent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phoneNumberParent").build()).build();

    private static final SdkField<WabaSetupFinalization> WABA_FIELD = SdkField
            .<WabaSetupFinalization> builder(MarshallingType.SDK_POJO).memberName("waba")
            .getter(getter(WhatsAppSetupFinalization::waba)).setter(setter(Builder::waba))
            .constructor(WabaSetupFinalization::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waba").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ASSOCIATE_IN_PROGRESS_TOKEN_FIELD, PHONE_NUMBERS_FIELD, PHONE_NUMBER_PARENT_FIELD, WABA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String associateInProgressToken;

    private final List<WabaPhoneNumberSetupFinalization> phoneNumbers;

    private final String phoneNumberParent;

    private final WabaSetupFinalization waba;

    private WhatsAppSetupFinalization(BuilderImpl builder) {
        this.associateInProgressToken = builder.associateInProgressToken;
        this.phoneNumbers = builder.phoneNumbers;
        this.phoneNumberParent = builder.phoneNumberParent;
        this.waba = builder.waba;
    }

    /**
     * <p>
     * An Amazon Web Services access token generated by <code>WhatsAppSignupCallback</code> and used by
     * <code>WhatsAppSetupFinalization</code>.
     * </p>
     * 
     * @return An Amazon Web Services access token generated by <code>WhatsAppSignupCallback</code> and used by
     *         <code>WhatsAppSetupFinalization</code>.
     */
    public final String associateInProgressToken() {
        return associateInProgressToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PhoneNumbers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPhoneNumbers() {
        return phoneNumbers != null && !(phoneNumbers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of WabaPhoneNumberSetupFinalization objects containing the details of each phone number associated with
     * the WhatsApp Business Account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhoneNumbers} method.
     * </p>
     * 
     * @return An array of WabaPhoneNumberSetupFinalization objects containing the details of each phone number
     *         associated with the WhatsApp Business Account.
     */
    public final List<WabaPhoneNumberSetupFinalization> phoneNumbers() {
        return phoneNumbers;
    }

    /**
     * <p>
     * Used to add a new phone number to an existing WhatsApp Business Account. This field can't be used when the
     * <code>waba</code> field is present.
     * </p>
     * 
     * @return Used to add a new phone number to an existing WhatsApp Business Account. This field can't be used when
     *         the <code>waba</code> field is present.
     */
    public final String phoneNumberParent() {
        return phoneNumberParent;
    }

    /**
     * <p>
     * Used to create a new WhatsApp Business Account and add a phone number. This field can't be used when the
     * <code>phoneNumberParent</code> field is present.
     * </p>
     * 
     * @return Used to create a new WhatsApp Business Account and add a phone number. This field can't be used when the
     *         <code>phoneNumberParent</code> field is present.
     */
    public final WabaSetupFinalization waba() {
        return waba;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associateInProgressToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasPhoneNumbers() ? phoneNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberParent());
        hashCode = 31 * hashCode + Objects.hashCode(waba());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WhatsAppSetupFinalization)) {
            return false;
        }
        WhatsAppSetupFinalization other = (WhatsAppSetupFinalization) obj;
        return Objects.equals(associateInProgressToken(), other.associateInProgressToken())
                && hasPhoneNumbers() == other.hasPhoneNumbers() && Objects.equals(phoneNumbers(), other.phoneNumbers())
                && Objects.equals(phoneNumberParent(), other.phoneNumberParent()) && Objects.equals(waba(), other.waba());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WhatsAppSetupFinalization")
                .add("AssociateInProgressToken", associateInProgressToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PhoneNumbers", hasPhoneNumbers() ? phoneNumbers() : null).add("PhoneNumberParent", phoneNumberParent())
                .add("Waba", waba()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "associateInProgressToken":
            return Optional.ofNullable(clazz.cast(associateInProgressToken()));
        case "phoneNumbers":
            return Optional.ofNullable(clazz.cast(phoneNumbers()));
        case "phoneNumberParent":
            return Optional.ofNullable(clazz.cast(phoneNumberParent()));
        case "waba":
            return Optional.ofNullable(clazz.cast(waba()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("associateInProgressToken", ASSOCIATE_IN_PROGRESS_TOKEN_FIELD);
        map.put("phoneNumbers", PHONE_NUMBERS_FIELD);
        map.put("phoneNumberParent", PHONE_NUMBER_PARENT_FIELD);
        map.put("waba", WABA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WhatsAppSetupFinalization, T> g) {
        return obj -> g.apply((WhatsAppSetupFinalization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WhatsAppSetupFinalization> {
        /**
         * <p>
         * An Amazon Web Services access token generated by <code>WhatsAppSignupCallback</code> and used by
         * <code>WhatsAppSetupFinalization</code>.
         * </p>
         * 
         * @param associateInProgressToken
         *        An Amazon Web Services access token generated by <code>WhatsAppSignupCallback</code> and used by
         *        <code>WhatsAppSetupFinalization</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associateInProgressToken(String associateInProgressToken);

        /**
         * <p>
         * An array of WabaPhoneNumberSetupFinalization objects containing the details of each phone number associated
         * with the WhatsApp Business Account.
         * </p>
         * 
         * @param phoneNumbers
         *        An array of WabaPhoneNumberSetupFinalization objects containing the details of each phone number
         *        associated with the WhatsApp Business Account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumbers(Collection<WabaPhoneNumberSetupFinalization> phoneNumbers);

        /**
         * <p>
         * An array of WabaPhoneNumberSetupFinalization objects containing the details of each phone number associated
         * with the WhatsApp Business Account.
         * </p>
         * 
         * @param phoneNumbers
         *        An array of WabaPhoneNumberSetupFinalization objects containing the details of each phone number
         *        associated with the WhatsApp Business Account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumbers(WabaPhoneNumberSetupFinalization... phoneNumbers);

        /**
         * <p>
         * An array of WabaPhoneNumberSetupFinalization objects containing the details of each phone number associated
         * with the WhatsApp Business Account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.socialmessaging.model.WabaPhoneNumberSetupFinalization.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.socialmessaging.model.WabaPhoneNumberSetupFinalization#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.socialmessaging.model.WabaPhoneNumberSetupFinalization.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #phoneNumbers(List<WabaPhoneNumberSetupFinalization>)}.
         * 
         * @param phoneNumbers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.socialmessaging.model.WabaPhoneNumberSetupFinalization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phoneNumbers(java.util.Collection<WabaPhoneNumberSetupFinalization>)
         */
        Builder phoneNumbers(Consumer<WabaPhoneNumberSetupFinalization.Builder>... phoneNumbers);

        /**
         * <p>
         * Used to add a new phone number to an existing WhatsApp Business Account. This field can't be used when the
         * <code>waba</code> field is present.
         * </p>
         * 
         * @param phoneNumberParent
         *        Used to add a new phone number to an existing WhatsApp Business Account. This field can't be used when
         *        the <code>waba</code> field is present.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberParent(String phoneNumberParent);

        /**
         * <p>
         * Used to create a new WhatsApp Business Account and add a phone number. This field can't be used when the
         * <code>phoneNumberParent</code> field is present.
         * </p>
         * 
         * @param waba
         *        Used to create a new WhatsApp Business Account and add a phone number. This field can't be used when
         *        the <code>phoneNumberParent</code> field is present.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waba(WabaSetupFinalization waba);

        /**
         * <p>
         * Used to create a new WhatsApp Business Account and add a phone number. This field can't be used when the
         * <code>phoneNumberParent</code> field is present.
         * </p>
         * This is a convenience method that creates an instance of the {@link WabaSetupFinalization.Builder} avoiding
         * the need to create one manually via {@link WabaSetupFinalization#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WabaSetupFinalization.Builder#build()} is called immediately and
         * its result is passed to {@link #waba(WabaSetupFinalization)}.
         * 
         * @param waba
         *        a consumer that will call methods on {@link WabaSetupFinalization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #waba(WabaSetupFinalization)
         */
        default Builder waba(Consumer<WabaSetupFinalization.Builder> waba) {
            return waba(WabaSetupFinalization.builder().applyMutation(waba).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String associateInProgressToken;

        private List<WabaPhoneNumberSetupFinalization> phoneNumbers = DefaultSdkAutoConstructList.getInstance();

        private String phoneNumberParent;

        private WabaSetupFinalization waba;

        private BuilderImpl() {
        }

        private BuilderImpl(WhatsAppSetupFinalization model) {
            associateInProgressToken(model.associateInProgressToken);
            phoneNumbers(model.phoneNumbers);
            phoneNumberParent(model.phoneNumberParent);
            waba(model.waba);
        }

        public final String getAssociateInProgressToken() {
            return associateInProgressToken;
        }

        public final void setAssociateInProgressToken(String associateInProgressToken) {
            this.associateInProgressToken = associateInProgressToken;
        }

        @Override
        public final Builder associateInProgressToken(String associateInProgressToken) {
            this.associateInProgressToken = associateInProgressToken;
            return this;
        }

        public final List<WabaPhoneNumberSetupFinalization.Builder> getPhoneNumbers() {
            List<WabaPhoneNumberSetupFinalization.Builder> result = WabaPhoneNumberSetupFinalizationListCopier
                    .copyToBuilder(this.phoneNumbers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhoneNumbers(Collection<WabaPhoneNumberSetupFinalization.BuilderImpl> phoneNumbers) {
            this.phoneNumbers = WabaPhoneNumberSetupFinalizationListCopier.copyFromBuilder(phoneNumbers);
        }

        @Override
        public final Builder phoneNumbers(Collection<WabaPhoneNumberSetupFinalization> phoneNumbers) {
            this.phoneNumbers = WabaPhoneNumberSetupFinalizationListCopier.copy(phoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(WabaPhoneNumberSetupFinalization... phoneNumbers) {
            phoneNumbers(Arrays.asList(phoneNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(Consumer<WabaPhoneNumberSetupFinalization.Builder>... phoneNumbers) {
            phoneNumbers(Stream.of(phoneNumbers).map(c -> WabaPhoneNumberSetupFinalization.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPhoneNumberParent() {
            return phoneNumberParent;
        }

        public final void setPhoneNumberParent(String phoneNumberParent) {
            this.phoneNumberParent = phoneNumberParent;
        }

        @Override
        public final Builder phoneNumberParent(String phoneNumberParent) {
            this.phoneNumberParent = phoneNumberParent;
            return this;
        }

        public final WabaSetupFinalization.Builder getWaba() {
            return waba != null ? waba.toBuilder() : null;
        }

        public final void setWaba(WabaSetupFinalization.BuilderImpl waba) {
            this.waba = waba != null ? waba.build() : null;
        }

        @Override
        public final Builder waba(WabaSetupFinalization waba) {
            this.waba = waba;
            return this;
        }

        @Override
        public WhatsAppSetupFinalization build() {
            return new WhatsAppSetupFinalization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
